/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.validation.modelloader;

import jakarta.inject.Inject;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.set.basis.constants.ValidationResult;
import org.eclipse.set.basis.files.ToolboxFile;
import org.eclipse.set.core.services.dialog.DialogService;
import org.eclipse.set.core.services.modelloader.ModelLoader;
import org.eclipse.set.core.services.validation.ValidationService;
import org.eclipse.set.feature.validation.Messages;
import org.eclipse.set.model.planpro.Layoutinformationen.PlanPro_Layoutinfo;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.ppmodel.extensions.PlanProLayoutInfoExtensions;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleExtensions;
import org.eclipse.swt.widgets.Shell;

public class ModelLoaderImpl
implements ModelLoader {
    @Inject
    private DialogService dialogService;
    @Inject
    private ValidationService validationService;
    @Inject
    @Translation
    Messages messages;

    public ModelLoader.ModelContents loadModel(ToolboxFile toolboxFile, Consumer<ValidationResult> storeValidationResult) {
        PlanPro_Schnittstelle planProModel = this.readPlanProModel(toolboxFile, storeValidationResult);
        PlanPro_Layoutinfo layoutInfo = this.readLayoutInformationen(toolboxFile, storeValidationResult);
        return new ModelLoader.ModelContents(planProModel, layoutInfo);
    }

    public ModelLoader.ModelContents loadModelSync(ToolboxFile toolboxFile, Consumer<ValidationResult> storeValidationResult, Shell shell) {
        try {
            return (ModelLoader.ModelContents)this.dialogService.showProgressUISync(shell, this.messages.ModelLoaderImpl_loadMsg, () -> this.loadModel(toolboxFile, storeValidationResult));
        }
        catch (ExecutionException e) {
            this.dialogService.error(shell, (Exception)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return null;
    }

    private PlanPro_Schnittstelle readPlanProModel(ToolboxFile toolboxFile, Consumer<ValidationResult> storeValidationResult) {
        ValidationResult validationResult = new ValidationResult(PlanPro_Schnittstelle.class);
        PlanPro_Schnittstelle schnitStelle = (PlanPro_Schnittstelle)this.validationService.checkLoad(toolboxFile, path -> {
            toolboxFile.openModel();
            return toolboxFile.getPlanProResource();
        }, PlanProSchnittstelleExtensions::readFrom, validationResult);
        validationResult = this.validationService.validateSource(validationResult, toolboxFile);
        storeValidationResult.accept(validationResult);
        return schnitStelle;
    }

    private PlanPro_Layoutinfo readLayoutInformationen(ToolboxFile toolboxFile, Consumer<ValidationResult> storeValidationResult) {
        Path layoutPath = toolboxFile.getLayoutPath();
        if (layoutPath == null || !layoutPath.toFile().exists()) {
            return null;
        }
        ValidationResult validationResult = new ValidationResult(PlanPro_Layoutinfo.class);
        PlanPro_Layoutinfo layoutInfo = (PlanPro_Layoutinfo)this.validationService.checkLoad(toolboxFile, path -> {
            toolboxFile.openLayout();
            return toolboxFile.getLayoutResource();
        }, PlanProLayoutInfoExtensions::readFrom, validationResult);
        validationResult = this.validationService.validateSource(validationResult, toolboxFile);
        storeValidationResult.accept(validationResult);
        return layoutInfo;
    }
}

