/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.export.fop;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Paths;
import org.apache.fop.apps.io.ResourceResolverFactory;
import org.apache.xmlgraphics.io.Resource;
import org.apache.xmlgraphics.io.ResourceResolver;

public class RelativeResourceResolver
implements ResourceResolver {
    private final ResourceResolver absoluteResolver;
    private final String basePath;

    public RelativeResourceResolver(ResourceResolver absoluteResolver, String relativeBaseDir) {
        this.absoluteResolver = absoluteResolver;
        this.basePath = relativeBaseDir;
    }

    public RelativeResourceResolver(String relativeBaseDir) {
        this(ResourceResolverFactory.createDefaultResourceResolver(), relativeBaseDir);
    }

    public Resource getResource(URI uri) throws IOException {
        if (!uri.isAbsolute()) {
            URI absoluteURI = Paths.get(this.basePath, uri.toString()).toAbsolutePath().toUri();
            return this.absoluteResolver.getResource(absoluteURI);
        }
        return this.absoluteResolver.getResource(uri);
    }

    public OutputStream getOutputStream(URI uri) throws IOException {
        if (!uri.isAbsolute()) {
            URI absoluteURI = Paths.get(this.basePath, uri.toString()).toAbsolutePath().toUri();
            return this.absoluteResolver.getOutputStream(absoluteURI);
        }
        return this.absoluteResolver.getOutputStream(uri);
    }
}

