/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.enums;

import org.eclipse.emf.common.util.Enumerator;

public class EnumTranslationUtils {
    private static final String ALTERNATIVE = "_Alternative";
    private static final String PRESENTATION = "_Presentation";
    private static final String SORTING = "_Sorting";
    private static final String XSBOOLEAN = "boolean_";

    public static String getKeyAlternative(String keyBasis) {
        return keyBasis + ALTERNATIVE;
    }

    public static String getKeyBasis(Boolean value) {
        return XSBOOLEAN + value.toString().toLowerCase();
    }

    public static String getKeyBasis(Enumerator enumerator) {
        return EnumTranslationUtils.transformToKey(enumerator.getName());
    }

    public static String getKeyBasis(String enumType, String enumValue) {
        String key = enumType + "_" + enumValue;
        return EnumTranslationUtils.transformToKey(key);
    }

    public static String getKeyPresentation(String keyBasis) {
        return keyBasis + PRESENTATION;
    }

    public static String getKeySorting(String keyBasis) {
        return keyBasis + SORTING;
    }

    private static String firstUpper(String value) {
        return value.substring(0, 1).toUpperCase() + value.substring(1);
    }

    private static String replaceWithCase(String value, String from, String to) {
        String fromLowerCase = from.toLowerCase();
        String fromUpperCase = EnumTranslationUtils.firstUpper(from);
        String toLowerCase = to.toLowerCase();
        String toUpperCase = EnumTranslationUtils.firstUpper(to);
        String replaceLower = value.replace(fromLowerCase, toLowerCase);
        return replaceLower.replace(fromUpperCase, toUpperCase);
    }

    private static String transformToKey(String key) {
        String result = new String(key);
        result = EnumTranslationUtils.replaceWithCase(result, "\u00e4", "ae");
        result = EnumTranslationUtils.replaceWithCase(result, "\u00f6", "oe");
        result = EnumTranslationUtils.replaceWithCase(result, "\u00fc", "ue");
        result = result.replace("\u00df", "ss");
        result = result.replace(" ", "_");
        result = result.replace("-", "_");
        result = result.replace("(", "_");
        result = result.replace(")", "_");
        result = result.replace("/", "_");
        result = result.replace(".", "_");
        result = result.replace("+", "P");
        result = result.replace("-", "M");
        return result;
    }
}

