/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.net4j.util.io.IORuntimeException;

public abstract class FileLock {
    private final File lockFile;

    private FileLock(File file) {
        this.lockFile = new File(file.getParentFile(), String.valueOf(file.getName()) + ".lock");
    }

    public final File getLockFile() {
        return this.lockFile;
    }

    public void release() {
        this.lockFile.delete();
    }

    public static FileLock forRead(File file) {
        return new ForRead(file);
    }

    public static FileLock forWrite(File file) {
        return new ForWrite(file);
    }

    /* synthetic */ FileLock(File file, FileLock fileLock) {
        this(file);
    }

    private static final class ForRead
    extends FileLock {
        private FileInputStream stream;

        public ForRead(File file) {
            super(file, null);
            File lockFile = this.getLockFile();
            while (true) {
                try {
                    this.stream = new FileInputStream(lockFile);
                    return;
                }
                catch (FileNotFoundException ex) {
                    try {
                        new FileOutputStream(lockFile).close();
                    }
                    catch (IOException ex1) {
                        throw new IORuntimeException(ex1);
                    }
                }
            }
        }

        @Override
        public void release() {
            try {
                this.stream.close();
            }
            catch (IOException ex) {
                throw new IORuntimeException(ex);
            }
            super.release();
        }
    }

    private static final class ForWrite
    extends FileLock {
        private FileOutputStream stream;

        public ForWrite(File file) {
            super(file, null);
            File lockFile = this.getLockFile();
            try {
                this.stream = new FileOutputStream(lockFile);
            }
            catch (IOException ex) {
                throw new IORuntimeException(ex);
            }
        }

        @Override
        public void release() {
            try {
                this.stream.close();
            }
            catch (IOException ex) {
                throw new IORuntimeException(ex);
            }
            super.release();
        }
    }
}

