/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.parser;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.locationtech.proj4j.InvalidValueException;
import org.locationtech.proj4j.Registry;
import org.locationtech.proj4j.datum.Datum;
import org.locationtech.proj4j.datum.Ellipsoid;
import org.locationtech.proj4j.datum.Grid;
import org.locationtech.proj4j.parser.DatumParameters;
import org.locationtech.proj4j.parser.Proj4Keyword;
import org.locationtech.proj4j.proj.ExtendedTransverseMercatorProjection;
import org.locationtech.proj4j.proj.Projection;
import org.locationtech.proj4j.proj.TransverseMercatorProjection;
import org.locationtech.proj4j.units.Angle;
import org.locationtech.proj4j.units.Unit;
import org.locationtech.proj4j.units.Units;

public class Proj4Parser {
    private Registry registry;

    public Proj4Parser(Registry registry) {
        this.registry = registry;
    }

    public CoordinateReferenceSystem parse(String name, String[] args) {
        if (args == null) {
            return null;
        }
        Map params = this.createParameterMap(args);
        Proj4Keyword.checkUnsupported(params.keySet());
        DatumParameters datumParam = new DatumParameters();
        this.parseDatum(params, datumParam);
        this.parseEllipsoid(params, datumParam);
        Datum datum = datumParam.getDatum();
        datum.setGrids(datumParam.getGrids());
        Ellipsoid ellipsoid = datum.getEllipsoid();
        Projection proj = this.parseProjection(params, ellipsoid);
        return new CoordinateReferenceSystem(name, args, datum, proj);
    }

    private Projection parseProjection(Map params, Ellipsoid ellipsoid) {
        Unit unit;
        Projection projection = null;
        String s = (String)params.get("proj");
        if (s != null) {
            projection = this.registry.getProjection(s);
            if (projection == null) {
                throw new InvalidValueException("Unknown projection: " + s);
            }
        } else {
            throw new InvalidValueException("Keyword 'proj' is a required parameter");
        }
        projection.setEllipsoid(ellipsoid);
        s = (String)params.get("alpha");
        if (s != null) {
            projection.setAlphaDegrees(Double.parseDouble(s));
        }
        if ((s = (String)params.get("lonc")) != null) {
            projection.setLonCDegrees(Double.parseDouble(s));
        }
        if ((s = (String)params.get("lat_0")) != null) {
            projection.setProjectionLatitudeDegrees(Proj4Parser.parseAngle(s));
        }
        if ((s = (String)params.get("lon_0")) != null) {
            projection.setProjectionLongitudeDegrees(Proj4Parser.parseAngle(s));
        }
        if ((s = (String)params.get("lat_1")) != null) {
            projection.setProjectionLatitude1Degrees(Proj4Parser.parseAngle(s));
        }
        if ((s = (String)params.get("lat_2")) != null) {
            projection.setProjectionLatitude2Degrees(Proj4Parser.parseAngle(s));
        }
        if ((s = (String)params.get("lat_ts")) != null) {
            projection.setTrueScaleLatitudeDegrees(Proj4Parser.parseAngle(s));
        }
        if ((s = (String)params.get("x_0")) != null) {
            projection.setFalseEasting(Double.parseDouble(s));
        }
        if ((s = (String)params.get("y_0")) != null) {
            projection.setFalseNorthing(Double.parseDouble(s));
        }
        if ((s = (String)params.get("k_0")) == null) {
            s = (String)params.get("k");
        }
        if (s != null) {
            projection.setScaleFactor(Double.parseDouble(s));
        }
        if (params.containsKey("no_uoff")) {
            projection.setNoUoff(true);
        }
        if ((s = (String)params.get("gamma")) != null) {
            projection.setGammaDegrees(Double.parseDouble(s));
        }
        if ((s = (String)params.get("units")) != null && (unit = Units.findUnits(s)) != null) {
            projection.setFromMetres(1.0 / unit.value);
            projection.setUnits(unit);
        }
        if ((s = (String)params.get("to_meter")) != null) {
            projection.setFromMetres(1.0 / Double.parseDouble(s));
        }
        if ((s = (String)params.get("h")) != null) {
            projection.setHeightOfOrbit(Double.parseDouble(s));
        }
        if (params.containsKey("south")) {
            projection.setSouthernHemisphere(true);
        }
        if ((s = (String)params.get("pm")) != null) {
            projection.setPrimeMeridian(s);
        }
        if ((s = (String)params.get("axis")) != null) {
            projection.setAxisOrder(s);
        }
        if ((s = (String)params.get("R")) != null) {
            projection.setRadius(Double.parseDouble(s));
        }
        if (projection instanceof TransverseMercatorProjection && (s = (String)params.get("zone")) != null) {
            ((TransverseMercatorProjection)projection).setUTMZone(Integer.parseInt(s));
        }
        if (projection instanceof ExtendedTransverseMercatorProjection && (s = (String)params.get("zone")) != null) {
            ((ExtendedTransverseMercatorProjection)projection).setUTMZone(Integer.parseInt(s));
        }
        projection.initialize();
        return projection;
    }

    private void parseDatum(Map params, DatumParameters datumParam) {
        String nadgrids;
        String code;
        String towgs84 = (String)params.get("towgs84");
        if (towgs84 != null) {
            double[] datumConvParams = this.parseToWGS84(towgs84);
            datumParam.setDatumTransform(datumConvParams);
        }
        if ((code = (String)params.get("datum")) != null) {
            Datum datum = this.registry.getDatum(code);
            if (datum == null) {
                throw new InvalidValueException("Unknown datum: " + code);
            }
            datumParam.setDatum(datum);
        }
        if ((nadgrids = (String)params.get("nadgrids")) != null) {
            try {
                datumParam.setGrids(Grid.fromNadGrids(nadgrids));
            }
            catch (IOException e) {
                throw new InvalidValueException("Unknown nadgrid: " + nadgrids);
            }
        }
    }

    private double[] parseToWGS84(String paramList) {
        String[] numStr = paramList.split(",");
        if (numStr.length != 3 && numStr.length != 7) {
            throw new InvalidValueException("Invalid number of values (must be 3 or 7) in +towgs84: " + paramList);
        }
        double[] param = new double[numStr.length];
        for (int i = 0; i < numStr.length; ++i) {
            param[i] = Double.parseDouble(numStr[i]);
        }
        if (param.length > 3 && param[3] == 0.0 && param[4] == 0.0 && param[5] == 0.0 && param[6] == 0.0) {
            param = new double[]{param[0], param[1], param[2]};
        }
        return param;
    }

    private void parseEllipsoid(Map params, DatumParameters datumParam) {
        String s;
        double b = 0.0;
        String code = (String)params.get("ellps");
        if (code != null) {
            Ellipsoid ellipsoid = this.registry.getEllipsoid(code);
            if (ellipsoid == null) {
                throw new InvalidValueException("Unknown ellipsoid: " + code);
            }
            datumParam.setEllipsoid(ellipsoid);
        }
        if ((s = (String)params.get("a")) != null) {
            double a = Double.parseDouble(s);
            datumParam.setA(a);
        }
        if ((s = (String)params.get("es")) != null) {
            double es = Double.parseDouble(s);
            datumParam.setES(es);
        }
        if ((s = (String)params.get("rf")) != null) {
            double rf = Double.parseDouble(s);
            datumParam.setRF(rf);
        }
        if ((s = (String)params.get("f")) != null) {
            double f = Double.parseDouble(s);
            datumParam.setF(f);
        }
        if ((s = (String)params.get("b")) != null) {
            b = Double.parseDouble(s);
            datumParam.setB(b);
        }
        if (b == 0.0) {
            b = datumParam.getA() * Math.sqrt(1.0 - datumParam.getES());
        }
        this.parseEllipsoidModifiers(params, datumParam);
    }

    private void parseEllipsoidModifiers(Map params, DatumParameters datumParam) {
        if (params.containsKey("R_A")) {
            datumParam.setR_A();
            return;
        }
    }

    private Map createParameterMap(String[] args) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            int index;
            String arg = args[i];
            if (arg.startsWith("+")) {
                arg = arg.substring(1);
            }
            if ((index = arg.indexOf(61)) != -1) {
                String key = arg.substring(0, index);
                String value = arg.substring(index + 1);
                params.put(key, value);
                continue;
            }
            params.put(arg, null);
        }
        return params;
    }

    private static double parseAngle(String s) {
        return Angle.parse(s);
    }
}

