/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.api.image;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.BorderedStyle;
import org.eclipse.sirius.diagram.ContainerStyle;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.StyleHelper;
import org.eclipse.sirius.diagram.description.style.BorderedStyleDescription;
import org.eclipse.sirius.diagram.description.style.ContainerStyleDescription;
import org.eclipse.sirius.diagram.description.style.NodeStyleDescription;
import org.eclipse.sirius.diagram.description.style.StyleFactory;
import org.eclipse.sirius.diagram.description.style.WorkspaceImageDescription;
import org.eclipse.sirius.diagram.model.business.internal.query.DDiagramElementContainerExperimentalQuery;
import org.eclipse.sirius.diagram.model.business.internal.query.DNodeContainerExperimentalQuery;
import org.eclipse.sirius.diagram.ui.business.internal.image.refresh.WorkspaceImageFigureRefresher;
import org.eclipse.sirius.diagram.ui.business.internal.query.CustomizableQuery;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;
import org.eclipse.sirius.viewpoint.Customizable;
import org.eclipse.sirius.viewpoint.LabelStyle;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.style.StyleDescription;
import org.eclipse.ui.IEditorPart;

public class WorkspaceImageHelper {
    public static final WorkspaceImageHelper INSTANCE = new WorkspaceImageHelper();

    public void updateStyle(BasicLabelStyle basicLabelStyle, String imagePath) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)basicLabelStyle);
        if (domain != null) {
            Command command = this.getWorkspacePathChangeCommand(domain, basicLabelStyle, imagePath);
            domain.getCommandStack().execute(command);
            this.refreshStyle();
        }
    }

    public void updateManyStyles(List<BasicLabelStyle> basicLabelStyles, String imagePath) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain(basicLabelStyles);
        if (domain != null) {
            CompoundCommand command = new CompoundCommand();
            for (BasicLabelStyle basicLabelStyle : basicLabelStyles) {
                command.append(this.getWorkspacePathChangeCommand(domain, basicLabelStyle, imagePath));
            }
            domain.getCommandStack().execute((Command)command);
            this.refreshStyle();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void refreshStyle() {
        IEditorPart activeEditor = EclipseUIUtil.getActiveEditor();
        IEditorPart iEditorPart = activeEditor;
        if (iEditorPart instanceof DiagramEditor) {
            void diagramEditor;
            DiagramEditor diagramEditor2 = (DiagramEditor)iEditorPart;
            DiagramEditor cfr_ignored_0 = (DiagramEditor)iEditorPart;
            WorkspaceImageFigureRefresher.refreshAllEditPart(diagramEditor.getDiagramEditPart());
        }
    }

    public Command getWorkspacePathChangeCommand(TransactionalEditingDomain domain, BasicLabelStyle basicLabelStyle, String workspacePath) {
        Command updateHeightCmd;
        Command updateWorkspacePathCmd = null;
        if (basicLabelStyle instanceof WorkspaceImage) {
            updateWorkspacePathCmd = SetCommand.create((EditingDomain)domain, (Object)basicLabelStyle, (Object)DiagramPackage.Literals.WORKSPACE_IMAGE__WORKSPACE_PATH, (Object)workspacePath);
            if (!basicLabelStyle.getCustomFeatures().contains((Object)DiagramPackage.Literals.WORKSPACE_IMAGE__WORKSPACE_PATH.getName())) {
                updateWorkspacePathCmd = updateWorkspacePathCmd.chain(AddCommand.create((EditingDomain)domain, (Object)basicLabelStyle, (Object)ViewpointPackage.Literals.CUSTOMIZABLE__CUSTOM_FEATURES, (Object)DiagramPackage.Literals.WORKSPACE_IMAGE__WORKSPACE_PATH.getName()));
            }
        } else {
            Object feature = this.getFeature(basicLabelStyle);
            Object newWorkspaceImageStyle = this.getNewWorkspaceImageStyle(basicLabelStyle, workspacePath);
            updateWorkspacePathCmd = SetCommand.create((EditingDomain)domain, (Object)basicLabelStyle.eContainer(), (Object)feature, (Object)newWorkspaceImageStyle);
        }
        if ((updateHeightCmd = this.getUpdateHeightCommand(domain, basicLabelStyle)) != null) {
            updateWorkspacePathCmd = updateWorkspacePathCmd.chain(updateHeightCmd);
        }
        return updateWorkspacePathCmd;
    }

    private Command getUpdateHeightCommand(TransactionalEditingDomain domain, BasicLabelStyle basicLabelStyle) {
        Size size;
        Node node;
        LayoutConstraint layoutConstraint;
        EObject next;
        Command updateHeightCommand = null;
        EObjectQuery eObjectQuery = new EObjectQuery(basicLabelStyle.eContainer());
        Collection inverseReferences = eObjectQuery.getInverseReferences(NotationPackage.Literals.VIEW__ELEMENT);
        if (!inverseReferences.isEmpty() && (next = (EObject)inverseReferences.iterator().next()) instanceof Node && (layoutConstraint = (node = (Node)next).getLayoutConstraint()) instanceof Size && (size = (Size)layoutConstraint).getHeight() != -1) {
            updateHeightCommand = SetCommand.create((EditingDomain)domain, (Object)size, (Object)NotationPackage.Literals.SIZE__HEIGHT, (Object)-1);
        }
        return updateHeightCommand;
    }

    private Object getFeature(BasicLabelStyle basicLabelStyle) {
        EReference feature = null;
        EObject container = basicLabelStyle.eContainer();
        if (container instanceof DNode) {
            feature = DiagramPackage.Literals.DNODE__OWNED_STYLE;
        } else if (container instanceof DDiagramElementContainer) {
            feature = DiagramPackage.Literals.DDIAGRAM_ELEMENT_CONTAINER__OWNED_STYLE;
        }
        return feature;
    }

    private Object getNewWorkspaceImageStyle(BasicLabelStyle basicLabelStyle, String workspacePath) {
        Style newWorkspaceImageStyle = null;
        WorkspaceImageDescription workspaceImageDescription = StyleFactory.eINSTANCE.createWorkspaceImageDescription();
        workspaceImageDescription.setWorkspacePath(workspacePath);
        DDiagramElement dde = (DDiagramElement)basicLabelStyle.eContainer();
        newWorkspaceImageStyle = this.createAndAffectWorkspaceImageCustomized(dde, workspaceImageDescription);
        if (basicLabelStyle != null && newWorkspaceImageStyle instanceof LabelStyle) {
            this.copyCustomizedProperties((Customizable)basicLabelStyle, (Customizable)newWorkspaceImageStyle);
        }
        if (basicLabelStyle instanceof BorderedStyle && newWorkspaceImageStyle instanceof WorkspaceImage) {
            this.copyBorderProperties(dde, (BorderedStyle)basicLabelStyle, (WorkspaceImage)newWorkspaceImageStyle, workspaceImageDescription);
        }
        newWorkspaceImageStyle.setDescription(((Style)basicLabelStyle).getDescription());
        return newWorkspaceImageStyle;
    }

    private void copyBorderProperties(DDiagramElement dde, BorderedStyle oldStyle, WorkspaceImage workspaceImage, WorkspaceImageDescription workspaceImageDescription) {
        if (dde instanceof DNodeContainer && new DNodeContainerExperimentalQuery((DNodeContainer)dde).isRegionContainer() || dde instanceof DDiagramElementContainer && new DDiagramElementContainerExperimentalQuery((DDiagramElementContainer)dde).isRegion()) {
            workspaceImage.setBorderColor(oldStyle.getBorderColor());
            workspaceImage.setBorderLineStyle(oldStyle.getBorderLineStyle());
            workspaceImage.setBorderSize(oldStyle.getBorderSize());
            StyleDescription oldDescription = oldStyle.getDescription();
            if (oldDescription instanceof BorderedStyleDescription) {
                BorderedStyleDescription oldDesc = (BorderedStyleDescription)oldDescription;
                workspaceImageDescription.setBorderColor(oldDesc.getBorderColor());
                workspaceImageDescription.setBorderLineStyle(oldDesc.getBorderLineStyle());
                workspaceImageDescription.setBorderSizeComputationExpression(oldDesc.getBorderSizeComputationExpression());
            }
        }
    }

    private Style createAndAffectWorkspaceImageCustomized(DDiagramElement dde, WorkspaceImageDescription wid) {
        Style newStyle = null;
        if (dde instanceof DNode) {
            newStyle = this.createAndAffectNodeStyle((DNode)dde, wid);
        } else if (dde instanceof DDiagramElementContainer) {
            newStyle = this.createAndAffectContainerStyle((DDiagramElementContainer)dde, wid);
        }
        if (newStyle != null) {
            newStyle.getCustomFeatures().add((Object)DiagramPackage.Literals.WORKSPACE_IMAGE__WORKSPACE_PATH.getName());
        }
        return newStyle;
    }

    private Style createAndAffectNodeStyle(DNode node, WorkspaceImageDescription wid) {
        Session session = SessionManager.INSTANCE.getSession(node.getTarget());
        NodeStyle myStyle = new StyleHelper(session.getInterpreter()).createNodeStyle((NodeStyleDescription)wid);
        return myStyle;
    }

    private Style createAndAffectContainerStyle(DDiagramElementContainer container, WorkspaceImageDescription wid) {
        Session session = SessionManager.INSTANCE.getSession(container.getTarget());
        ContainerStyle myStyle = new StyleHelper(session.getInterpreter()).createContainerStyle((ContainerStyleDescription)wid);
        return myStyle;
    }

    private void copyCustomizedProperties(Customizable source, Customizable target) {
        List<String> targetCustomizableFeatureNames = new CustomizableQuery(target).getCustomizableFeatureNames();
        List<String> sourceCustomizableFeatureNames = new CustomizableQuery(source).getCustomizableFeatureNames();
        for (EStructuralFeature sourceEStructuralFeature : source.eClass().getEAllStructuralFeatures()) {
            EObject targetEObjectValue;
            Object targetValue;
            EObject sourceEObjectValue;
            if (!sourceCustomizableFeatureNames.contains(sourceEStructuralFeature.getName())) continue;
            Object sourceValue = source.eGet(sourceEStructuralFeature);
            EStructuralFeature targetEStructuralFeature = target.eClass().getEStructuralFeature(sourceEStructuralFeature.getName());
            if (targetEStructuralFeature == null || targetEStructuralFeature.getEType() != sourceEStructuralFeature.getEType()) continue;
            if (targetCustomizableFeatureNames.contains(targetEStructuralFeature.getName())) {
                if (sourceValue instanceof EObject) {
                    sourceEObjectValue = (EObject)sourceValue;
                    targetValue = target.eGet(targetEStructuralFeature);
                    if (!(targetValue instanceof EObject)) continue;
                    targetEObjectValue = (EObject)targetValue;
                    if (sourceEObjectValue.eClass() != targetEObjectValue.eClass()) continue;
                    for (EAttribute sourceEAttribute : sourceEObjectValue.eClass().getEAllAttributes()) {
                        Object sourceEAttributeValue = sourceEObjectValue.eGet((EStructuralFeature)sourceEAttribute);
                        targetEObjectValue.eSet((EStructuralFeature)sourceEAttribute, sourceEAttributeValue);
                    }
                    continue;
                }
                target.eSet(targetEStructuralFeature, sourceValue);
                if (!source.getCustomFeatures().contains((Object)targetEStructuralFeature.getName())) continue;
                target.getCustomFeatures().add((Object)targetEStructuralFeature.getName());
                continue;
            }
            if (!(sourceValue instanceof Customizable)) continue;
            sourceEObjectValue = (Customizable)sourceValue;
            targetValue = target.eGet(targetEStructuralFeature);
            if (!(targetValue instanceof Customizable)) continue;
            targetEObjectValue = (Customizable)targetValue;
            if (sourceEObjectValue.eClass() != targetEObjectValue.eClass()) continue;
            this.copyCustomizedProperties((Customizable)sourceEObjectValue, (Customizable)targetEObjectValue);
        }
    }
}

