/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.properties.sections.description.layoutoption;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.diagram.description.BooleanLayoutOption;
import org.eclipse.sirius.diagram.description.CustomLayoutConfiguration;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DoubleLayoutOption;
import org.eclipse.sirius.diagram.description.EnumLayoutOption;
import org.eclipse.sirius.diagram.description.EnumSetLayoutOption;
import org.eclipse.sirius.diagram.description.IntegerLayoutOption;
import org.eclipse.sirius.diagram.description.LayoutOption;
import org.eclipse.sirius.diagram.description.StringLayoutOption;
import org.eclipse.sirius.editor.properties.ViewpointPropertySheetPage;
import org.eclipse.sirius.editor.properties.sections.common.AbstractViewpointPropertySection;
import org.eclipse.sirius.editor.properties.sections.description.layoutoption.AddOptionOverridePropertySection;
import org.eclipse.sirius.editor.properties.sections.description.layoutoption.BooleanLayoutOptionValuePropertySectionSpec;
import org.eclipse.sirius.editor.properties.sections.description.layoutoption.CustomLayoutConfigurationDescriptionPropertySection;
import org.eclipse.sirius.editor.properties.sections.description.layoutoption.DoubleLayoutOptionValuePropertySectionSpec;
import org.eclipse.sirius.editor.properties.sections.description.layoutoption.EnumLayoutOptionValuePropertySection;
import org.eclipse.sirius.editor.properties.sections.description.layoutoption.EnumSetLayoutOptionValuePropertySection;
import org.eclipse.sirius.editor.properties.sections.description.layoutoption.IntegerLayoutOptionValuePropertySectionSpec;
import org.eclipse.sirius.editor.properties.sections.description.layoutoption.StringLayoutOptionValuePropertySectionSpec;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class LayoutOptionPropertySection
extends AbstractViewpointPropertySection {
    private List<AbstractPropertySection> allLayoutOptionSections;
    private List<Composite> allLayoutOptionComposites;
    private AddOptionOverridePropertySection propertyOverridePropertySection;
    private AbstractViewpointPropertySection descriptionPropertySection;
    private Composite pageComposite;
    private Map<AbstractPropertySection, LayoutOption> optionSection2SemanticElement;

    protected void makeReadonly() {
    }

    protected void makeWrittable() {
    }

    protected EStructuralFeature getFeature() {
        return DescriptionPackage.eINSTANCE.getCustomLayoutConfiguration_LayoutOptions();
    }

    public void createControls(Composite sectionComposite, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        if (aTabbedPropertySheetPage instanceof ViewpointPropertySheetPage) {
            super.createControls(sectionComposite, (ViewpointPropertySheetPage)aTabbedPropertySheetPage);
        } else {
            super.createControls(sectionComposite, aTabbedPropertySheetPage);
        }
        this.pageComposite = sectionComposite.getParent();
        this.descriptionPropertySection = new CustomLayoutConfigurationDescriptionPropertySection();
        this.descriptionPropertySection.createControls(sectionComposite, aTabbedPropertySheetPage);
        this.propertyOverridePropertySection = new AddOptionOverridePropertySection();
        Composite addOverrideSectionComposite = this.createSectionComposite(this.pageComposite, aTabbedPropertySheetPage, (AbstractPropertySection)this.propertyOverridePropertySection);
        this.propertyOverridePropertySection.createControls(addOverrideSectionComposite, aTabbedPropertySheetPage);
        this.allLayoutOptionSections = new ArrayList<AbstractPropertySection>();
        this.allLayoutOptionComposites = new ArrayList<Composite>();
        this.optionSection2SemanticElement = new HashMap<AbstractPropertySection, LayoutOption>();
        this.initializeLayoutOptionSections((TabbedPropertySheetPage)this.propertySheetPage, false, this.getLayoutOptions());
    }

    private void initializeLayoutOptionSections(TabbedPropertySheetPage aTabbedPropertySheetPage, boolean setInput, EList<LayoutOption> layoutOptions) {
        ECollections.sort(layoutOptions, (Comparator)new Comparator<LayoutOption>(){

            @Override
            public int compare(LayoutOption o1, LayoutOption o2) {
                String l1 = o1.getLabel();
                String l2 = o2.getLabel();
                if (l1 == null) {
                    l1 = "";
                }
                if (l2 == null) {
                    l2 = "";
                }
                return l1.compareTo(l2);
            }
        });
        for (LayoutOption layoutOption : layoutOptions) {
            if (layoutOption instanceof StringLayoutOption) {
                StringLayoutOptionValuePropertySectionSpec stringLayoutOptionValuePropertySection = new StringLayoutOptionValuePropertySectionSpec(layoutOption);
                this.initLayoutOptionCompositeAndControls(aTabbedPropertySheetPage, layoutOption, (AbstractPropertySection)stringLayoutOptionValuePropertySection);
                if (!setInput) continue;
                stringLayoutOptionValuePropertySection.setInput(this.getPart(), (ISelection)new StructuredSelection((Object)layoutOption));
                continue;
            }
            if (layoutOption instanceof BooleanLayoutOption) {
                BooleanLayoutOptionValuePropertySectionSpec booleanLayoutOptionValuePropertySection = new BooleanLayoutOptionValuePropertySectionSpec(layoutOption);
                this.initLayoutOptionCompositeAndControls(aTabbedPropertySheetPage, layoutOption, (AbstractPropertySection)booleanLayoutOptionValuePropertySection);
                if (!setInput) continue;
                booleanLayoutOptionValuePropertySection.setInput(this.getPart(), (ISelection)new StructuredSelection((Object)layoutOption));
                continue;
            }
            if (layoutOption instanceof IntegerLayoutOption) {
                IntegerLayoutOptionValuePropertySectionSpec integerLayoutOptionValuePropertySection = new IntegerLayoutOptionValuePropertySectionSpec(layoutOption);
                this.initLayoutOptionCompositeAndControls(aTabbedPropertySheetPage, layoutOption, (AbstractPropertySection)integerLayoutOptionValuePropertySection);
                if (!setInput) continue;
                integerLayoutOptionValuePropertySection.setInput(this.getPart(), (ISelection)new StructuredSelection((Object)layoutOption));
                continue;
            }
            if (layoutOption instanceof DoubleLayoutOption) {
                DoubleLayoutOptionValuePropertySectionSpec doubleLayoutOptionValuePropertySection = new DoubleLayoutOptionValuePropertySectionSpec(layoutOption);
                this.initLayoutOptionCompositeAndControls(aTabbedPropertySheetPage, layoutOption, (AbstractPropertySection)doubleLayoutOptionValuePropertySection);
                if (!setInput) continue;
                doubleLayoutOptionValuePropertySection.setInput(this.getPart(), (ISelection)new StructuredSelection((Object)layoutOption));
                continue;
            }
            if (layoutOption instanceof EnumSetLayoutOption) {
                EnumSetLayoutOptionValuePropertySection enumSetLayoutOptionValuePropertySection = new EnumSetLayoutOptionValuePropertySection(layoutOption);
                this.initLayoutOptionCompositeAndControls(aTabbedPropertySheetPage, layoutOption, (AbstractPropertySection)enumSetLayoutOptionValuePropertySection);
                if (!setInput) continue;
                enumSetLayoutOptionValuePropertySection.setInput(this.getPart(), (ISelection)new StructuredSelection((Object)layoutOption));
                continue;
            }
            if (!(layoutOption instanceof EnumLayoutOption)) continue;
            EnumLayoutOptionValuePropertySection enumLayoutOptionValuePropertySection = new EnumLayoutOptionValuePropertySection(layoutOption);
            this.initLayoutOptionCompositeAndControls(aTabbedPropertySheetPage, layoutOption, (AbstractPropertySection)enumLayoutOptionValuePropertySection);
            if (!setInput) continue;
            enumLayoutOptionValuePropertySection.setInput(this.getPart(), (ISelection)new StructuredSelection((Object)layoutOption));
        }
    }

    private void initLayoutOptionCompositeAndControls(TabbedPropertySheetPage aTabbedPropertySheetPage, LayoutOption layoutOption, AbstractPropertySection layoutOptionValuePropertySection) {
        Composite stringOptionSectionComposite = this.createSectionComposite(this.pageComposite, aTabbedPropertySheetPage, layoutOptionValuePropertySection);
        this.allLayoutOptionComposites.add(stringOptionSectionComposite);
        layoutOptionValuePropertySection.createControls(stringOptionSectionComposite, aTabbedPropertySheetPage);
        this.allLayoutOptionSections.add(layoutOptionValuePropertySection);
        this.optionSection2SemanticElement.put(layoutOptionValuePropertySection, layoutOption);
        layoutOptionValuePropertySection.refresh();
    }

    private EList<LayoutOption> getLayoutOptions() {
        CustomLayoutConfiguration layoutConfiguration = (CustomLayoutConfiguration)this.eObject;
        EList layoutOptions = layoutConfiguration.getLayoutOptions();
        return layoutOptions;
    }

    private Composite createSectionComposite(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage, AbstractPropertySection propertySection) {
        Composite sectionComposite = aTabbedPropertySheetPage.getWidgetFactory().createComposite(parent, 524288);
        sectionComposite.setLayout((Layout)new FillLayout());
        int style = propertySection.shouldUseExtraSpace() ? 1808 : 768;
        GridData data = new GridData(style);
        data.heightHint = propertySection.getMinimumHeight();
        sectionComposite.setLayoutData((Object)data);
        return sectionComposite;
    }

    public void dispose() {
        for (AbstractPropertySection propertySection : this.allLayoutOptionSections) {
            propertySection.dispose();
        }
        for (Composite composite : this.allLayoutOptionComposites) {
            composite.dispose();
        }
        this.descriptionPropertySection.dispose();
        this.propertyOverridePropertySection.dispose();
        this.optionSection2SemanticElement.clear();
        super.dispose();
    }

    public void refresh() {
        EList<LayoutOption> layoutOptions = this.getLayoutOptions();
        if (layoutOptions.size() != this.allLayoutOptionSections.size()) {
            for (AbstractPropertySection propertySection : this.allLayoutOptionSections) {
                propertySection.dispose();
            }
            for (Composite composite : this.allLayoutOptionComposites) {
                composite.dispose();
            }
            this.allLayoutOptionSections.clear();
            this.allLayoutOptionComposites.clear();
            this.optionSection2SemanticElement.clear();
            this.initializeLayoutOptionSections((TabbedPropertySheetPage)this.propertySheetPage, true, this.getLayoutOptions());
            this.pageComposite.layout();
        }
        for (AbstractPropertySection propertySection : this.allLayoutOptionSections) {
            propertySection.refresh();
        }
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        for (AbstractPropertySection propertySection : this.allLayoutOptionSections) {
            propertySection.setInput(part, (ISelection)new StructuredSelection((Object)this.optionSection2SemanticElement.get(propertySection)));
        }
    }
}

