/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.support.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramDescriptionMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramDescriptionMappingsRegistry;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayServiceManager;
import org.eclipse.sirius.diagram.business.api.query.DiagramDescriptionMappingManagerQuery;
import org.eclipse.sirius.diagram.business.internal.metamodel.operations.DDiagramElementContainerWithInterpreterOperations;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.DragAndDropTargetDescription;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.diagram.description.tool.ContainerCreationDescription;
import org.eclipse.sirius.diagram.description.tool.ContainerDropDescription;
import org.eclipse.sirius.diagram.description.tool.DirectEditLabel;
import org.eclipse.sirius.diagram.description.tool.EdgeCreationDescription;
import org.eclipse.sirius.diagram.description.tool.NodeCreationDescription;
import org.eclipse.sirius.diagram.description.tool.ReconnectEdgeDescription;
import org.eclipse.sirius.diagram.tools.api.command.ChangeLayerActivationCommand;
import org.eclipse.sirius.diagram.tools.api.command.DiagramCommandFactoryService;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.tools.api.command.view.HideDDiagramElementLabel;
import org.eclipse.sirius.diagram.tools.api.command.view.RevealDDiagramElementsLabel;
import org.eclipse.sirius.diagram.tools.internal.management.UpdateToolRecordingCommand;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.tools.api.util.GMFNotationHelper;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.delete.DeleteFromDiagramAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.delete.DeleteFromModelAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.delete.DeleteWithHookAction;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.ResetStylePropertiesToDefaultValuesCommand;
import org.eclipse.sirius.diagram.ui.tools.internal.handler.ChangeFilterActivation;
import org.eclipse.sirius.tests.support.api.AbstractToolDescriptionTestCase;
import org.eclipse.sirius.tests.support.api.DiagramComponentizationTestSupport;
import org.eclipse.sirius.tests.support.api.EclipseTestsSupportHelper;
import org.eclipse.sirius.tests.support.api.TestsUtil;
import org.eclipse.sirius.tests.support.command.CreateNoteAttachmentRecordingCommand;
import org.eclipse.sirius.tests.support.command.CreateNoteRecordingCommand;
import org.eclipse.sirius.tools.api.command.ui.NoUICallback;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.DragSource;
import org.eclipse.sirius.viewpoint.description.tool.OperationAction;
import org.eclipse.sirius.viewpoint.description.tool.SelectionWizardDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolDescription;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;

public class SiriusDiagramTestCase
extends AbstractToolDescriptionTestCase {
    private static final String TOOL_NAME_INCORRECT = "The tool name is not correct";
    private static final String LAYER_NAME_INCORRECT = "The layer name is not correct (not found in the diagram description of this diagram)";
    private static final String FILTER_NAME_INCORRECT = "The filter name is not correct";
    private static final String MAPPING_NAME_INCORRECT = "The mapping name is not correct";
    private IDiagramCommandFactory commandFactory;

    protected IDiagramCommandFactory getCommandFactory() {
        if (this.commandFactory == null) {
            this.commandFactory = DiagramCommandFactoryService.getInstance().getNewProvider().getCommandFactory(this.session.getTransactionalEditingDomain());
            this.commandFactory.setUserInterfaceCallBack((UICallBack)new NoUICallback());
        }
        return this.commandFactory;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IViewPart outlineView = page.findView("org.eclipse.ui.views.ContentOutline");
                if (outlineView != null) {
                    page.hideView(outlineView);
                }
            }
        });
    }

    protected void arrangeAll(DiagramEditPart diagramEditPart) {
        ArrangeRequest arrangeRequest = new ArrangeRequest("arrangeAllAction");
        ArrayList<DiagramEditPart> partsToArrange = new ArrayList<DiagramEditPart>();
        partsToArrange.add(diagramEditPart);
        arrangeRequest.setPartsToArrange(partsToArrange);
        diagramEditPart.performRequest((Request)arrangeRequest);
    }

    protected final boolean applyContainerCreationTool(String toolName, DDiagram diagram, EObject container) {
        AbstractToolDescription tool = this.getTool(diagram, toolName);
        if (tool instanceof ContainerCreationDescription) {
            Command command = this.getCommand(container, tool);
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)container);
            boolean canExecute = command.canExecute();
            domain.getCommandStack().execute(command);
            return canExecute;
        }
        throw new IllegalArgumentException(TOOL_NAME_INCORRECT);
    }

    protected final boolean applyGenericTool(String toolName, DDiagram diagram, EObject container) {
        AbstractToolDescription tool = this.getTool(diagram, toolName);
        if (tool instanceof ToolDescription) {
            Command command = this.getCommand(container, tool);
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)container);
            boolean canExecute = command.canExecute();
            domain.getCommandStack().execute(command);
            return canExecute;
        }
        throw new IllegalArgumentException(TOOL_NAME_INCORRECT);
    }

    protected final boolean applyNodeCreationTool(String toolName, DDiagram diagram, EObject container) {
        AbstractToolDescription tool = this.getTool(diagram, toolName);
        if (tool != null) {
            Command command = this.getCommand(container, tool);
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)container);
            boolean canExecute = command.canExecute();
            domain.getCommandStack().execute(command);
            return canExecute;
        }
        throw new IllegalArgumentException(TOOL_NAME_INCORRECT);
    }

    protected final boolean applyNodeCreationTool(String layerName, String toolName, DDiagram diagram, EObject container) {
        AbstractToolDescription tool;
        boolean result = false;
        Layer layer = this.getLayer(diagram, layerName);
        if (layer != null && (tool = this.getTool(layer, toolName)) != null) {
            Command command = this.getCommand(container, tool);
            result = command.canExecute();
            this.session.getTransactionalEditingDomain().getCommandStack().execute(command);
        }
        return result;
    }

    protected final boolean applySelectionTool(String toolName, DDiagram diagram, EObject container) {
        boolean result = false;
        AbstractToolDescription tool = this.getTool(diagram, toolName);
        if (tool != null) {
            Collection<EObject> selectedElements = this.getSelectedEObject(tool, diagram, container);
            Command command = this.getCommand(container, tool, selectedElements);
            result = command.canExecute();
            this.session.getTransactionalEditingDomain().getCommandStack().execute(command);
        }
        return result;
    }

    protected final boolean applySelectionTool(String layerName, String toolName, DDiagram diagram, EObject container) {
        AbstractToolDescription tool;
        boolean result = false;
        Layer layer = this.getLayer(diagram, layerName);
        if (layer != null && (tool = this.getTool(layer, toolName)) != null) {
            Collection<EObject> selectedElements = this.getSelectedEObject(tool, diagram, container);
            Command command = this.getCommand(container, tool, selectedElements);
            result = command.canExecute();
            this.session.getTransactionalEditingDomain().getCommandStack().execute(command);
        }
        return result;
    }

    protected void delete(EditPart ... editParts) {
        DeleteFromModelAction actionDelegate = new DeleteFromModelAction();
        IEditorPart editor = EclipseUIUtil.getActiveEditor();
        GraphicalViewer viewer = (GraphicalViewer)editor.getAdapter(GraphicalViewer.class);
        EditPart[] editPartArray = editParts;
        int n = editParts.length;
        int n2 = 0;
        while (n2 < n) {
            EditPart editPart = editPartArray[n2];
            viewer.appendSelection(editPart);
            ++n2;
        }
        TestsUtil.synchronizationWithUIThread();
        actionDelegate.run();
        TestsUtil.synchronizationWithUIThread();
    }

    protected void deleteViaKeyboard(EditPart editPart) {
        IEditorPart editor = EclipseUIUtil.getActiveEditor();
        DeleteWithHookAction actionDelegate = new DeleteWithHookAction((IWorkbenchPart)editor);
        GraphicalViewer viewer = (GraphicalViewer)editor.getAdapter(GraphicalViewer.class);
        viewer.appendSelection(editPart);
        actionDelegate.update();
        actionDelegate.run();
    }

    protected void deleteFromDiagram(EditPart editPart) {
        DeleteFromDiagramAction actionDelegate = new DeleteFromDiagramAction();
        IEditorPart editor = EclipseUIUtil.getActiveEditor();
        GraphicalViewer viewer = (GraphicalViewer)editor.getAdapter(GraphicalViewer.class);
        viewer.appendSelection(editPart);
        Action mockAction = new Action(){};
        actionDelegate.selectionChanged((IAction)mockAction, viewer.getSelection());
        actionDelegate.run((IAction)mockAction);
    }

    protected final boolean dropSemantic(EObject semanticElement, DragAndDropTarget containerView, DDiagramElement diagramElt) {
        ContainerDropDescription dropTool;
        boolean result = false;
        DragAndDropTargetDescription dragDragAndDropDescription = containerView.getDragAndDropDescription();
        if (dragDragAndDropDescription != null && (dropTool = DDiagramElementContainerWithInterpreterOperations.getBestDropDescription((DragAndDropTargetDescription)dragDragAndDropDescription, (EObject)semanticElement, null, (EObject)((DSemanticDecorator)containerView).getTarget(), (EObject)containerView, (DragSource)DragSource.PROJECT_EXPLORER_LITERAL, (EObject)diagramElt)) != null) {
            Command command = this.getCommandFactory().buildDropInContainerCommandFromTool(containerView, semanticElement, dropTool);
            result = command.canExecute();
            this.session.getTransactionalEditingDomain().getCommandStack().execute(command);
        }
        return result;
    }

    protected final boolean createNote(DDiagram diagram, String noteText) {
        boolean result = false;
        Diagram gmfDiagram = this.getGmfDiagram(diagram);
        CreateNoteRecordingCommand createNoteCmd = new CreateNoteRecordingCommand(this.session.getTransactionalEditingDomain(), gmfDiagram, noteText);
        result = createNoteCmd.canExecute();
        this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)createNoteCmd);
        return result;
    }

    protected final boolean attachNote(String noteText, DDiagramElement diagramElement) {
        boolean result = false;
        Node gmfNode = this.getGmfNode(diagramElement);
        Diagram gmfDiagram = (Diagram)GMFNotationHelper.getGMFDiagrams((Resource)gmfNode.eResource()).iterator().next();
        for (Node note : GMFNotationHelper.getNotes((Diagram)gmfDiagram)) {
            String noteDescription = GMFNotationHelper.getNoteDescription((Node)note);
            if (!noteText.equals(noteDescription)) continue;
            CreateNoteAttachmentRecordingCommand createNoteAttachmentCmd = new CreateNoteAttachmentRecordingCommand(this.session.getTransactionalEditingDomain(), note, gmfNode);
            result = createNoteAttachmentCmd.canExecute();
            this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)createNoteAttachmentCmd);
        }
        return result;
    }

    protected Collection<EObject> getSelectedEObject(AbstractToolDescription tool, DDiagram diagram) {
        return this.getSelectedEObject(tool, diagram, (EObject)diagram);
    }

    protected Collection<EObject> getSelectedEObject(AbstractToolDescription tool, DDiagram diagram, EObject container) {
        return Collections.emptyList();
    }

    protected Command getCommand(EObject container, AbstractToolDescription tool, Collection<EObject> selectedElements) {
        Command cmd = null;
        if (tool instanceof SelectionWizardDescription && container instanceof DSemanticDecorator) {
            cmd = this.getCommandFactory().buildSelectionWizardCommandFromTool((SelectionWizardDescription)tool, (DSemanticDecorator)container, selectedElements);
        } else if (tool instanceof OperationAction) {
            cmd = this.getCommandFactory().buildOperationActionFromTool((OperationAction)tool, (Collection)selectedElements.stream().filter(DSemanticDecorator.class::isInstance).map(DSemanticDecorator.class::cast).collect(Collectors.toList()));
        }
        return cmd;
    }

    protected final boolean applyEdgeCreationTool(String toolName, DDiagram diagram, EdgeTarget source, EdgeTarget target) {
        boolean result = false;
        AbstractToolDescription tool = this.getTool(diagram, toolName);
        if (tool instanceof EdgeCreationDescription) {
            Command command = this.getCommandFactory().buildCreateEdgeCommandFromTool(source, target, (EdgeCreationDescription)tool);
            result = command.canExecute();
            this.session.getTransactionalEditingDomain().getCommandStack().execute(command);
        }
        return result;
    }

    protected final boolean applyEdgeReconnectionTool(String toolName, DDiagram diagram, DEdge edge, EdgeTarget source, EdgeTarget target) {
        boolean result = false;
        AbstractToolDescription tool = this.getTool(diagram, toolName);
        if (tool instanceof ReconnectEdgeDescription) {
            Command command = this.getCommandFactory().buildReconnectEdgeCommandFromTool((ReconnectEdgeDescription)tool, edge, source, target);
            result = command.canExecute();
            this.session.getTransactionalEditingDomain().getCommandStack().execute(command);
        }
        return result;
    }

    protected final boolean applyContainerDropDescriptionTool(DDiagram diagram, String dndToolName, DragAndDropTarget dropContainer, DDiagramElement droppedDDiagramElement) {
        boolean result = false;
        AbstractToolDescription dndTool = this.getTool(diagram, dndToolName);
        if (dndTool instanceof ContainerDropDescription) {
            Command command = this.getCommandFactory().buildDropInContainerCommandFromTool(dropContainer, droppedDDiagramElement, (ContainerDropDescription)dndTool);
            result = command.canExecute();
            this.session.getTransactionalEditingDomain().getCommandStack().execute(command);
        }
        return result;
    }

    protected final boolean applyContainerDropDescriptionTool(DDiagram diagram, String dndToolName, DragAndDropTarget dropContainer, EObject droppedElement) {
        boolean result = false;
        AbstractToolDescription dndTool = this.getTool(diagram, dndToolName);
        if (dndTool instanceof ContainerDropDescription) {
            Command command = this.getCommandFactory().buildDropInContainerCommandFromTool(dropContainer, droppedElement, (ContainerDropDescription)dndTool);
            result = command.canExecute();
            this.session.getTransactionalEditingDomain().getCommandStack().execute(command);
        }
        return result;
    }

    protected final boolean applyDirectEditTool(String toolName, DDiagram diagram, DDiagramElement element, String value) {
        boolean result = false;
        AbstractToolDescription tool = this.getTool(diagram, toolName);
        if (tool instanceof DirectEditLabel) {
            Command command = this.getCommandFactory().buildDirectEditLabelFromTool((DRepresentationElement)element, (DirectEditLabel)tool, value);
            result = command.canExecute();
            this.session.getTransactionalEditingDomain().getCommandStack().execute(command);
        }
        return result;
    }

    protected final boolean applyDeletionTool(DDiagramElement element) {
        boolean result = false;
        Command command = this.getCommandFactory().buildDeleteDiagramElement(element);
        this.session.getTransactionalEditingDomain().getCommandStack().execute(command);
        return result;
    }

    protected final AbstractToolDescription getTool(DDiagram diagram, String toolName) {
        List<AbstractToolDescription> tools = DiagramComponentizationTestSupport.getAllTools(this.session, diagram.getDescription());
        return this.getTool(tools, toolName);
    }

    protected final AbstractToolDescription getTool(Layer layer, String toolName) {
        return this.getTool((List<AbstractToolDescription>)layer.getAllTools(), toolName);
    }

    private AbstractToolDescription getTool(List<AbstractToolDescription> tools, String toolName) {
        AbstractToolDescription theAbstractToolDescription = null;
        int i = 0;
        while (i < tools.size()) {
            AbstractToolDescription tool = tools.get(i);
            String name = tool.getName();
            if (name != null && name.equals(toolName)) {
                theAbstractToolDescription = tool;
                break;
            }
            ++i;
        }
        return theAbstractToolDescription;
    }

    protected final Layer getLayer(DDiagram diagram, String layerName) {
        List<Layer> layers = DiagramComponentizationTestSupport.getAllLayers(this.session, diagram.getDescription());
        for (Layer layer : layers) {
            if (!layer.getName().equals(layerName)) continue;
            return layer;
        }
        throw new IllegalArgumentException(LAYER_NAME_INCORRECT);
    }

    protected final NodeMapping getNodeMapping(Layer layer, String mappingName) {
        DiagramDescriptionMappingsManager mappingsManager = DiagramDescriptionMappingsRegistry.INSTANCE.getDiagramDescriptionMappingsManager(this.session, SiriusDiagramTestCase.getParentDiagramDescription((EObject)layer));
        this.computeMapping(mappingsManager);
        Set allMappings = new DiagramDescriptionMappingManagerQuery(mappingsManager).computeAllMappings();
        for (DiagramElementMapping mapping : allMappings) {
            NodeMapping nodeMapping;
            if (!(mapping instanceof NodeMapping) || !mappingName.equals((nodeMapping = (NodeMapping)mapping).getName()) || SiriusDiagramTestCase.getParentLayer((DiagramElementMapping)nodeMapping) != layer) continue;
            return nodeMapping;
        }
        throw new IllegalArgumentException(MAPPING_NAME_INCORRECT);
    }

    private void computeMapping(DiagramDescriptionMappingsManager mappingsManager) {
        if (this.session != null) {
            mappingsManager.computeMappings(this.session.getSelectedViewpoints(false));
        } else {
            mappingsManager.computeMappings(null);
        }
    }

    protected final EdgeMapping getEdgeMapping(Layer layer, String mappingName) {
        DiagramDescriptionMappingsManager mappingsManager = DiagramDescriptionMappingsRegistry.INSTANCE.getDiagramDescriptionMappingsManager(this.session, SiriusDiagramTestCase.getParentDiagramDescription((EObject)layer));
        for (EdgeMapping edgeMapping : mappingsManager.getEdgeMappings()) {
            if (!mappingName.equals(edgeMapping.getName())) continue;
            return edgeMapping;
        }
        throw new IllegalArgumentException(MAPPING_NAME_INCORRECT);
    }

    protected final ContainerMapping getContainerMapping(Layer layer, String mappingName) {
        DiagramDescriptionMappingsManager mappingsManager = DiagramDescriptionMappingsRegistry.INSTANCE.getDiagramDescriptionMappingsManager(this.session, SiriusDiagramTestCase.getParentDiagramDescription((EObject)layer));
        this.computeMapping(mappingsManager);
        Set allMappings = new DiagramDescriptionMappingManagerQuery(mappingsManager).computeAllMappings();
        for (DiagramElementMapping mapping : allMappings) {
            ContainerMapping containerMapping;
            if (!(mapping instanceof ContainerMapping) || !mappingName.equals((containerMapping = (ContainerMapping)mapping).getName()) || SiriusDiagramTestCase.getParentLayer((DiagramElementMapping)containerMapping) != layer) continue;
            return containerMapping;
        }
        throw new IllegalArgumentException(MAPPING_NAME_INCORRECT);
    }

    private static DiagramDescription getParentDiagramDescription(EObject anyElement) {
        EObject current = anyElement;
        while (current != null) {
            if (!((current = current.eContainer()) instanceof DiagramDescription)) continue;
            return (DiagramDescription)current;
        }
        return null;
    }

    private static Layer getParentLayer(DiagramElementMapping mapping) {
        DiagramElementMapping current = mapping;
        while (current != null) {
            if (!((current = current.eContainer()) instanceof Layer)) continue;
            return (Layer)current;
        }
        return null;
    }

    protected final FilterDescription getFilter(DDiagram diagram, String filterName) {
        EList filters = diagram.getDescription().getFilters();
        for (FilterDescription filter : filters) {
            if (!filter.getName().equals(filterName)) continue;
            return filter;
        }
        return null;
    }

    protected final Command getCommand(EObject container, AbstractToolDescription tool) {
        Command cmd = null;
        if (tool instanceof NodeCreationDescription) {
            if (container instanceof DDiagram) {
                cmd = this.getCommandFactory().buildCreateNodeCommandFromTool((DDiagram)container, (NodeCreationDescription)tool);
            } else if (container instanceof DDiagramElementContainer) {
                cmd = this.getCommandFactory().buildCreateNodeCommandFromTool((DDiagramElementContainer)container, (NodeCreationDescription)tool);
            } else if (container instanceof DNode) {
                cmd = this.getCommandFactory().buildCreateNodeCommandFromTool((DNode)container, (NodeCreationDescription)tool);
            }
        } else if (tool instanceof ContainerCreationDescription) {
            if (container instanceof DDiagram) {
                cmd = this.getCommandFactory().buildCreateContainerCommandFromTool((DDiagram)container, (ContainerCreationDescription)tool);
            } else if (container instanceof DDiagramElementContainer) {
                cmd = this.getCommandFactory().buildCreateContainerCommandFromTool((DDiagramElementContainer)container, (ContainerCreationDescription)tool);
            }
        } else if (tool instanceof ToolDescription) {
            cmd = this.getCommandFactory().buildGenericToolCommandFromTool(container, (ToolDescription)tool);
        }
        return cmd;
    }

    protected final boolean activateLayer(DDiagram dDiagram, String layerName) {
        Layer layer = this.getLayer(dDiagram, layerName);
        if (layer != null && !dDiagram.getActivatedLayers().contains((Object)layer)) {
            ChangeLayerActivationCommand changeLayersActivationCmd = new ChangeLayerActivationCommand(this.session.getTransactionalEditingDomain(), dDiagram, layer, (IProgressMonitor)new NullProgressMonitor());
            this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)changeLayersActivationCmd);
            return true;
        }
        return false;
    }

    protected final boolean deactivateLayer(DDiagram dDiagram, String layerName) {
        Layer layer = this.getLayer(dDiagram, layerName);
        if (layer != null && (dDiagram.getActivatedLayers().contains((Object)layer) || dDiagram.getActivatedTransientLayers().contains((Object)layer))) {
            ChangeLayerActivationCommand changeLayersActivationCmd = new ChangeLayerActivationCommand(this.session.getTransactionalEditingDomain(), dDiagram, layer, (IProgressMonitor)new NullProgressMonitor());
            this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)changeLayersActivationCmd);
            return true;
        }
        return false;
    }

    protected final boolean activateFilter(DDiagram diagram, String filterName) {
        FilterDescription filter = this.getFilter(diagram, filterName);
        if (filter != null) {
            return this.setFilterActivation(diagram, filter, true);
        }
        throw new IllegalArgumentException(FILTER_NAME_INCORRECT);
    }

    protected final boolean deactivateFilter(DDiagram diagram, String filterName) {
        FilterDescription filter = this.getFilter(diagram, filterName);
        if (filter != null) {
            return this.setFilterActivation(diagram, filter, false);
        }
        throw new IllegalArgumentException(FILTER_NAME_INCORRECT);
    }

    private boolean setFilterActivation(DDiagram diagram, FilterDescription filter, boolean visible) {
        ChangeFilterActivation change = new ChangeFilterActivation((IDiagramWorkbenchPart)EclipseUIUtil.getActiveEditor(), diagram, filter, visible);
        change.run();
        return true;
    }

    protected void hideLabel(DDiagramElement dDiagramElement) {
        TransactionalEditingDomain domain = this.session.getTransactionalEditingDomain();
        HideDDiagramElementLabel hideDDiagramElementLabelCmd = new HideDDiagramElementLabel(domain, Collections.singleton(dDiagramElement));
        domain.getCommandStack().execute((Command)hideDDiagramElementLabelCmd);
        TestsUtil.synchronizationWithUIThread();
    }

    protected void revealLabel(DDiagramElement dDiagramElement) {
        TransactionalEditingDomain domain = this.session.getTransactionalEditingDomain();
        RevealDDiagramElementsLabel revealDDiagramElementLabelCmd = new RevealDDiagramElementsLabel(domain, Collections.singleton(dDiagramElement));
        domain.getCommandStack().execute((Command)revealDDiagramElementLabelCmd);
        TestsUtil.synchronizationWithUIThread();
    }

    protected final DDiagramElement getFirstDiagramElement(DDiagram diagram, EObject semanticElement) {
        return (DDiagramElement)this.getFirstRepresentationElement((DRepresentation)diagram, semanticElement);
    }

    protected final DDiagramElement getFirstDiagramElement(DDiagram diagram, EObject semanticElement, DiagramElementMapping diagramElementMapping) {
        DDiagramElement dDiagramElement = null;
        for (DRepresentationElement element : diagram.getRepresentationElements()) {
            if (element.getTarget() != semanticElement || element.getMapping() != diagramElementMapping || !(element instanceof DDiagramElement)) continue;
            dDiagramElement = (DDiagramElement)element;
            break;
        }
        return dDiagramElement;
    }

    public List<DDiagramElement> getDiagramElementsFromLabel(DDiagram diagram, String label) {
        return this.getDiagramElementsFromLabel(diagram, label, DDiagramElement.class);
    }

    public <T extends DDiagramElement> List<T> getDiagramElementsFromLabel(DDiagram diagram, String label, Class<T> searchedClass) {
        ArrayList<DDiagramElement> found = new ArrayList<DDiagramElement>();
        TreeIterator it = diagram.eAllContents();
        while (it.hasNext()) {
            EObject cur = (EObject)it.next();
            if (!searchedClass.isInstance(cur) || this.labelFeature(cur.eClass()) == null || !label.equals(this.getLabelValue(cur))) continue;
            found.add((DDiagramElement)searchedClass.cast(cur));
        }
        return found;
    }

    private String getLabelValue(EObject cur) {
        return (String)cur.eGet(this.labelFeature(cur.eClass()));
    }

    private EStructuralFeature labelFeature(EClass class1) {
        return class1.getEStructuralFeature("name");
    }

    protected final DNode getFirstNodeElement(DDiagram diagram, EObject semanticElement) {
        return this.getFirstRepresentationElement((DRepresentation)diagram, semanticElement, DNode.class);
    }

    protected final DEdge getFirstEdgeElement(DDiagram diagram, EObject semanticElement) {
        return this.getFirstRepresentationElement((DRepresentation)diagram, semanticElement, DEdge.class);
    }

    protected static final boolean isVisible(DDiagram diagram, DDiagramElement element) {
        if (diagram == null) {
            throw new IllegalArgumentException("diagram should not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("element should not be null");
        }
        return DisplayServiceManager.INSTANCE.getDisplayService().isDisplayed(diagram, element);
    }

    protected Diagram getGmfDiagram(DDiagram diagram) {
        return SiriusGMFHelper.getGmfDiagram((DDiagram)diagram, (Session)this.session);
    }

    protected View getGmfView(DDiagramElement diagramElement) {
        return SiriusGMFHelper.getGmfView((DDiagramElement)diagramElement, (Session)this.session);
    }

    protected static View getGmfViewAndAssertOnlyOne(EObject diagramElement, Class<? extends View> clazz, Session session) {
        Session sessionToUse;
        View result = null;
        if (diagramElement instanceof DSemanticDecorator && (sessionToUse = session == null ? new EObjectQuery(diagramElement).getSession() : session) != null) {
            ECrossReferenceAdapter crossReference = sessionToUse.getSemanticCrossReferencer();
            for (EStructuralFeature.Setting setting : crossReference.getInverseReferences(diagramElement)) {
                if (!clazz.isInstance(setting.getEObject()) || setting.getEStructuralFeature() != NotationPackage.eINSTANCE.getView_Element()) continue;
                if (result != null) {
                    Assert.fail((String)"We should have only one GMF view for a diagram element.");
                }
                result = (View)setting.getEObject();
            }
        }
        return result;
    }

    protected Node getGmfNode(DDiagramElement diagramElement) {
        return SiriusGMFHelper.getGmfNode((DDiagramElement)diagramElement, (Session)this.session);
    }

    protected Edge getGmfEdge(DDiagramElement diagramElement) {
        return SiriusGMFHelper.getGmfEdge((DDiagramElement)diagramElement, (Session)this.session);
    }

    protected IGraphicalEditPart getEditPart(DDiagramElement diagramElement) {
        IEditorPart editor = EclipseUIUtil.getActiveEditor();
        TestsUtil.synchronizationWithUIThread();
        return this.getEditPart(diagramElement, editor);
    }

    protected IGraphicalEditPart getEditPart(DDiagram diagram) {
        IEditorPart editor = EclipseUIUtil.getActiveEditor();
        return this.getEditPart(diagram, editor);
    }

    protected IGraphicalEditPart getEditPart(DDiagramElement diagramElement, IEditorPart editor) {
        View gmfView = this.getGmfView(diagramElement);
        return this.getEditPart(gmfView, editor);
    }

    protected IGraphicalEditPart getEditPart(DDiagram diagram, IEditorPart editor) {
        Diagram gmfDiagram = this.getGmfDiagram(diagram);
        return this.getEditPart((View)gmfDiagram, editor);
    }

    private IGraphicalEditPart getEditPart(View gmfView, IEditorPart editor) {
        Map editPartRegistry;
        Object editPart;
        IGraphicalEditPart result = null;
        if (gmfView != null && editor instanceof DiagramEditor && (editPart = (editPartRegistry = ((DiagramEditor)editor).getDiagramGraphicalViewer().getEditPartRegistry()).get(gmfView)) instanceof IGraphicalEditPart) {
            result = (IGraphicalEditPart)editPart;
        }
        return result;
    }

    protected boolean setDDiagramAttribute(EditingDomain domain, DDiagram diagram, String eAttributeName, Object newValue) {
        boolean result = false;
        EClass eClass = diagram.eClass();
        EList eAttributes = eClass.getEAllAttributes();
        Iterator iterator = eAttributes.iterator();
        EAttribute targetAttribute = null;
        while (iterator.hasNext() && targetAttribute == null) {
            EAttribute eAttribute = (EAttribute)iterator.next();
            if (!eAttribute.getName().equals(eAttributeName)) continue;
            targetAttribute = eAttribute;
        }
        Command setCmd = SetCommand.create((EditingDomain)domain, (Object)diagram, targetAttribute, (Object)newValue);
        result = setCmd.canExecute();
        this.session.getTransactionalEditingDomain().getCommandStack().execute(setCmd);
        return result;
    }

    protected void unsynchronizeDiagram(DDiagram diagram) {
        TransactionalEditingDomain domain = this.session.getTransactionalEditingDomain();
        Command setUnsynschronizedCmd = SetCommand.create((EditingDomain)domain, (Object)diagram, (Object)DiagramPackage.Literals.DDIAGRAM__SYNCHRONIZED, (Object)false);
        domain.getCommandStack().execute(setUnsynschronizedCmd);
    }

    protected LabelEditPart getLabelEditPart(DDiagramElement diagramElement) {
        IGraphicalEditPart editPart = this.getEditPart(diagramElement);
        for (Object child : editPart.getChildren()) {
            if (!(child instanceof LabelEditPart)) continue;
            return (LabelEditPart)child;
        }
        return null;
    }

    protected void checkForHiddenLabels(DDiagram diagram, DDiagramElement ... elementsThatShouldHaveHiddenLabel) {
        HashSet<DDiagramElement> allDiagramElements = new HashSet<DDiagramElement>((Collection<DDiagramElement>)diagram.getOwnedDiagramElements());
        for (DDiagramElement diagramElement : diagram.getOwnedDiagramElements()) {
            Iterator filter = diagramElement.eContents().stream().filter(DDiagramElement.class::isInstance).map(DDiagramElement.class::cast).iterator();
            while (filter.hasNext()) {
                allDiagramElements.add((DDiagramElement)filter.next());
            }
        }
        HashSet elementsThatShouldHaveVisibleLabel = new HashSet(allDiagramElements);
        elementsThatShouldHaveVisibleLabel.removeAll(new HashSet<DDiagramElement>(Arrays.asList(elementsThatShouldHaveHiddenLabel)));
        for (DDiagramElement elementThatShouldHaveVisibleLabel : elementsThatShouldHaveVisibleLabel) {
            LabelEditPart labelEditPart = this.getLabelEditPart(elementThatShouldHaveVisibleLabel);
            TestCase.assertNotNull((String)("This element's label should not be hidden : " + String.valueOf(elementThatShouldHaveVisibleLabel)), (Object)labelEditPart);
            TestCase.assertTrue((String)("This element's label should not be hidden : " + String.valueOf(elementThatShouldHaveVisibleLabel)), (boolean)labelEditPart.getFigure().isVisible());
        }
        DDiagramElement[] dDiagramElementArray = elementsThatShouldHaveHiddenLabel;
        int n = elementsThatShouldHaveHiddenLabel.length;
        int n2 = 0;
        while (n2 < n) {
            DDiagramElement elementThatShouldHaveHiddenLabel = dDiagramElementArray[n2];
            LabelEditPart labelEditPart = this.getLabelEditPart(elementThatShouldHaveHiddenLabel);
            TestCase.assertTrue((String)("This element's label should be hidden : " + String.valueOf(elementThatShouldHaveHiddenLabel)), (labelEditPart == null || !labelEditPart.getFigure().isVisible() ? 1 : 0) != 0);
            ++n2;
        }
    }

    protected void updateTools(Diagram diagram) {
        TransactionalEditingDomain editingDomain = this.session.getTransactionalEditingDomain();
        UpdateToolRecordingCommand updateToolRecordingCommand = new UpdateToolRecordingCommand(editingDomain, (DDiagram)diagram.getElement(), true);
        editingDomain.getCommandStack().execute((Command)updateToolRecordingCommand);
    }

    protected void resetStylePropertiesToDefaultValues(DDiagramElement dDiagramElement, DDiagram diagram) {
        TransactionalEditingDomain domain = this.session.getTransactionalEditingDomain();
        Iterator iterator = new EObjectQuery((EObject)dDiagramElement).getInverseReferences(NotationPackage.Literals.VIEW__ELEMENT).iterator();
        TestCase.assertTrue((String)("The DDiagramElement : " + String.valueOf(dDiagramElement) + " must have a associated GMF View"), (boolean)iterator.hasNext());
        EObject next = (EObject)iterator.next();
        TestCase.assertTrue((String)("The DDiagramElement : " + String.valueOf(dDiagramElement) + " must have a associated GMF View"), (boolean)(next instanceof View));
        View view = (View)next;
        ResetStylePropertiesToDefaultValuesCommand command = new ResetStylePropertiesToDefaultValuesCommand(domain, diagram, Collections.singletonMap(view, dDiagramElement));
        domain.getCommandStack().execute((Command)command);
    }

    @Deprecated
    protected void setReadOnly(IFile file) throws Exception {
        EclipseTestsSupportHelper.INSTANCE.setReadOnlyStatus(true, new IResource[]{file});
        TestCase.assertTrue((String)"The file must be read only", (boolean)file.isReadOnly());
    }

    protected IFile getFile(String fileName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject("DesignerTestProject").getFile(fileName);
    }
}

