/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.model.elements;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.ui.IMemento;

public abstract class ElementMementoProvider
implements IElementMementoProvider {
    @Override
    public void compareElements(final IElementCompareRequest[] requests) {
        Job job = new Job("compare element"){

            protected IStatus run(IProgressMonitor monitor) {
                IElementCompareRequest[] iElementCompareRequestArray = requests;
                int n = requests.length;
                int n2 = 0;
                while (n2 < n) {
                    IElementCompareRequest request = iElementCompareRequestArray[n2];
                    try {
                        request.setEqual(ElementMementoProvider.this.isEqual(request.getElement(), request.getMemento(), request.getPresentationContext()));
                    }
                    catch (CoreException e) {
                        request.setStatus(e.getStatus());
                    }
                    request.done();
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    protected abstract boolean isEqual(Object var1, IMemento var2, IPresentationContext var3) throws CoreException;

    @Override
    public void encodeElements(final IElementMementoRequest[] requests) {
        Job job = new Job("encode element"){

            protected IStatus run(IProgressMonitor monitor) {
                IElementMementoRequest[] iElementMementoRequestArray = requests;
                int n = requests.length;
                int n2 = 0;
                while (n2 < n) {
                    IElementMementoRequest request = iElementMementoRequestArray[n2];
                    try {
                        if (!ElementMementoProvider.this.encodeElement(request.getElement(), request.getMemento(), request.getPresentationContext())) {
                            request.cancel();
                        }
                    }
                    catch (CoreException e) {
                        request.setStatus(e.getStatus());
                    }
                    request.done();
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    protected abstract boolean encodeElement(Object var1, IMemento var2, IPresentationContext var3) throws CoreException;
}

