/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.core.cxx.internal.externaltool;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.cdt.codan.core.cxx.externaltool.ArgsSeparator;
import org.eclipse.cdt.codan.core.cxx.externaltool.ConfigurationSettings;
import org.eclipse.cdt.codan.core.cxx.externaltool.InvocationFailure;
import org.eclipse.cdt.codan.core.cxx.externaltool.InvocationParameters;
import org.eclipse.cdt.codan.core.cxx.internal.externaltool.Command;
import org.eclipse.cdt.codan.core.cxx.internal.externaltool.CommandBuilder;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncherManager;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.core.ConsoleOutputSniffer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ExternalToolInvoker {
    private static final String DEFAULT_CONTEXT_MENU_ID = "org.eclipse.cdt.ui.CDTBuildConsole";
    private static final NullProgressMonitor NULL_PROGRESS_MONITOR = new NullProgressMonitor();
    private final CommandBuilder commandBuilder = new CommandBuilder();

    public void invoke(InvocationParameters parameters, ConfigurationSettings settings, ArgsSeparator argsSeparator, IConsoleParser[] parsers) throws InvocationFailure, Throwable {
        Command command = this.commandBuilder.buildCommand(parameters, settings, argsSeparator);
        this.launchCommand(command, parsers, parameters, settings);
    }

    private void launchCommand(Command command, IConsoleParser[] parsers, InvocationParameters parameters, ConfigurationSettings settings) throws InvocationFailure, CoreException {
        IProject project = parameters.getActualFile().getProject();
        String toolName = settings.getExternalToolName();
        IPath workingDirectory = parameters.getWorkingDirectory();
        IPath commandPath = command.getPath();
        String[] commandArgs = command.getArgs();
        String[] commandEnv = command.getEnv();
        this.launchOnBuildConsole(project, parsers, toolName, commandPath, commandArgs, commandEnv, workingDirectory, (IProgressMonitor)NULL_PROGRESS_MONITOR);
    }

    public void launchOnBuildConsole(IProject project, IConsoleParser[] parsers, String toolName, IPath commandPath, String[] commandArgs, String[] commandEnv, IPath workingDirectory, IProgressMonitor monitor) throws CoreException, InvocationFailure {
        monitor.beginTask("Launching " + toolName, 100);
        IConsole c = CCorePlugin.getDefault().getConsole(null, DEFAULT_CONTEXT_MENU_ID, toolName, null);
        c.start(project);
        ConsoleOutputSniffer sniffer = new ConsoleOutputSniffer((OutputStream)c.getOutputStream(), (OutputStream)c.getErrorStream(), parsers);
        OutputStream out = sniffer.getOutputStream();
        OutputStream err = sniffer.getErrorStream();
        try {
            ICommandLauncher launcher = CommandLauncherManager.getInstance().getCommandLauncher();
            launcher.showCommand(true);
            launcher.setProject(project);
            Process p = launcher.execute(commandPath, commandArgs, commandEnv, workingDirectory, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            if (p == null) {
                String format = "Unable to launch external tool '%s': %s";
                throw new InvocationFailure(String.format(format, commandPath, launcher.getErrorMessage()));
            }
            try {
                p.getOutputStream().close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                launcher.waitAndRead(out, err, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            }
            finally {
                p.destroy();
            }
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
            try {
                err.close();
            }
            catch (IOException iOException) {}
            monitor.done();
        }
    }
}

