/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.clangd.internal.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.cdt.lsp.clangd.ClangdConfiguration;
import org.eclipse.cdt.lsp.clangd.ClangdMetadata;
import org.eclipse.cdt.lsp.clangd.ClangdOptions;
import org.eclipse.cdt.lsp.clangd.ClangdQualifier;
import org.eclipse.cdt.lsp.clangd.internal.config.ClangdPreferredOptions;
import org.eclipse.cdt.lsp.config.ConfigurationAccess;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferenceMetadataStore;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.runtime.preferences.OsgiPreferenceMetadataStore;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public final class ClangdConfigurationAccess
extends ConfigurationAccess
implements ClangdConfiguration {
    @Reference
    private ClangdMetadata metadata;
    @Reference
    private IWorkspace workspace;

    public ClangdConfigurationAccess() {
        super(new ClangdQualifier().get());
    }

    public ClangdMetadata metadata() {
        return this.metadata;
    }

    @Override
    public ClangdOptions defaults() {
        return new ClangdPreferredOptions(this.metadata, this.qualifier, new IScopeContext[]{DefaultScope.INSTANCE});
    }

    @Override
    public ClangdOptions options(Object context) {
        Optional project = this.projectScope(this.workspace, context);
        IScopeContext[] scopes = project.isPresent() ? new IScopeContext[]{(IScopeContext)project.get(), InstanceScope.INSTANCE, DefaultScope.INSTANCE} : new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE};
        return new ClangdPreferredOptions(this.metadata, this.qualifier, scopes);
    }

    public IPreferenceMetadataStore storage(Object context) {
        return new OsgiPreferenceMetadataStore(this.preferences(this.projectScope(this.workspace, context).map(IScopeContext.class::cast).orElse(InstanceScope.INSTANCE)));
    }

    public String qualifier() {
        return this.qualifier;
    }

    @Override
    public List<String> commands(Object context) {
        ClangdOptions options = this.options(context);
        ArrayList<String> list = new ArrayList<String>();
        list.add(options.clangdPath());
        if (options.useTidy()) {
            list.add("--clang-tidy");
        }
        if (options.useBackgroundIndex()) {
            list.add("--background-index");
        }
        if (!options.completionStyle().isBlank()) {
            list.add(NLS.bind((String)"--completion-style={0}", (Object)options.completionStyle()));
        }
        if (options.prettyPrint()) {
            list.add("--pretty");
        }
        if (!options.queryDriver().isBlank()) {
            list.add(NLS.bind((String)"--query-driver={0}", (Object)options.queryDriver()));
        }
        list.add(NLS.bind((String)"--function-arg-placeholders={0}", (Object)(options.fillFunctionArguments() ? 1 : 0)));
        list.addAll(options.additionalOptions());
        return list;
    }
}

