/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.service;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.IDsfStatusConstants;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.service.IDsfService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public abstract class AbstractDsfService
implements IDsfService,
IDsfStatusConstants {
    private DsfSession fSession;
    private int fStartupNumber;
    private ServiceRegistration<?> fRegistration;
    private DsfServicesTracker fTracker;
    private Dictionary fProperties;
    private String fFilter;

    public AbstractDsfService(DsfSession session) {
        this.fSession = session;
    }

    @Override
    public DsfExecutor getExecutor() {
        return this.fSession.getExecutor();
    }

    @Override
    public Dictionary getProperties() {
        return this.fProperties;
    }

    @Override
    public String getServiceFilter() {
        return this.fFilter;
    }

    @Override
    public int getStartupNumber() {
        return this.fStartupNumber;
    }

    @Override
    public void initialize(RequestMonitor rm) {
        this.fTracker = new DsfServicesTracker(this.getBundleContext(), this.fSession.getId());
        this.fStartupNumber = this.fSession.getAndIncrementServiceStartupCounter();
        rm.done();
    }

    @Override
    public void shutdown(RequestMonitor rm) {
        this.fTracker.dispose();
        this.fTracker = null;
        rm.done();
    }

    @Override
    public boolean isRegistered() {
        return this.getServiceRegistration() != null;
    }

    @Override
    public DsfSession getSession() {
        return this.fSession;
    }

    protected abstract BundleContext getBundleContext();

    protected DsfServicesTracker getServicesTracker() {
        return this.fTracker;
    }

    protected void register(String[] classes, Dictionary properties) {
        HashSet<String> classSet = new HashSet<String>(Arrays.asList(classes));
        if (this.fRegistration != null) {
            String[] previousClasses = (String[])this.fRegistration.getReference().getProperty("objectClass");
            classSet.addAll(Arrays.asList(previousClasses));
            if (this.fProperties != null) {
                Enumeration e = this.fProperties.keys();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    Object value = this.fProperties.get(key);
                    properties.put(key, value);
                }
            }
            this.unregister();
        }
        classSet.add(IDsfService.class.getName());
        classSet.add(this.getClass().getName());
        if (this instanceof ICachingService) {
            classSet.add(ICachingService.class.getName());
        }
        properties.put("org.eclipse.cdt.dsf.service.IService.session_id", this.getSession().getId());
        this.fProperties = properties;
        this.fRegistration = this.getBundleContext().registerService((String[])classSet.toArray(String[]::new), (Object)this, properties);
        this.fProperties.put("objectClass", this.fRegistration.getReference().getProperty("objectClass"));
        this.fFilter = this.generateFilter(this.fProperties);
    }

    private String generateFilter(Dictionary properties) {
        StringBuilder filter = new StringBuilder();
        filter.append("(&");
        Enumeration keys = properties.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = properties.get(key);
            if (value instanceof Object[]) {
                Object[] objectArray = (Object[])value;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object arrayValue = objectArray[n2];
                    filter.append('(');
                    filter.append(key.toString());
                    filter.append("=*");
                    filter.append(arrayValue.toString());
                    filter.append(')');
                    ++n2;
                }
                continue;
            }
            filter.append('(');
            filter.append(key.toString());
            filter.append('=');
            filter.append(value.toString());
            filter.append(')');
        }
        filter.append(')');
        return filter.toString();
    }

    protected void unregister() {
        if (this.fRegistration != null) {
            this.fRegistration.unregister();
        }
        this.fRegistration = null;
    }

    protected ServiceRegistration<?> getServiceRegistration() {
        return this.fRegistration;
    }
}

