/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IFormattedValues;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.service.command.BufferedCommandControl;
import org.eclipse.cdt.dsf.debug.service.command.CommandCache;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.Messages;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDataListRegisterNamesInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDataListRegisterValuesInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIRegisterValue;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.service.IDsfService;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class MIRegisters
extends AbstractDsfService
implements IRegisters,
ICachingService {
    protected static final String BLANK_STRING = "";
    protected static final String ROOT_GROUP_NAME = Messages.MIRegisters_General_Registers;
    protected static final String ROOT_GROUP_DESCRIPTION = Messages.MIRegisters_General_Registers_description;
    private CommandFactory fCommandFactory;
    private final Map<IRunControl.IContainerDMContext, MIRegisterGroupDMC> fContainerToGroupMap = new HashMap<IRunControl.IContainerDMContext, MIRegisterGroupDMC>();
    private CommandCache fRegisterNameCache;
    private CommandCache fRegisterValueCache;

    public MIRegisters(DsfSession session) {
        super(session);
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(requestMonitor){

            protected void handleSuccess() {
                MIRegisters.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        ICommandControlService commandControl = (ICommandControlService)this.getServicesTracker().getService(ICommandControlService.class);
        BufferedCommandControl bufferedCommandControl = new BufferedCommandControl((ICommandControl)commandControl, this.getExecutor(), 2);
        this.fCommandFactory = ((IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class)).getCommandFactory();
        this.fRegisterValueCache = new CommandCache(this.getSession(), (ICommandControl)bufferedCommandControl);
        this.fRegisterValueCache.setContextAvailable((IDMContext)commandControl.getContext(), true);
        this.fRegisterNameCache = new CommandCache(this.getSession(), (ICommandControl)commandControl);
        this.fRegisterNameCache.setContextAvailable((IDMContext)commandControl.getContext(), true);
        this.getSession().addServiceEventListener((Object)this, null);
        this.register(new String[]{IRegisters.class.getName(), MIRegisters.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        this.getSession().removeServiceEventListener((Object)this);
        super.shutdown(requestMonitor);
    }

    public boolean isValid() {
        return true;
    }

    public void getFormattedExpressionValue(IFormattedValues.FormattedValueDMContext dmc, DataRequestMonitor<IFormattedValues.FormattedValueDMData> rm) {
        if (dmc.getParents().length == 1 && dmc.getParents()[0] instanceof MIRegisterDMC) {
            this.getRegisterDataValue((MIRegisterDMC)dmc.getParents()[0], dmc.getFormatID(), rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Unknown DMC type", null));
            rm.done();
        }
    }

    public void getRegisterGroupData(IRegisters.IRegisterGroupDMContext regGroupDmc, DataRequestMonitor<IRegisters.IRegisterGroupDMData> rm) {
        class RegisterGroupData
        implements IRegisters.IRegisterGroupDMData {
            RegisterGroupData() {
            }

            public String getName() {
                return ROOT_GROUP_NAME;
            }

            public String getDescription() {
                return ROOT_GROUP_DESCRIPTION;
            }
        }
        rm.setData((Object)new RegisterGroupData());
        rm.done();
    }

    public void getBitFieldData(IRegisters.IBitFieldDMContext dmc, DataRequestMonitor<IRegisters.IBitFieldDMData> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Bit fields not yet supported", null));
        rm.done();
    }

    public void getRegisterData(IRegisters.IRegisterDMContext regDmc, final DataRequestMonitor<IRegisters.IRegisterDMData> rm) {
        if (regDmc instanceof MIRegisterDMC) {
            final MIRegisterDMC miRegDmc = (MIRegisterDMC)regDmc;
            final IStack.IFrameDMContext frameDmc = (IStack.IFrameDMContext)DMContexts.getAncestorOfType((IDMContext)regDmc, IStack.IFrameDMContext.class);
            if (frameDmc == null) {
                rm.setData((Object)new RegisterData(null, miRegDmc.getName(), BLANK_STRING, false));
                rm.done();
                return;
            }
            int[] regnos = new int[]{miRegDmc.getRegNo()};
            this.fRegisterValueCache.execute(this.fCommandFactory.createMIDataListRegisterValues(frameDmc, 0, regnos), (DataRequestMonitor)new DataRequestMonitor<MIDataListRegisterValuesInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    MIRegisterValue[] regValue = ((MIDataListRegisterValuesInfo)this.getData()).getMIRegisterValues();
                    if (regValue.length == 0) {
                        rm.setData((Object)new RegisterData(frameDmc, miRegDmc.getName(), MIRegisters.BLANK_STRING, false));
                        rm.done();
                        return;
                    }
                    if (!$assertionsDisabled && regValue.length != 1) {
                        throw new AssertionError();
                    }
                    MIRegisterValue reg = regValue[0];
                    boolean isFloat = false;
                    if (reg.getValue().contains("float")) {
                        isFloat = true;
                    }
                    rm.setData((Object)new RegisterData(frameDmc, miRegDmc.getName(), MIRegisters.BLANK_STRING, isFloat));
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Unknown DMC type", null));
            rm.done();
        }
    }

    private void getRegisterDataValue(MIRegisterDMC regDmc, String formatId, final DataRequestMonitor<IFormattedValues.FormattedValueDMData> rm) {
        IStack.IFrameDMContext frameDmc = (IStack.IFrameDMContext)DMContexts.getAncestorOfType((IDMContext)regDmc, IStack.IFrameDMContext.class);
        if (frameDmc == null) {
            rm.setData((Object)new IFormattedValues.FormattedValueDMData(BLANK_STRING));
            rm.done();
            return;
        }
        int NumberFormat = 0;
        if ("HEX.Format".equals(formatId)) {
            NumberFormat = 0;
        }
        if ("OCTAL.Format".equals(formatId)) {
            NumberFormat = 1;
        }
        if ("NATURAL.Format".equals(formatId)) {
            NumberFormat = 5;
        }
        if ("BINARY.Format".equals(formatId)) {
            NumberFormat = 2;
        }
        if ("DECIMAL.Format".equals(formatId)) {
            NumberFormat = 3;
        }
        int[] regnos = new int[]{regDmc.getRegNo()};
        this.fRegisterValueCache.execute(this.fCommandFactory.createMIDataListRegisterValues(frameDmc, NumberFormat, regnos), (DataRequestMonitor)new DataRequestMonitor<MIDataListRegisterValuesInfo>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                MIRegisterValue[] regValue = ((MIDataListRegisterValuesInfo)this.getData()).getMIRegisterValues();
                if (regValue.length == 0) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Encountered a GDB Error See http://eclip.se/506382#c7 for workarounds", null));
                    rm.done();
                    return;
                }
                MIRegisterValue reg = regValue[0];
                rm.setData((Object)new IFormattedValues.FormattedValueDMData(reg.getValue()));
                rm.done();
            }
        });
    }

    private MIRegisterDMC[] makeRegisterDMCs(MIRegisterGroupDMC groupDmc, String[] regNames) {
        return this.makeRegisterDMCs(groupDmc, null, regNames);
    }

    private MIRegisterDMC[] makeRegisterDMCs(MIRegisterGroupDMC groupDmc, IStack.IFrameDMContext frameDmc, String[] regNames) {
        ArrayList<MIRegisterDMC> regDmcList = new ArrayList<MIRegisterDMC>(regNames.length);
        int regNo = 0;
        String[] stringArray = regNames;
        int n = regNames.length;
        int n2 = 0;
        while (n2 < n) {
            String regName = stringArray[n2];
            if (regName != null && !regName.isEmpty()) {
                if (frameDmc != null) {
                    regDmcList.add(new MIRegisterDMC(this, groupDmc, frameDmc, regNo, regName));
                } else {
                    regDmcList.add(new MIRegisterDMC(this, groupDmc, regNo, regName));
                }
            }
            ++regNo;
            ++n2;
        }
        return regDmcList.toArray(new MIRegisterDMC[regDmcList.size()]);
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        this.fRegisterValueCache.setContextAvailable(e.getDMContext(), false);
        if (e.getReason() != IRunControl.StateChangeReason.STEP) {
            this.fRegisterValueCache.reset();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        this.fRegisterValueCache.setContextAvailable(e.getDMContext(), true);
        this.fRegisterValueCache.reset();
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRegisters.IRegisterChangedDMEvent e) {
        this.fRegisterValueCache.reset();
    }

    protected void generateRegisterChangedEvent(IRegisters.IRegisterDMContext dmc) {
        this.getSession().dispatchEvent((Object)new RegisterChangedDMEvent(dmc), this.getProperties());
        final IRegisters.IRegisterGroupDMContext groupDmc = (IRegisters.IRegisterGroupDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IRegisters.IRegisterGroupDMContext.class);
        if (groupDmc != null) {
            IRegisters.IRegistersChangedDMEvent event = new IRegisters.IRegistersChangedDMEvent(){

                public IRegisters.IRegisterGroupDMContext getDMContext() {
                    return groupDmc;
                }
            };
            this.getSession().dispatchEvent((Object)event, this.getProperties());
        }
    }

    public void getRegisterGroups(IDMContext ctx, DataRequestMonitor<IRegisters.IRegisterGroupDMContext[]> rm) {
        IRunControl.IContainerDMContext contDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)ctx, IRunControl.IContainerDMContext.class);
        if (contDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Container context not found", null));
            rm.done();
            return;
        }
        MIRegisterGroupDMC registerGroup = this.fContainerToGroupMap.get(contDmc);
        if (registerGroup == null) {
            registerGroup = new MIRegisterGroupDMC(this, contDmc, 0, ROOT_GROUP_NAME);
            this.fContainerToGroupMap.put(contDmc, registerGroup);
        }
        MIRegisterGroupDMC[] groupDMCs = new MIRegisterGroupDMC[]{registerGroup};
        rm.setData((Object)groupDMCs);
        rm.done();
    }

    public void getRegisters(IDMContext dmc, final DataRequestMonitor<IRegisters.IRegisterDMContext[]> rm) {
        final MIRegisterGroupDMC groupDmc = (MIRegisterGroupDMC)DMContexts.getAncestorOfType((IDMContext)dmc, MIRegisterGroupDMC.class);
        if (groupDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "RegisterGroup context not found", null));
            rm.done();
            return;
        }
        final IRunControl.IContainerDMContext containerDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IRunControl.IContainerDMContext.class);
        if (containerDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Container context not found", null));
            rm.done();
            return;
        }
        if (groupDmc.getGroupNo() == 0) {
            IStack stackService;
            IMIExecutionDMContext execDmc;
            IStack.IFrameDMContext frameDmc = (IStack.IFrameDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IStack.IFrameDMContext.class);
            if (frameDmc == null && (execDmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMIExecutionDMContext.class)) != null && (stackService = (IStack)this.getServicesTracker().getService(IStack.class)) != null) {
                stackService.getTopFrame((IDMContext)execDmc, (DataRequestMonitor)new ImmediateDataRequestMonitor<IStack.IFrameDMContext>(rm){

                    protected void handleSuccess() {
                        MIRegisters.this.getRegisters((IStack.IFrameDMContext)this.getData(), groupDmc, containerDmc, (DataRequestMonitor<IRegisters.IRegisterDMContext[]>)rm);
                    }

                    protected void handleFailure() {
                        MIRegisters.this.getRegisters(null, groupDmc, containerDmc, (DataRequestMonitor<IRegisters.IRegisterDMContext[]>)rm);
                    }
                });
                return;
            }
            this.getRegisters(frameDmc, groupDmc, containerDmc, rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid group = " + String.valueOf((Object)groupDmc), null));
            rm.done();
        }
    }

    private void getRegisters(final IStack.IFrameDMContext frameDmc, final MIRegisterGroupDMC groupDmc, IRunControl.IContainerDMContext containerDmc, final DataRequestMonitor<IRegisters.IRegisterDMContext[]> rm) {
        this.fRegisterNameCache.execute(this.fCommandFactory.createMIDataListRegisterNames(containerDmc), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIDataListRegisterNamesInfo>(rm){

            protected void handleSuccess() {
                String[] regNames = ((MIDataListRegisterNamesInfo)this.getData()).getRegisterNames();
                if (regNames.length == 0) {
                    rm.done();
                    return;
                }
                if (frameDmc == null) {
                    rm.setData((Object)MIRegisters.this.makeRegisterDMCs(groupDmc, regNames));
                } else {
                    rm.setData((Object)MIRegisters.this.makeRegisterDMCs(groupDmc, frameDmc, regNames));
                }
                rm.done();
            }
        });
    }

    public void getBitFields(IDMContext regDmc, DataRequestMonitor<IRegisters.IBitFieldDMContext[]> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "BitField not supported", null));
        rm.done();
    }

    public void writeRegister(IRegisters.IRegisterDMContext regCtx, final String regValue, final String formatId, final RequestMonitor rm) {
        assert (regCtx instanceof MIRegisterDMC);
        final MIRegisterDMC regDmc = (MIRegisterDMC)regCtx;
        final IExpressions exprService = (IExpressions)this.getServicesTracker().getService(IExpressions.class);
        String regName = regDmc.getName();
        final IExpressions.IExpressionDMContext exprCtxt = exprService.createExpression((IDMContext)regCtx, "$" + regName);
        final IFormattedValues.FormattedValueDMContext valueDmc = exprService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)exprCtxt, formatId);
        exprService.getFormattedExpressionValue(valueDmc, (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                if (!regValue.equals(((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue()) || !valueDmc.getFormatID().equals(formatId)) {
                    exprService.writeExpression(exprCtxt, regValue, formatId, (RequestMonitor)new DataRequestMonitor<MIInfo>((Executor)MIRegisters.this.getExecutor(), rm){

                        protected void handleSuccess() {
                            MIRegisters.this.generateRegisterChangedEvent(regDmc);
                            rm.done();
                        }
                    });
                } else {
                    rm.done();
                }
            }
        });
    }

    public void writeBitField(IRegisters.IBitFieldDMContext bitFieldCtx, String bitFieldValue, String formatId, RequestMonitor rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Writing bit field not supported", null));
        rm.done();
    }

    public void writeBitField(IRegisters.IBitFieldDMContext bitFieldCtx, IRegisters.IMnemonic mnemonic, RequestMonitor rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Writing bit field not supported", null));
        rm.done();
    }

    public void getAvailableFormats(IFormattedValues.IFormattedDataDMContext dmc, DataRequestMonitor<String[]> rm) {
        rm.setData((Object)new String[]{"HEX.Format", "DECIMAL.Format", "OCTAL.Format", "BINARY.Format", "NATURAL.Format"});
        rm.done();
    }

    public IFormattedValues.FormattedValueDMContext getFormattedValueContext(IFormattedValues.IFormattedDataDMContext dmc, String formatId) {
        if (dmc instanceof MIRegisterDMC) {
            MIRegisterDMC regDmc = (MIRegisterDMC)dmc;
            return new IFormattedValues.FormattedValueDMContext((IDsfService)this, (IDMContext)regDmc, formatId);
        }
        return null;
    }

    public void findRegisterGroup(IDMContext ctx, String name, DataRequestMonitor<IRegisters.IRegisterGroupDMContext> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Finding a Register Group context not supported", null));
        rm.done();
    }

    public void findRegister(IDMContext ctx, final String name, final DataRequestMonitor<IRegisters.IRegisterDMContext> rm) {
        this.getRegisters(ctx, (DataRequestMonitor<IRegisters.IRegisterDMContext[]>)new ImmediateDataRequestMonitor<IRegisters.IRegisterDMContext[]>(){

            protected void handleSuccess() {
                IRegisters.IRegisterDMContext[] allRegs = (IRegisters.IRegisterDMContext[])this.getData();
                int i = 0;
                while (i < allRegs.length) {
                    if (allRegs[i] instanceof MIRegisterDMC && name.equals(((MIRegisterDMC)allRegs[i]).getName())) {
                        rm.done((Object)allRegs[i]);
                        return;
                    }
                    ++i;
                }
                rm.done((IStatus)new Status(2, "org.eclipse.cdt.dsf.gdb", 10005, "Unknown register name", null));
            }
        });
    }

    public void findBitField(IDMContext ctx, String name, DataRequestMonitor<IRegisters.IBitFieldDMContext> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Finding a Register Group context not supported", null));
        rm.done();
    }

    public void flushCache(IDMContext context) {
        this.fRegisterNameCache.reset(context);
        this.fRegisterValueCache.reset(context);
    }

    public static class GroupsChangedDMEvent
    implements IRegisters.IGroupsChangedDMEvent {
        private final IRunControl.IContainerDMContext fGroupContainerDmc;

        public GroupsChangedDMEvent(IRunControl.IContainerDMContext containerDMC) {
            this.fGroupContainerDmc = containerDMC;
        }

        public IRunControl.IContainerDMContext getDMContext() {
            return this.fGroupContainerDmc;
        }
    }

    public static class MIRegisterDMC
    extends AbstractDMContext
    implements IRegisters.IRegisterDMContext {
        private int fRegNo;
        private String fRegName;

        public MIRegisterDMC(MIRegisters service, MIRegisterGroupDMC group, int regNo, String regName) {
            super(service.getSession().getId(), new IDMContext[]{group});
            this.fRegNo = regNo;
            this.fRegName = regName;
        }

        @Deprecated
        public MIRegisterDMC(MIRegisters service, MIRegisterGroupDMC group, IMIExecutionDMContext execDmc, int regNo, String regName) {
            super(service.getSession().getId(), new IDMContext[]{execDmc, group});
            this.fRegNo = regNo;
            this.fRegName = regName;
        }

        public MIRegisterDMC(MIRegisters service, MIRegisterGroupDMC group, IStack.IFrameDMContext frameDmc, int regNo, String regName) {
            super(service.getSession().getId(), new IDMContext[]{frameDmc, group});
            this.fRegNo = regNo;
            this.fRegName = regName;
        }

        public int getRegNo() {
            return this.fRegNo;
        }

        public String getName() {
            return this.fRegName;
        }

        public boolean equals(Object other) {
            return super.baseEquals(other) && ((MIRegisterDMC)((Object)other)).fRegNo == this.fRegNo && ((MIRegisterDMC)((Object)other)).fRegName.equals(this.fRegName);
        }

        public int hashCode() {
            return super.baseHashCode() ^ this.fRegNo;
        }

        public String toString() {
            return this.baseToString() + ".register[" + this.fRegNo + "]";
        }
    }

    public static class MIRegisterGroupDMC
    extends AbstractDMContext
    implements IRegisters.IRegisterGroupDMContext {
        private final int fGroupNo;
        private final IRunControl.IContainerDMContext parent;
        private String fGroupName;

        public MIRegisterGroupDMC(MIRegisters service, IRunControl.IContainerDMContext contDmc, int groupNo, String groupName) {
            super(service.getSession().getId(), new IDMContext[]{contDmc});
            this.parent = contDmc;
            this.fGroupNo = groupNo;
            this.fGroupName = groupName;
        }

        public int getGroupNo() {
            return this.fGroupNo;
        }

        public String getName() {
            return this.fGroupName;
        }

        public IRunControl.IContainerDMContext getContainerParent() {
            return this.parent;
        }

        public void setName(String groupName) {
            this.fGroupName = groupName;
        }

        public boolean equals(Object other) {
            return super.baseEquals(other) && ((MIRegisterGroupDMC)((Object)other)).fGroupNo == this.fGroupNo && ((MIRegisterGroupDMC)((Object)other)).fGroupName.equals(this.fGroupName);
        }

        public int hashCode() {
            return super.baseHashCode() ^ this.fGroupNo;
        }

        public String toString() {
            return this.baseToString() + ".group[" + this.fGroupNo + "," + this.fGroupName + "]";
        }
    }

    public static class RegisterChangedDMEvent
    implements IRegisters.IRegisterChangedDMEvent {
        private final IRegisters.IRegisterDMContext fRegisterDmc;

        public RegisterChangedDMEvent(IRegisters.IRegisterDMContext registerDMC) {
            this.fRegisterDmc = registerDMC;
        }

        public IRegisters.IRegisterDMContext getDMContext() {
            return this.fRegisterDmc;
        }
    }

    protected static class RegisterData
    implements IRegisters.IRegisterDMData {
        private final String fRegName;
        private final String fRegDesc;
        private final boolean fIsFloat;
        private final IStack.IFrameDMContext fContext;

        public RegisterData(IStack.IFrameDMContext context, String regName, String regDesc, boolean isFloat) {
            this.fRegName = regName;
            this.fRegDesc = regDesc;
            this.fIsFloat = isFloat;
            this.fContext = context;
        }

        public boolean isReadable() {
            return true;
        }

        public boolean isReadOnce() {
            return false;
        }

        public boolean isWriteable() {
            return this.fContext != null;
        }

        public boolean isWriteOnce() {
            return false;
        }

        public boolean hasSideEffects() {
            return false;
        }

        public boolean isVolatile() {
            return true;
        }

        public boolean isFloat() {
            return this.fIsFloat;
        }

        public String getName() {
            return this.fRegName;
        }

        public String getDescription() {
            return this.fRegDesc;
        }
    }
}

