/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.disassembly;

import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.DisassemblyPart;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional.DisassemblySelection;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

class DisassemblySelectionProvider
implements ISelectionProvider {
    private final ListenerList<ISelectionChangedListener> fListenerList = new ListenerList(1);
    private final ISelectionChangedListener fListener = event -> this.fireSelectionChanged(event);
    private final DisassemblyPart fPart;

    DisassemblySelectionProvider(DisassemblyPart disassemblyPart) {
        this.fPart = disassemblyPart;
        this.fPart.getTextViewer().getSelectionProvider().addSelectionChangedListener(this.fListener);
    }

    private void fireSelectionChanged(SelectionChangedEvent event) {
        SelectionChangedEvent newEvent = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (ISelectionChangedListener listener : this.fListenerList) {
            listener.selectionChanged(newEvent);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fListenerList.add((Object)listener);
    }

    public ISelection getSelection() {
        ISourceViewer textViewer = this.fPart.getTextViewer();
        ISelectionProvider provider = textViewer.getSelectionProvider();
        if (provider != null) {
            return new DisassemblySelection((ITextSelection)provider.getSelection(), this.fPart);
        }
        return StructuredSelection.EMPTY;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fListenerList.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        ISelectionProvider provider = this.fPart.getTextViewer().getSelectionProvider();
        if (provider != null) {
            provider.setSelection(selection);
        }
    }
}

