/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.codeactions;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionOptions;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class CodeActionCompletionProposal
implements ICompletionProposal {
    private @Nullable CodeAction fcodeAction;
    private @Nullable Command fcommand;
    private String fdisplayString;
    private final LanguageServerWrapper serverWrapper;

    public CodeActionCompletionProposal(Either<Command, CodeAction> command, LanguageServerWrapper serverWrapper) {
        this.serverWrapper = serverWrapper;
        if (command.isLeft()) {
            this.fcommand = (Command)command.getLeft();
            this.fdisplayString = this.fcommand.getTitle();
        } else {
            this.fcodeAction = (CodeAction)command.getRight();
            this.fdisplayString = this.fcodeAction.getTitle();
        }
    }

    static boolean isCodeActionResolveSupported(@Nullable ServerCapabilities capabilities) {
        if (capabilities != null) {
            CodeActionOptions options;
            Boolean resolveProvider;
            Either caProvider = capabilities.getCodeActionProvider();
            if (caProvider.isLeft()) {
                return (Boolean)caProvider.getLeft();
            }
            if (caProvider.isRight() && (resolveProvider = (options = (CodeActionOptions)caProvider.getRight()).getResolveProvider()) != null) {
                return resolveProvider;
            }
        }
        return false;
    }

    public void apply(IDocument document) {
        CodeAction fcodeAction = this.fcodeAction;
        if (fcodeAction != null) {
            if (CodeActionCompletionProposal.isCodeActionResolveSupported(this.serverWrapper.getServerCapabilities()) && fcodeAction.getEdit() == null) {
                this.serverWrapper.execute(ls -> ls.getTextDocumentService().resolveCodeAction(fcodeAction)).thenAccept(this::apply);
            } else {
                this.apply(fcodeAction);
            }
        } else if (this.fcommand != null) {
            this.executeCommand(this.fcommand);
        }
    }

    private void apply(@Nullable CodeAction codeaction) {
        if (codeaction != null) {
            if (codeaction.getEdit() != null) {
                LSPEclipseUtils.applyWorkspaceEdit(codeaction.getEdit(), codeaction.getTitle());
            }
            if (codeaction.getCommand() != null) {
                this.executeCommand(codeaction.getCommand());
            }
        }
    }

    public @Nullable Point getSelection(IDocument document) {
        return null;
    }

    public @Nullable String getAdditionalProposalInfo() {
        return null;
    }

    public String getDisplayString() {
        return this.fdisplayString;
    }

    public @Nullable Image getImage() {
        return null;
    }

    public @Nullable IContextInformation getContextInformation() {
        return new ContextInformation("some context display string", "some information display string");
    }

    private void executeCommand(Command command) {
        ExecuteCommandOptions provider;
        ServerCapabilities capabilities = this.serverWrapper.getServerCapabilities();
        if (capabilities != null && (provider = capabilities.getExecuteCommandProvider()) != null && provider.getCommands().contains(command.getCommand())) {
            ExecuteCommandParams params = new ExecuteCommandParams();
            params.setCommand(command.getCommand());
            params.setArguments(command.getArguments());
            this.serverWrapper.execute(ls -> ls.getWorkspaceService().executeCommand(params));
        }
    }
}

