/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.gnu.cygwin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.internal.core.Cygwin;
import org.eclipse.cdt.managedbuilder.core.IBuildPathResolver;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.gnu.ui.GnuUIPlugin;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.cdt.utils.WindowsRegistry;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CygwinPathResolver
implements IBuildPathResolver {
    private static final String ENV_PATH = "PATH";
    private static final String DELIMITER_UNIX = ":";
    private static final String DELIMITER_WIN = ";";
    private static final String PROPERTY_OS_NAME = "os.name";
    private static final String OS_WINDOWS = "windows";
    private static final char SLASH = '/';
    private static final char BACKSLASH = '\\';
    private static final String CYGPATH_PATH_LIST_TO_WINDOWS = "cygpath -w -p ";
    private static final String REGISTRY_KEY_MOUNTS = "SOFTWARE\\Cygnus Solutions\\Cygwin\\mounts v2\\";
    private static final String PATH_NAME = "native";
    private static final String BINPATTERN = "/usr/bin";
    private static final String BINPATTERN_ALTERNATE = "/bin";
    private static final String ETCPATTERN = "/etc";
    private static final String GCC_VERSION_CMD = "gcc --version";
    private static final String MINGW_SPECIAL = "mingw ";
    private static final String CYGWIN_SPECIAL = "cygwin ";

    public String[] resolveBuildPaths(int pathType, String variableName, String variableValue, IConfiguration configuration) {
        if (!CygwinPathResolver.isWindows()) {
            return variableValue.split(DELIMITER_UNIX);
        }
        if (CygwinPathResolver.isMinGW(configuration)) {
            return variableValue.split(DELIMITER_WIN);
        }
        String[] lines = CygwinPathResolver.executeInConfigurationContext(CYGPATH_PATH_LIST_TO_WINDOWS + variableValue, configuration);
        if (lines != null && lines.length > 0) {
            String pathList = lines[0].replace('\\', '/');
            return pathList.split(DELIMITER_WIN);
        }
        return variableValue.split(DELIMITER_UNIX);
    }

    @Deprecated
    public static String getEtcPath() {
        String etcCygwin = CygwinPathResolver.getPathFromRoot(ETCPATTERN);
        if (etcCygwin == null) {
            etcCygwin = CygwinPathResolver.readValueFromRegistry("SOFTWARE\\Cygnus Solutions\\Cygwin\\mounts v2\\/etc", PATH_NAME);
        }
        return etcCygwin;
    }

    @Deprecated
    public static String getBinPath() {
        String binCygwin = CygwinPathResolver.getPathFromRoot(BINPATTERN);
        if (binCygwin == null) {
            binCygwin = CygwinPathResolver.getPathFromRoot(BINPATTERN_ALTERNATE);
        }
        if (binCygwin == null) {
            binCygwin = CygwinPathResolver.readValueFromRegistry("SOFTWARE\\Cygnus Solutions\\Cygwin\\mounts v2\\/usr/bin", PATH_NAME);
        }
        return binCygwin;
    }

    @Deprecated
    public static String getRootPath() {
        return Cygwin.getCygwinHome();
    }

    public static boolean isWindows() {
        return System.getProperty(PROPERTY_OS_NAME).toLowerCase().startsWith(OS_WINDOWS);
    }

    private static String readValueFromRegistry(String key, String name) {
        WindowsRegistry registry = WindowsRegistry.getRegistry();
        if (registry != null) {
            String value = registry.getCurrentUserValue(key, name);
            if (value == null) {
                value = registry.getLocalMachineValue(key, name);
            }
            if (value != null) {
                return value.replace('\\', '/');
            }
        }
        return null;
    }

    private static String getPathFromRoot(String relativePath) {
        String path;
        File file;
        String rootCygwin = Cygwin.getCygwinHome();
        if (rootCygwin != null && (file = new File(path = rootCygwin + relativePath)).exists() && file.isDirectory()) {
            return path.replace('\\', '/');
        }
        return null;
    }

    private static String resolveProgram(String program, IConfiguration cfg) {
        String envPathValue = null;
        try {
            IEnvironmentVariable envPathVar = ManagedBuildManager.getEnvironmentVariableProvider().getVariable(ENV_PATH, cfg, true);
            if (envPathVar != null) {
                envPathValue = envPathVar.getValue();
                IPath progPath = PathUtil.findProgramLocation((String)program, (String)envPathValue);
                if (progPath != null) {
                    program = progPath.toOSString();
                }
                program = Cygwin.cygwinToWindowsPath((String)program, (String)envPathValue);
            }
        }
        catch (Exception e) {
            GnuUIPlugin.getDefault().log((IStatus)new Status(2, "org.eclipse.cdt.managedbuilder.gnu.ui", "Problem trying to find program [" + program + "] in $PATH=[" + envPathValue + "]", (Throwable)e));
        }
        return program;
    }

    private static String[] getEnvp(IConfiguration cfg) {
        IEnvironmentVariable[] vars = ManagedBuildManager.getEnvironmentVariableProvider().getVariables(cfg, true);
        String[] envp = new String[vars.length];
        int i = 0;
        while (i < envp.length) {
            envp[i] = vars[i].getName() + "=";
            String value = vars[i].getValue();
            if (value != null) {
                int n = i;
                envp[n] = String.valueOf(envp[n]) + value;
            }
            ++i;
        }
        return envp;
    }

    private static String[] executeInConfigurationContext(String cmd, IConfiguration cfg) {
        String[] result;
        block6: {
            String[] args = cmd.split(" ");
            args[0] = CygwinPathResolver.resolveProgram(args[0], cfg);
            result = null;
            try {
                String[] envp = CygwinPathResolver.getEnvp(cfg);
                Process proc = ProcessFactory.getFactory().exec(args, envp);
                if (proc == null) break block6;
                try (InputStream ein = proc.getInputStream();){
                    String s;
                    BufferedReader d1 = new BufferedReader(new InputStreamReader(ein));
                    ArrayList<String> ls = new ArrayList<String>(10);
                    while ((s = d1.readLine()) != null) {
                        ls.add(s);
                    }
                    result = ls.toArray(new String[0]);
                }
            }
            catch (IOException e) {
                GnuUIPlugin.getDefault().log((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.gnu.ui", "Error executing program [" + cmd + "]", (Throwable)e));
            }
        }
        return result;
    }

    public static boolean isMinGW(IConfiguration cfg) {
        String[] versionInfo = CygwinPathResolver.executeInConfigurationContext(GCC_VERSION_CMD, cfg);
        if (versionInfo != null) {
            int i = 0;
            while (i < versionInfo.length) {
                if (versionInfo[i].indexOf(MINGW_SPECIAL) != -1) {
                    return true;
                }
                if (versionInfo[i].indexOf(CYGWIN_SPECIAL) != -1) {
                    return false;
                }
                ++i;
            }
        }
        return false;
    }
}

