/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.editor;

import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.ITestCase;
import org.eclipse.mylyn.builds.core.ITestResult;
import org.eclipse.mylyn.builds.core.ITestSuite;
import org.eclipse.mylyn.builds.core.TestCaseResult;
import org.eclipse.mylyn.builds.internal.core.BuildPackage;
import org.eclipse.mylyn.builds.internal.core.TestResult;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.builds.ui.BuildImages;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiPlugin;
import org.eclipse.mylyn.internal.builds.ui.actions.ShowTestResultsAction;
import org.eclipse.mylyn.internal.builds.ui.editor.AbstractBuildEditorPart;
import org.eclipse.mylyn.internal.builds.ui.editor.BuildEditorPage;
import org.eclipse.mylyn.internal.builds.ui.editor.Messages;
import org.eclipse.mylyn.internal.builds.ui.editor.TestResultLabelProvider;
import org.eclipse.mylyn.internal.builds.ui.util.TestResultManager;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TestResultPart
extends AbstractBuildEditorPart {
    private static final String ID_POPUP_MENU = "org.eclipse.mylyn.builds.ui.editor.menu.TestResult";
    private MenuManager menuManager;
    private ShowTestResultsAction showTestResultsAction;
    private FilterTestFailuresAction filterTestFailuresAction;
    private TreeViewer viewer;

    public TestResultPart() {
        super(320);
        this.setPartName(Messages.TestResultPart_testResults);
    }

    @Override
    protected Control createContent(Composite parent, FormToolkit toolkit) {
        Composite composite = toolkit.createComposite(parent);
        composite.setLayout((Layout)new GridLayout(6, false));
        ITestResult testResult = this.getInput(IBuild.class).getTestResult();
        if (testResult != null) {
            Label label = this.createLabel(composite, toolkit, Messages.TestResultPart_passed);
            GridDataFactory.defaultsFor((Control)label).indent(0, 0).applyTo((Control)label);
            Text text = this.createTextReadOnly(composite, toolkit, "");
            this.bind(text, IBuild.class, FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{BuildPackage.Literals.BUILD__TEST_RESULT, BuildPackage.Literals.TEST_RESULT__PASS_COUNT}));
            label = this.createLabel(composite, toolkit, Messages.TestResultPart_failed);
            GridDataFactory.defaultsFor((Control)label).indent(0, 0).applyTo((Control)label);
            text = this.createTextReadOnly(composite, toolkit, "");
            this.bind(text, IBuild.class, FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{BuildPackage.Literals.BUILD__TEST_RESULT, BuildPackage.Literals.TEST_RESULT__FAIL_COUNT}));
            label = this.createLabel(composite, toolkit, Messages.TestResultPart_ignored);
            GridDataFactory.defaultsFor((Control)label).indent(0, 0).applyTo((Control)label);
            text = this.createTextReadOnly(composite, toolkit, "");
            this.bind(text, IBuild.class, FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{BuildPackage.Literals.BUILD__TEST_RESULT, BuildPackage.Literals.TEST_RESULT__IGNORED_COUNT}));
        }
        this.viewer = new TreeViewer(toolkit.createTree(composite, 2));
        GridDataFactory.fillDefaults().hint(300, 100).span(6, 1).grab(true, true).applyTo(this.viewer.getControl());
        this.viewer.setContentProvider((IContentProvider)new TestResultContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new TestResultLabelProvider(), null, null));
        this.viewer.addSelectionChangedListener(event -> this.getPage().getSite().getSelectionProvider().setSelection(event.getSelection()));
        this.viewer.addOpenListener(event -> {
            Object item = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (item instanceof ITestSuite) {
                TestResultManager.openInEditor((ITestSuite)item);
            } else if (item instanceof ITestCase) {
                TestResultManager.openInEditor((ITestCase)item);
            }
        });
        this.menuManager = new MenuManager();
        WorkbenchUtil.addDefaultGroups((IMenuManager)this.menuManager);
        this.getPage().getEditorSite().registerContextMenu(ID_POPUP_MENU, this.menuManager, (ISelectionProvider)this.viewer, true);
        Menu menu = this.menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.refresh(testResult);
        this.filterTestFailuresAction.initialize();
        toolkit.paintBordersFor(composite);
        return composite;
    }

    void refresh(ITestResult testResult) {
        if (testResult != null) {
            this.viewer.setInput((Object)testResult);
            boolean hasFailures = testResult.getFailCount() > 0;
            this.filterTestFailuresAction.setEnabled(hasFailures);
            if (!hasFailures) {
                this.filterTestFailuresAction.setChecked(false);
            }
            this.showTestResultsAction.setEnabled(true);
        } else {
            this.viewer.setInput((Object)Messages.TestResultPart_noResults);
            this.filterTestFailuresAction.setEnabled(false);
            this.filterTestFailuresAction.setChecked(false);
            this.showTestResultsAction.setEnabled(false);
        }
    }

    @Override
    public void initialize(BuildEditorPage page) {
        super.initialize(page);
        this.showTestResultsAction = new ShowTestResultsAction();
        this.showTestResultsAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.getInput(IBuild.class)));
        this.filterTestFailuresAction = new FilterTestFailuresAction();
        this.showTestResultsAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.getInput(IBuild.class)));
    }

    @Override
    protected void fillToolBar(ToolBarManager toolBarManager) {
        super.fillToolBar(toolBarManager);
        toolBarManager.add((IAction)this.filterTestFailuresAction);
        toolBarManager.add((IAction)this.showTestResultsAction);
    }

    public class FilterTestFailuresAction
    extends Action {
        private final TestFailureFilter filter;

        public FilterTestFailuresAction() {
            super(Messages.TestResultPart_showFailuresOnly, 2);
            this.filter = new TestFailureFilter();
            this.setToolTipText(Messages.TestResultPart_showFailuresOnly);
            this.setImageDescriptor(BuildImages.FILTER_FAILURES);
            this.setChecked(BuildsUiPlugin.getDefault().getPreferenceStore().getBoolean("editor.testResults.failuresOnly"));
        }

        public void initialize() {
            if (this.isChecked()) {
                this.addFilter();
            }
        }

        private void addFilter() {
            TestResultPart.this.viewer.addFilter((ViewerFilter)this.filter);
            TestResultPart.this.viewer.expandAll();
        }

        private void removeFilter() {
            TestResultPart.this.viewer.removeFilter((ViewerFilter)this.filter);
        }

        public void run() {
            boolean checked = this.isChecked();
            if (checked) {
                this.addFilter();
            } else {
                this.removeFilter();
            }
            BuildsUiPlugin.getDefault().getPreferenceStore().setValue("editor.testResults.failuresOnly", checked);
        }
    }

    private static class TestFailureFilter
    extends ViewerFilter {
        private TestFailureFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof ITestCase) {
                return this.isFailure(element);
            }
            if (element instanceof ITestSuite) {
                for (ITestCase testCase : ((ITestSuite)element).getCases()) {
                    if (!this.isFailure(testCase)) continue;
                    return true;
                }
            }
            return false;
        }

        boolean isFailure(Object element) {
            TestCaseResult status = ((ITestCase)element).getStatus();
            return status == TestCaseResult.FAILED || status == TestCaseResult.REGRESSION;
        }
    }

    static class TestResultContentProvider
    implements ITreeContentProvider {
        private static final Object[] NO_ELEMENTS = new Object[0];
        private TestResult input;

        TestResultContentProvider() {
        }

        public void dispose() {
            this.input = null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ITestSuite) {
                return ((ITestSuite)parentElement).getCases().toArray();
            }
            return NO_ELEMENTS;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == this.input) {
                return this.input.getSuites().toArray();
            }
            if (inputElement instanceof String) {
                return new Object[]{inputElement};
            }
            return NO_ELEMENTS;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ITestSuite) {
                return !((ITestSuite)element).getCases().isEmpty();
            }
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.input = newInput instanceof TestResult ? (TestResult)newInput : null;
        }
    }
}

