/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public class RSCCoreUIUtil {
    public static int launchSyncDialog(final MessageDialog dialog) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                dialog.open();
            }
        });
        return dialog.getReturnCode();
    }

    public static int launchASyncDialog(final MessageDialog dialog) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                dialog.open();
            }
        });
        return dialog.getReturnCode();
    }

    public static ArrayList sortList(ArrayList list) {
        Object[] a = list.toArray();
        Arrays.sort(a);
        list.clear();
        int i = 0;
        while (i < a.length) {
            list.add(a[i]);
            ++i;
        }
        return list;
    }

    public static Vector sortVector(Vector vIn) {
        Object[] a = vIn.toArray();
        Arrays.sort(a);
        vIn.clear();
        int i = 0;
        while (i < a.length) {
            vIn.add(a[i]);
            ++i;
        }
        return vIn;
    }

    protected static Constructor dynamicConstructor(Class cclass, Class[] classes) {
        Constructor constructor = null;
        try {
            constructor = cclass.getConstructor(classes);
        }
        catch (NoSuchMethodException nsme) {
            System.err.println("RSCCoreUIUtil.dynamicConstructor NoSuchMethodException: " + nsme.getMessage());
        }
        return constructor;
    }

    protected static Constructor dynamicConstructor(String classname, Class[] classes) {
        Constructor<?> constructor = null;
        try {
            Class<?> cclass = Class.forName(classname);
            constructor = cclass.getConstructor(classes);
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println("RSCCoreUIUtil.dynamicConstructor ClassNotFoundException: " + cnfe.getMessage());
        }
        catch (NoSuchMethodException nsme) {
            System.err.println("RSCCoreUIUtil.dynamicConstructor NoSuchMethodException: " + nsme.getMessage());
        }
        return constructor;
    }

    protected static Method dynamicMethod(Class cclass, String methodname, Class[] classes) {
        Method method = null;
        try {
            method = cclass.getMethod(methodname, classes);
        }
        catch (NoSuchMethodException nsme) {
            System.err.println("RSCCoreUIUtil.dynamicMethod NoSuchMethodException: " + nsme.getMessage());
        }
        return method;
    }

    protected static Method dynamicMethod(String classname, String methodname, Class[] classes) {
        Method method = null;
        try {
            Class<?> cclass = Class.forName(classname);
            method = RSCCoreUIUtil.dynamicMethod(cclass, methodname, classes);
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println("RSCCoreUIUtil.dynamicMethod ClassNotFoundException: " + cnfe.getMessage());
        }
        return method;
    }

    public static Object dynamicInstance(Class cclass, Class[] classes, Object[] args) {
        Object result = null;
        Constructor constructor = RSCCoreUIUtil.dynamicConstructor(cclass, classes);
        if (constructor != null) {
            try {
                result = constructor.newInstance(args);
            }
            catch (InstantiationException ie) {
                System.err.println("RSCCoreUIUtil.dynamicInstance InstantiationException: " + ie.getMessage());
            }
            catch (IllegalAccessException iae) {
                System.err.println("RSCCoreUIUtil.dynamicInstance IllegalAccessException: " + iae.getMessage());
            }
            catch (InvocationTargetException ite) {
                String msg = ite.getMessage();
                if (msg == null) {
                    msg = ite.getTargetException().getMessage();
                }
                System.err.println("RSCCoreUIUtil.dynamicInstance InvocationTargetException: " + msg);
            }
            catch (IllegalArgumentException iarge) {
                System.err.println("RSCCoreUIUtil.dynamicInstance IllegalArgumentException: " + iarge.getMessage());
            }
        }
        return result;
    }

    public static Object dynamicInstance(String classname, Class[] classes, Object[] args) {
        Object result = null;
        Constructor constructor = RSCCoreUIUtil.dynamicConstructor(classname, classes);
        if (constructor != null) {
            try {
                result = constructor.newInstance(args);
            }
            catch (InstantiationException ie) {
                System.err.println("RSCCoreUIUtil.dynamicInstance InstantiationException: " + ie.getMessage());
            }
            catch (IllegalAccessException iae) {
                System.err.println("RSCCoreUIUtil.dynamicInstance IllegalAccessException: " + iae.getMessage());
            }
            catch (InvocationTargetException ite) {
                String msg = ite.getMessage();
                if (msg == null) {
                    msg = ite.getTargetException().getMessage();
                }
                System.err.println("RSCCoreUIUtil.dynamicInstance InvocationTargetException: " + msg);
            }
            catch (IllegalArgumentException iarge) {
                System.err.println("RSCCoreUIUtil.dynamicInstance IllegalArgumentException: " + iarge.getMessage());
            }
        }
        return result;
    }

    public static Object dynamicInvoke(Object instance, String methodname, Class[] classes, Object[] args) {
        Object ok = Boolean.TRUE;
        try {
            Method method = RSCCoreUIUtil.dynamicMethod(instance.getClass(), methodname, classes);
            ok = method != null ? method.invoke(instance, args) : null;
        }
        catch (NullPointerException npe) {
            System.err.println("RSCCoreUIUtil.dynamicInvoke NullPointerException: " + npe.getMessage());
            ok = null;
        }
        catch (IllegalAccessException iae) {
            System.err.println("RSCCoreUIUtil.dynamicInvoke IllegalAccessException: " + iae.getMessage());
            ok = null;
        }
        catch (InvocationTargetException ite) {
            String msg = ite.getMessage();
            if (msg == null) {
                msg = ite.getTargetException().getMessage();
            }
            System.err.println("RSCCoreUIUtil.dynamicInvoke InvocationTargetException: " + msg);
            ok = null;
        }
        catch (IllegalArgumentException iarge) {
            System.err.println("RSCCoreUIUtil.dynamicInvoke IllegalArgumentException: " + iarge.getMessage());
            ok = null;
        }
        return ok;
    }

    public static Object staticInvoke(String classname, String methodname, Class[] classes, Object[] args) {
        Object ok = Boolean.TRUE;
        try {
            Method method = RSCCoreUIUtil.dynamicMethod(classname, methodname, classes);
            if (method != null) {
                ok = method.invoke(null, args);
            }
        }
        catch (NullPointerException npe) {
            System.err.println("RSCCoreUIUtil.dynamicInvoke NullPointerException: " + npe.getMessage());
            ok = null;
        }
        catch (IllegalAccessException iae) {
            System.err.println("RSCCoreUIUtil.dynamicInvoke IllegalAccessException: " + iae.getMessage());
            ok = null;
        }
        catch (InvocationTargetException ite) {
            String msg = ite.getMessage();
            if (msg == null) {
                msg = ite.getTargetException().getMessage();
            }
            System.err.println("RSCCoreUIUtil.dynamicInvoke InvocationTargetException: " + msg);
            ok = null;
        }
        catch (IllegalArgumentException iarge) {
            System.err.println("RSCCoreUIUtil.dynamicInvoke IllegalArgumentException: " + iarge.getMessage());
            ok = null;
        }
        return ok;
    }

    public static Object staticInvoke(Class cclass, String methodname, Class[] classes, Object[] args) {
        Object ok = Boolean.TRUE;
        try {
            Method method = RSCCoreUIUtil.dynamicMethod(cclass, methodname, classes);
            if (method != null) {
                ok = method.invoke(null, args);
            }
        }
        catch (NullPointerException npe) {
            System.err.println("RSCCoreUIUtil.dynamicInvoke NullPointerException: " + npe.getMessage());
            ok = null;
        }
        catch (IllegalAccessException iae) {
            System.err.println("RSCCoreUIUtil.dynamicInvoke IllegalAccessException: " + iae.getMessage());
            ok = null;
        }
        catch (InvocationTargetException ite) {
            String msg = ite.getMessage();
            if (msg == null) {
                msg = ite.getTargetException().getMessage();
            }
            System.err.println("RSCCoreUIUtil.dynamicInvoke InvocationTargetException: " + msg);
            ok = null;
        }
        catch (IllegalArgumentException iarge) {
            System.err.println("RSCCoreUIUtil.dynamicInvoke IllegalArgumentException: " + iarge.getMessage());
            ok = null;
        }
        return ok;
    }

    public static Object staticField(Class cclass, String fieldname) {
        Object value = null;
        try {
            Field field = cclass.getDeclaredField(fieldname);
            value = field.get(null);
        }
        catch (NoSuchFieldException nsfe) {
            System.err.println("RSCCoreUIUtil.staticField NoSuchFieldException: " + nsfe.getMessage());
        }
        catch (IllegalAccessException iae) {
            System.err.println("RSCCoreUIUtil.staticField NoSuchFieldException: " + iae.getMessage());
        }
        return value;
    }

    public static Object staticField(String classname, String fieldname) {
        Object value = null;
        try {
            Class<?> cclass = Class.forName(classname);
            Field field = cclass.getDeclaredField(fieldname);
            value = field.get(null);
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println("RSCCoreUIUtil.staticField ClassNotFoundException: " + cnfe.getMessage());
        }
        catch (NoSuchFieldException nsfe) {
            System.err.println("RSCCoreUIUtil.staticField NoSuchFieldException: " + nsfe.getMessage());
        }
        catch (IllegalAccessException iae) {
            System.err.println("RSCCoreUIUtil.staticField NoSuchFieldException: " + iae.getMessage());
        }
        return value;
    }

    public static Class dynamicClass(String classname) {
        Class<?> cclass = null;
        try {
            cclass = Class.forName(classname);
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println("RSCCoreUIUtil.dynamicClass ClassNotFoundException: " + cnfe.getMessage());
        }
        return cclass;
    }

    public static boolean chkIfEObjectsMatched(EObject working, EObject base, boolean chkCrossReferences) {
        if (base == null || working == null) {
            return false;
        }
        if (base.equals(working)) {
            return true;
        }
        if (chkCrossReferences && RSCCoreUIUtil.chkCrossReferences(working.eCrossReferences(), base)) {
            return true;
        }
        EObject parent = working.eContainer();
        if (parent == null) {
            return false;
        }
        return RSCCoreUIUtil.chkIfEObjectsMatched(parent, base, chkCrossReferences);
    }

    public static boolean chkCrossReferences(EList refs, EObject base) {
        int i = 0;
        while (i < refs.size()) {
            Object obj = refs.get(i);
            if (obj != null && obj instanceof EObject && RSCCoreUIUtil.chkIfEObjectsMatched((EObject)obj, base, false)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

