"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.collectExtractProps = collectExtractProps;
exports.getImportPathForFile = getImportPathForFile;
exports.getPropertiesAtLocation = getPropertiesAtLocation;
exports.getQuickInfoAtPosition = getQuickInfoAtPosition;
exports.getComponentProps = getComponentProps;
exports.getComponentEvents = getComponentEvents;
exports.getTemplateContextProps = getTemplateContextProps;
exports.getComponentNames = getComponentNames;
exports.getElementAttrs = getElementAttrs;
const utils_1 = require("./utils");
function collectExtractProps(...args) {
    return sendRequest('collectExtractProps', ...args);
}
async function getImportPathForFile(...args) {
    return await sendRequest('getImportPathForFile', ...args);
}
async function getPropertiesAtLocation(...args) {
    return await sendRequest('getPropertiesAtLocation', ...args);
}
function getQuickInfoAtPosition(...args) {
    return sendRequest('getQuickInfoAtPosition', ...args);
}
// Component Infos
async function getComponentProps(fileName, componentName) {
    const server = await (0, utils_1.getBestServer)(fileName);
    if (!server) {
        return;
    }
    return await server.getComponentProps(fileName, componentName);
}
function getComponentEvents(...args) {
    return sendRequest('getComponentEvents', ...args);
}
function getTemplateContextProps(...args) {
    return sendRequest('getTemplateContextProps', ...args);
}
async function getComponentNames(fileName) {
    const server = await (0, utils_1.getBestServer)(fileName);
    if (!server) {
        return;
    }
    const componentAndProps = server.componentNamesAndProps.get(fileName);
    if (!componentAndProps) {
        return;
    }
    return Object.keys(componentAndProps);
}
function getElementAttrs(...args) {
    return sendRequest('getElementAttrs', ...args);
}
async function sendRequest(requestType, fileName, ...rest) {
    const server = await (0, utils_1.getBestServer)(fileName);
    if (!server) {
        return;
    }
    return server.sendRequest(requestType, fileName, ...rest);
}
//# sourceMappingURL=client.js.map