/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class LUWContainerType
extends AbstractEnumerator {
    public static final int DEVICE = 0;
    public static final int DIRECTORY = 1;
    public static final int FILE = 2;
    public static final LUWContainerType DEVICE_LITERAL = new LUWContainerType(0, "DEVICE", "DEVICE");
    public static final LUWContainerType DIRECTORY_LITERAL = new LUWContainerType(1, "DIRECTORY", "DIRECTORY");
    public static final LUWContainerType FILE_LITERAL = new LUWContainerType(2, "FILE", "FILE");
    private static final LUWContainerType[] VALUES_ARRAY = new LUWContainerType[]{DEVICE_LITERAL, DIRECTORY_LITERAL, FILE_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static LUWContainerType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LUWContainerType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LUWContainerType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LUWContainerType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LUWContainerType get(int value) {
        switch (value) {
            case 0: {
                return DEVICE_LITERAL;
            }
            case 1: {
                return DIRECTORY_LITERAL;
            }
            case 2: {
                return FILE_LITERAL;
            }
        }
        return null;
    }

    private LUWContainerType(int value, String name, String literal) {
        super(value, name, literal);
    }
}

