/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.osgi.fxloader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.fx.osgi.fxloader.FXClassloaderConfigurator;
import org.eclipse.fx.osgi.fxloader.jpms.AddOpenExports;
import org.eclipse.fx.osgi.fxloader.jpms.AddReads;
import org.eclipse.fx.osgi.fxloader.jpms.ConfigurationWrapper;
import org.eclipse.fx.osgi.fxloader.jpms.JavaModuleLayerModification;
import org.eclipse.fx.osgi.fxloader.jpms.ModuleFinderWrapper;
import org.eclipse.fx.osgi.fxloader.jpms.ModuleLayerWrapper;
import org.eclipse.fx.osgi.fxloader.jpms.ModuleWrapper;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.internal.hookregistry.ClassLoaderHook;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.ModuleClassLoader;
import org.eclipse.osgi.service.urlconversion.URLConverter;
import org.eclipse.osgi.storage.BundleInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.ServiceTracker;

public class FXClassLoader
extends ClassLoaderHook {
    private static final String FX_SYMBOLIC_NAME = "org.eclipse.fx.javafx";
    private static final String SWT_SYMBOLIC_NAME = "org.eclipse.swt";
    private AtomicBoolean boostrappingModules = new AtomicBoolean();
    private URLClassLoader classLoader;
    private BundleContext frameworkContext;
    private ClassLoader j9Classloader;
    private ModuleLayerWrapper moduleLayer;
    private ClassLoader j11Classloader;
    private static Boolean IS_EQUAL_GREATER_11;
    private static Boolean IS_JAVA_8;
    private static Map<String, ServiceTracker<Object, URLConverter>> urlTrackers;
    private Set<String> j11ModulePackages;
    private ThreadLocal<Boolean> reentrance = ThreadLocal.withInitial(() -> false);

    static {
        urlTrackers = new HashMap<String, ServiceTracker<Object, URLConverter>>();
    }

    static boolean isJDK8() {
        if (IS_JAVA_8 != null) {
            return IS_JAVA_8;
        }
        boolean rv = System.getProperty("java.version", "").startsWith("1.8");
        IS_JAVA_8 = rv;
        return rv;
    }

    private static boolean isEqualGreaterJDK11() {
        if (IS_EQUAL_GREATER_11 != null) {
            return IS_EQUAL_GREATER_11;
        }
        String version = System.getProperty("java.version", "");
        String[] parts = version.split("\\D");
        boolean rv = false;
        try {
            rv = Integer.parseInt(parts[0]) >= 11;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        IS_EQUAL_GREATER_11 = rv;
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Class<?> postFindClass(String name, ModuleClassLoader moduleClassLoader) throws ClassNotFoundException {
        if (this.reentrance.get().booleanValue()) {
            if (FXClassloaderConfigurator.DEBUG) {
                System.err.println("FXClassLoader#postFindClass - Loop detected returning null");
            }
            return null;
        }
        this.reentrance.set(true);
        try {
            if (FXClassLoader.isJDK8()) {
                if ((name.startsWith("javafx") || name.startsWith("netscape.javascript") || name.startsWith("com.sun.glass.events") || name.startsWith("com.sun.glass.ui") || name.startsWith("com.sun.javafx") || name.startsWith("com.sun.media.jfxmedia") || name.startsWith("com.sun.media.jfxmediaimpl") || name.startsWith("com.sun.openpisces") || name.startsWith("com.sun.pisces") || name.startsWith("com.sun.prism") || name.startsWith("com.sun.scenario") || name.startsWith("com.sun.webkit")) && !moduleClassLoader.getBundle().getSymbolicName().equals(SWT_SYMBOLIC_NAME)) {
                    URLClassLoader fxClassloader = this.getFXClassloader();
                    if (fxClassloader != null) {
                        Class<?> clazz = fxClassloader.loadClass(name);
                        return clazz;
                    }
                    throw new ClassNotFoundException("Unable to locate JavaFX. Please make sure you have a JDK with JavaFX installed eg on Linux you require an Oracle JDK");
                }
            } else {
                if (FXClassLoader.isEqualGreaterJDK11()) {
                    try {
                        Class<?> clazz = this.findClassJavaFX11(name, moduleClassLoader);
                        return clazz;
                    }
                    catch (Throwable e) {
                        if (FXClassloaderConfigurator.DEBUG) {
                            System.err.println("FXClassLoader#postFindClass - exception while loading " + e.getMessage() + ". Continue delegation by returning NULL");
                            e.printStackTrace();
                        }
                        this.reentrance.remove();
                        return null;
                    }
                }
                if (name.startsWith("javafx.embed")) {
                    FXClassLoader fXClassLoader = this;
                    synchronized (fXClassLoader) {
                        if (this.j9Classloader == null) {
                            try {
                                this.j9Classloader = this.getModuleLayer().findLoader("javafx.swt");
                                try {
                                    this.j9Classloader.loadClass("javafx.application.Platform").getDeclaredMethod("setImplicitExit", Boolean.TYPE).invoke(null, Boolean.FALSE);
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                }
                            }
                            catch (Throwable e) {
                                throw new ClassNotFoundException("Could not find class '" + name + "'", e);
                            }
                        }
                        Class<?> clazz = this.j9Classloader.loadClass(name);
                        return clazz;
                    }
                }
            }
            Class clazz = super.postFindClass(name, moduleClassLoader);
            return clazz;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.reentrance.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Class<?> findClassJavaFX11(String name, ModuleClassLoader moduleClassLoader) throws Throwable {
        if (FXClassloaderConfigurator.DEBUG) {
            System.err.println("FXClassLoader#findClassJavaFX11 - started");
            System.err.println("FXClassLoader#findClassJavaFX11 - Loading class '" + name + "' for " + moduleClassLoader);
        }
        FXClassLoader fXClassLoader = this;
        synchronized (fXClassLoader) {
            if (this.j11ModulePackages != null && this.j11ModulePackages.isEmpty()) {
                if (!FXClassloaderConfigurator.DEBUG) return null;
                System.err.println("FXClassLoader#findClassJavaFX11 - Loader is empty. Returning null.");
                return null;
            }
            if (this.boostrappingModules.get()) {
                System.err.println("FXClassLoader#findClassJavaFX11 - Loading '" + name + "' while we bootstrap. Returning null.");
                return null;
            }
            if (this.j11Classloader == null) {
                try {
                    this.boostrappingModules.set(true);
                    ModuleLayerWrapper layer = this.getModuleLayer();
                    Set<ModuleWrapper> modules = layer.modules();
                    if (modules.isEmpty()) return null;
                    this.j11Classloader = layer.findLoader(modules.iterator().next().getName());
                    this.j11ModulePackages = modules.stream().flatMap(m -> m.getPackages().stream()).collect(Collectors.toSet());
                }
                finally {
                    this.boostrappingModules.set(false);
                }
            }
        }
        if (FXClassloaderConfigurator.DEBUG) {
            System.err.println("FXClassLoader#findClassJavaFX11 - Using classloader " + this.j11Classloader);
        }
        if (name.startsWith("javafx.embed.swt")) {
            try {
                if (FXClassloaderConfigurator.DEBUG) {
                    System.err.println("FXClassLoader#findClassJavaFX11 - We are using SWT FXCanvas - don't let the platform quit automatically");
                }
                this.j11Classloader.loadClass("javafx.application.Platform").getDeclaredMethod("setImplicitExit", Boolean.TYPE).invoke(null, Boolean.FALSE);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        int lastIndexOf = name.lastIndexOf(46);
        Class<?> loadedClass = null;
        try {
            if (lastIndexOf < 0) {
                return null;
            }
            if (!this.j11ModulePackages.contains(name.substring(0, lastIndexOf))) {
                return null;
            }
            Class<?> clazz = loadedClass = this.j11Classloader.loadClass(name);
            return clazz;
        }
        finally {
            if (FXClassloaderConfigurator.DEBUG) {
                System.err.println("FXClassLoader#findClassJavaFX11 - " + loadedClass + " - ended");
            }
        }
    }

    private synchronized ModuleLayerWrapper getModuleLayer() throws Throwable {
        if (FXClassLoader.isEqualGreaterJDK11()) {
            if (this.moduleLayer == null) {
                String javafxDir = System.getProperty("efxclipse.java-modules.dir");
                List<Object> providers = new ArrayList();
                if (javafxDir == null) {
                    providers = FXClassLoader.getDeployedJavaModuleBundlePaths(this.frameworkContext);
                } else {
                    String[] paths;
                    if (FXClassloaderConfigurator.DEBUG) {
                        System.err.println("FXClassLoader#getModuleLayer - Use directory '" + javafxDir + "'");
                    }
                    String[] stringArray = paths = javafxDir.split(";");
                    int n = paths.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String dir = stringArray[n2];
                        Path path = Paths.get(FXClassLoader.replaceProperties(dir), new String[0]);
                        if (FXClassloaderConfigurator.DEBUG) {
                            System.err.println("FXClassLoader#getModuleLayer - Inspecting path '" + path + "'");
                        }
                        if (Files.exists(path, new LinkOption[0])) {
                            providers = Files.list(path).filter(p -> p.toString().endsWith(".jar")).map(p -> new FXProviderBundle(p.getFileName().toString().replace(".jar", "").replace('-', '.'), (Path)p)).collect(Collectors.toList());
                            break;
                        }
                        ++n2;
                    }
                }
                ClassLoader parentClassloader = FXClassLoader.getSWTClassloader(this.frameworkContext);
                if (parentClassloader == null) {
                    parentClassloader = ((Object)((Object)this)).getClass().getClassLoader();
                }
                if (FXClassloaderConfigurator.DEBUG) {
                    System.err.println("FXClassLoader#getModuleLayer - Parent Classloader: " + parentClassloader);
                }
                this.moduleLayer = FXClassLoader.initModuleLayer(parentClassloader, providers, FXClassLoader.collectModifications(this.frameworkContext));
                if (FXClassloaderConfigurator.DEBUG) {
                    System.err.println("FXClassLoader#getModuleLayer - Module created: " + this.moduleLayer);
                }
            }
        } else if (this.moduleLayer == null) {
            Path path = Paths.get(System.getProperty("java.home"), new String[0]).resolve("lib").resolve("javafx-swt.jar");
            ClassLoader parentClassloader = FXClassLoader.getSWTClassloader(this.frameworkContext);
            if (parentClassloader == null) {
                parentClassloader = ((Object)((Object)this)).getClass().getClassLoader();
            }
            this.moduleLayer = FXClassLoader.initModuleLayer(parentClassloader, Collections.singletonList(new FXProviderBundle("javafx.swt", path)), JavaModuleLayerModification.empty());
        }
        return this.moduleLayer;
    }

    private static String replaceProperties(String path) {
        Properties properties = System.getProperties();
        String rv = path;
        for (Map.Entry<Object, Object> e : properties.entrySet()) {
            String value = "" + e.getValue();
            value = System.getProperty("os.name").toLowerCase().contains("windows") ? value.replace("file:/", "") : value.replace("file:", "");
            rv = rv.replace("$(" + e.getKey() + ")", value);
        }
        return rv;
    }

    private static JavaModuleLayerModification collectModifications(BundleContext context) {
        Bundle[] bundles;
        HashSet<AddReads> reads = new HashSet<AddReads>();
        HashSet<AddOpenExports> opens = new HashSet<AddOpenExports>();
        HashSet<AddOpenExports> exports = new HashSet<AddOpenExports>();
        Bundle[] bundleArray = bundles = context.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if (FXClassloaderConfigurator.DEBUG) {
                System.err.println("FXClassLoader#collectModifications - Analyzing " + b);
            }
            if ((b.getState() & 4) == 4 || (b.getState() & 8) == 8 || (b.getState() & 0x20) == 32) {
                if (b.getHeaders().get("Java-Module-AddOpens") != null) {
                    if (FXClassloaderConfigurator.DEBUG) {
                        System.err.println("FXClassLoader#collectModifications - Opens Header found " + (String)b.getHeaders().get("Java-Module-AddOpens"));
                    }
                    opens.addAll(FXClassLoader.toOpenExports((String)b.getHeaders().get("Java-Module-AddOpens"), b));
                }
                if (b.getHeaders().get("Java-Module-AddExports") != null) {
                    if (FXClassloaderConfigurator.DEBUG) {
                        System.err.println("FXClassLoader#collectModifications - Exports Header found " + (String)b.getHeaders().get("Java-Module-AddExports"));
                    }
                    exports.addAll(FXClassLoader.toOpenExports((String)b.getHeaders().get("Java-Module-AddExports"), b));
                }
                if (b.getHeaders().get("Java-Module-AddReads") != null) {
                    if (FXClassloaderConfigurator.DEBUG) {
                        System.err.println("FXClassLoader#collectModifications - Reads Header found " + (String)b.getHeaders().get("Java-Module-AddReads"));
                    }
                    reads.addAll(FXClassLoader.toReads((String)b.getHeaders().get("Java-Module-AddReads"), b));
                }
            } else if (FXClassloaderConfigurator.DEBUG) {
                System.err.println("Skipped Bundle: " + b);
            }
            ++n2;
        }
        String addReads = System.getProperty("efxclipse.osgi.hook.add-reads");
        String addOpens = System.getProperty("efxclipse.osgi.hook.add-opens");
        String addExports = System.getProperty("efxclipse.osgi.hook.add-exports");
        if (addReads != null) {
            reads.addAll(FXClassLoader.toReads(addReads, null));
        }
        if (addExports != null) {
            exports.addAll(FXClassLoader.toOpenExports(addExports, null));
        }
        if (addOpens != null) {
            opens.addAll(FXClassLoader.toOpenExports(addOpens, null));
        }
        if (FXClassloaderConfigurator.DEBUG) {
            System.err.println("FXClassLoader#collectModifications - Reads: " + reads);
            System.err.println("FXClassLoader#collectModifications - Exports: " + exports);
            System.err.println("FXClassLoader#collectModifications - Opens: " + opens);
        }
        return new JavaModuleLayerModification(context.getBundles(), reads, exports, opens);
    }

    private static String adaptAllUnnamed(String value, Bundle bundle) {
        if (value.endsWith("=.") && bundle != null) {
            return value.replace("=.", "=BUNDLE(@" + bundle.getBundleId() + ")");
        }
        return value;
    }

    private static Set<AddReads> toReads(String value, Bundle bundle) {
        return Stream.of(value.split(",")).map(v -> FXClassLoader.adaptAllUnnamed(v, bundle)).map(AddReads::valueOf).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    private static Set<AddOpenExports> toOpenExports(String value, Bundle bundle) {
        return Stream.of(value.split(",")).map(v -> FXClassLoader.adaptAllUnnamed(v, bundle)).map(AddOpenExports::valueOf).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    private static ModuleLayerWrapper initModuleLayer(ClassLoader parentClassloader, List<FXProviderBundle> bundles, JavaModuleLayerModification modifications) throws Throwable {
        try {
            if (Boolean.getBoolean("efxclipse.osgi.hook.advanced-modules") || !modifications.isEmpty()) {
                return FXClassLoader.advancedModuleLayerBoostrap(parentClassloader, bundles, modifications);
            }
            return FXClassLoader.defaultModuleLayerBootstrap(parentClassloader, bundles);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
    }

    private static ModuleLayerWrapper advancedModuleLayerBoostrap(ClassLoader parentClassloader, List<FXProviderBundle> bundles, JavaModuleLayerModification modifications) throws Throwable {
        if (FXClassloaderConfigurator.DEBUG) {
            System.err.println("FXClassLoader#advancedModuleLayerBoostrap - Using advanced layer creation to apply patches");
        }
        Path[] paths = (Path[])bundles.stream().map(p -> p.path).toArray(Path[]::new);
        Set<String> modules = bundles.stream().map(p -> p.module).collect(Collectors.toSet());
        URL[] urls = (URL[])Stream.of(paths).map(Path::toFile).map(f -> {
            try {
                return f.toURI().toURL();
            }
            catch (Throwable t) {
                return null;
            }
        }).toArray(URL[]::new);
        if (FXClassloaderConfigurator.DEBUG) {
            for (FXProviderBundle b : bundles) {
                System.err.println("FXClassLoader#advancedModuleLayerBoostrap - " + b.module + " => " + b.path);
            }
        }
        URLClassLoader c = new URLClassLoader(urls, parentClassloader){

            @Override
            protected Class<?> findClass(String moduleName, String name) {
                try {
                    return this.findClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }

            @Override
            protected URL findResource(String moduleName, String name) throws IOException {
                return this.findResource(name);
            }
        };
        ModuleFinderWrapper fxModuleFinder = ModuleFinderWrapper.of(paths);
        ModuleFinderWrapper empty = ModuleFinderWrapper.of(new Path[0]);
        ModuleLayerWrapper bootLayer = ModuleLayerWrapper.boot();
        ConfigurationWrapper configuration = bootLayer.configuration();
        ConfigurationWrapper newConfiguration = configuration.resolve(fxModuleFinder, empty, modules);
        Function<String, ClassLoader> clComputer = s -> c;
        ModuleLayerWrapper.ControllerWrapper moduleLayerController = ModuleLayerWrapper.defineModules(newConfiguration, Arrays.asList(bootLayer), clComputer);
        modifications.applyConfigurations(moduleLayerController);
        return moduleLayerController.layer();
    }

    private static ModuleLayerWrapper defaultModuleLayerBootstrap(ClassLoader parentClassloader, List<FXProviderBundle> bundles) throws Throwable {
        Path[] paths = (Path[])bundles.stream().map(p -> p.path).toArray(Path[]::new);
        Set<String> modules = bundles.stream().map(p -> p.module).collect(Collectors.toSet());
        if (FXClassloaderConfigurator.DEBUG) {
            for (FXProviderBundle b : bundles) {
                System.err.println("FXClassLoader#defaultModuleLayerBootstrap - " + b.module + " => " + b.path);
            }
        }
        ModuleFinderWrapper finder = ModuleFinderWrapper.of(paths);
        ModuleLayerWrapper boot = ModuleLayerWrapper.boot();
        ConfigurationWrapper configuration = boot.configuration();
        ModuleFinderWrapper of = ModuleFinderWrapper.of(new Path[0]);
        ConfigurationWrapper cf = configuration.resolve(finder, of, modules);
        ModuleLayerWrapper layer = boot.defineModulesWithOneLoader(cf, parentClassloader);
        return layer;
    }

    private URLClassLoader getFXClassloader() {
        if (this.classLoader == null) {
            ClassLoader swtClassloader = FXClassLoader.getSWTClassloader(this.frameworkContext);
            this.classLoader = FXClassLoader.createJREBundledClassloader(swtClassloader == null ? ClassLoader.getSystemClassLoader() : swtClassloader, swtClassloader != null);
        }
        return this.classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static URLConverter getURLConverter(URL url, BundleContext ctx) {
        if (url == null || ctx == null) {
            return null;
        }
        String protocol = url.getProtocol();
        Map<String, ServiceTracker<Object, URLConverter>> map = urlTrackers;
        synchronized (map) {
            ServiceTracker tracker = urlTrackers.get(protocol);
            if (tracker == null) {
                String FILTER_PREFIX = "(&(objectClass=" + URLConverter.class.getName() + ")(protocol=";
                String FILTER_POSTFIX = "))";
                Filter filter = null;
                try {
                    filter = ctx.createFilter(String.valueOf(FILTER_PREFIX) + protocol + FILTER_POSTFIX);
                }
                catch (InvalidSyntaxException e) {
                    return null;
                }
                tracker = new ServiceTracker(ctx, filter, null);
                tracker.open();
                urlTrackers.put(protocol, (ServiceTracker<Object, URLConverter>)tracker);
            }
            return (URLConverter)tracker.getService();
        }
    }

    public synchronized ModuleClassLoader createClassLoader(ClassLoader parent, EquinoxConfiguration configuration, BundleLoader delegate, BundleInfo.Generation generation) {
        if (this.frameworkContext == null) {
            this.frameworkContext = generation.getBundleInfo().getStorage().getModuleContainer().getFrameworkWiring().getBundle().getBundleContext();
        }
        if (FX_SYMBOLIC_NAME.equals(generation.getRevision().getBundle().getSymbolicName())) {
            System.err.println("ERROR: Binding against 'org.eclipse.fx.javafx' had been deprecated since 2.x and has been removed in 3.x ");
        }
        return super.createClassLoader(parent, configuration, delegate, generation);
    }

    private static ClassLoader getSWTClassloader(BundleContext context) {
        if (FXClassloaderConfigurator.DEBUG) {
            System.err.println("FXClassLoader#getSWTClassloader - Fetching SWT-Classloader");
        }
        try {
            Bundle[] bundleArray = context.getBundles();
            int n = bundleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle b = bundleArray[n2];
                if (SWT_SYMBOLIC_NAME.equals(b.getSymbolicName()) && (b.getState() & 2) == 0) {
                    if ((b.getState() & 0x20) != 0) {
                        try {
                            b.start();
                        }
                        catch (BundleException e) {
                            e.printStackTrace();
                        }
                    }
                    ClassLoader classLoader = ((BundleWiring)b.adapt(BundleWiring.class)).getClassLoader();
                    return classLoader;
                }
                try {
                    ++n2;
                    continue;
                }
                catch (Throwable t) {
                    System.err.println("Failed to access swt classloader");
                    t.printStackTrace();
                }
                break;
            }
        }
        finally {
            if (FXClassloaderConfigurator.DEBUG) {
                System.err.println("FXClassLoader#getSWTClassloader - Done SWT-Classloader");
            }
        }
        return null;
    }

    private static List<FXProviderBundle> getDeployedJavaModuleBundlePaths(BundleContext context) {
        ArrayList<FXProviderBundle> paths = new ArrayList<FXProviderBundle>();
        if (FXClassloaderConfigurator.DEBUG) {
            System.err.println("FXClassLoader#getDeployedJavaModuleBundlePaths - Loading libraries from deployed modules");
        }
        Bundle[] bundleArray = context.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if (((b.getState() & 4) == 4 || (b.getState() & 8) == 8 || (b.getState() & 0x20) == 32) && b.getHeaders().get("Java-Module") != null) {
                URL entry;
                String name = (String)b.getHeaders().get("Java-Module");
                if (FXClassloaderConfigurator.DEBUG) {
                    System.err.println("FXClassLoader#getDeployedJavaModuleBundlePaths - Found OSGi-Module with JPMS-Module '" + name + "'");
                }
                if ((entry = b.getEntry(String.valueOf(name) + ".jar")) == null) {
                    entry = b.getEntry(String.valueOf(name.replace('.', '-')) + ".jar");
                }
                if (FXClassloaderConfigurator.DEBUG) {
                    System.err.println("FXClassLoader#getDeployedJavaModuleBundlePaths - Found Jar '" + entry + "'");
                }
                if (entry != null) {
                    URLConverter converter = FXClassLoader.getURLConverter(entry, context);
                    try {
                        URL url = converter.toFileURL(entry);
                        if (FXClassloaderConfigurator.DEBUG) {
                            System.err.println("FXClassLoader#getDeployedJavaModuleBundlePaths - Converted URL: " + url);
                        }
                        String file = url.getFile();
                        if (System.getProperty("os.name").toLowerCase().contains("windows") && file.startsWith("/")) {
                            file = file.substring(1);
                        }
                        paths.add(new FXProviderBundle(name, Paths.get(file, new String[0])));
                    }
                    catch (Throwable e) {
                        if (FXClassloaderConfigurator.DEBUG) {
                            System.err.println("Failed to load get path");
                            e.printStackTrace();
                        }
                        throw new IllegalStateException(e);
                    }
                }
            }
            ++n2;
        }
        return paths;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static URLClassLoader createJREBundledClassloader(ClassLoader parent, boolean swtAvailable) {
        block30: {
            if (FXClassloaderConfigurator.DEBUG) {
                System.err.println("FXClassLoader#createJREBundledClassloader - Started");
            }
            try {
                javaHome = new File(System.getProperty("java.home")).getCanonicalFile();
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to locate java home", e);
            }
            if (!javaHome.exists()) {
                throw new IllegalStateException("The java home '" + javaHome.getAbsolutePath() + "' does not exits");
            }
            jarFile = new File(new File(new File(javaHome.getAbsolutePath(), "lib"), "ext"), "jfxrt.jar");
            if (FXClassloaderConfigurator.DEBUG) {
                System.err.println("FXClassLoader#createJREBundledClassloader - Assumed location (Java 8/Java 7): " + jarFile.getAbsolutePath());
            }
            if (!jarFile.exists()) ** GOTO lbl63
            if (!swtAvailable) break block30;
            if (FXClassloaderConfigurator.DEBUG) {
                System.err.println("FXClassLoader#createJREBundledClassloader - SWT is available use different loading strategy");
            }
            swtFX = new File(new File(javaHome.getAbsolutePath(), "lib"), "jfxswt.jar");
            if (FXClassloaderConfigurator.DEBUG) {
                System.err.println("FXClassLoader#createJREBundledClassloader - Searching for SWT-FX integration at " + swtFX.getAbsolutePath());
            }
            if (swtFX.exists()) {
                if (FXClassloaderConfigurator.DEBUG) {
                    System.err.println("FXClassLoader#createJREBundledClassloader - Found SWT/FX");
                }
                if ((extClassLoader = ClassLoader.getSystemClassLoader().getParent()).getClass().getName().equals("sun.misc.Launcher$ExtClassLoader")) {
                    if (FXClassloaderConfigurator.DEBUG) {
                        System.err.println("FXClassLoader#createJREBundledClassloader - Delegate to system classloader");
                    }
                    var7_13 = new URLClassLoader(new URL[]{swtFX.getCanonicalFile().toURI().toURL()}, (ClassLoader)new SWTFXClassloader(parent, extClassLoader));
                    if (FXClassloaderConfigurator.DEBUG == false) return var7_13;
                    System.err.println("FXClassLoader#createJREBundledClassloader - Ended");
                    return var7_13;
                }
                if (FXClassloaderConfigurator.DEBUG) {
                    System.err.println("FXClassLoader#createJREBundledClassloader - Using an URL classloader");
                }
                return new URLClassLoader(new URL[]{jarFile.getCanonicalFile().toURI().toURL(), swtFX.getCanonicalFile().toURI().toURL()}, parent);
            }
            if (FXClassloaderConfigurator.DEBUG) {
                System.err.println("FXClassLoader#createJREBundledClassloader - Assume that SWT-FX part of jfxrt.jar");
            }
            url = jarFile.getCanonicalFile().toURI().toURL();
            var7_15 = new URLClassLoader(new URL[]{url}, parent);
            if (FXClassloaderConfigurator.DEBUG == false) return var7_15;
            System.err.println("FXClassLoader#createJREBundledClassloader - Ended");
            return var7_15;
        }
        try {
            extClassLoader = ClassLoader.getSystemClassLoader().getParent();
            if (extClassLoader.getClass().getName().equals("sun.misc.Launcher$ExtClassLoader")) {
                if (FXClassloaderConfigurator.DEBUG) {
                    System.err.println("FXClassLoader#createJREBundledClassloader - Delegate to system classloader");
                }
                var7_16 = new URLClassLoader(new URL[0], extClassLoader);
                if (FXClassloaderConfigurator.DEBUG == false) return var7_16;
                System.err.println("FXClassLoader#createJREBundledClassloader - Ended");
                return var7_16;
            }
            ** GOTO lbl55
        }
        catch (Throwable t) {
            block31: {
                t.printStackTrace();
lbl55:
                // 2 sources

                if (FXClassloaderConfigurator.DEBUG) {
                    System.err.println("FXClassLoader#createJREBundledClassloader - Using an URL classloader");
                }
                url = jarFile.getCanonicalFile().toURI().toURL();
                var7_17 = cl = new URLClassLoader(new URL[]{url}, parent);
                if (FXClassloaderConfigurator.DEBUG == false) return var7_17;
                System.err.println("FXClassLoader#createJREBundledClassloader - Ended");
                return var7_17;
lbl63:
                // 2 sources

                jarFile = new File(new File(javaHome.getAbsolutePath(), "lib"), "jfxrt.jar");
                if (FXClassloaderConfigurator.DEBUG) {
                    System.err.println("FXClassLoader#createJREBundledClassloader - Assumed location (Java 7): " + jarFile.getAbsolutePath());
                }
                if (!jarFile.exists()) break block31;
                url = jarFile.getCanonicalFile().toURI().toURL();
                var7_18 = new URLClassLoader(new URL[]{url}, parent);
                if (FXClassloaderConfigurator.DEBUG == false) return var7_18;
                System.err.println("FXClassLoader#createJREBundledClassloader - Ended");
                return var7_18;
            }
            try {
                if (FXClassloaderConfigurator.DEBUG) {
                    System.err.println("FXClassLoader#createJREBundledClassloader - File does not exist.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        if (FXClassloaderConfigurator.DEBUG == false) return null;
        System.err.println("FXClassLoader#createJREBundledClassloader - Ended");
        return null;
    }

    static class EmptyEnumeration
    implements Enumeration<URL> {
        static Enumeration<URL> INSTANCE = new EmptyEnumeration();

        EmptyEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public URL nextElement() {
            return null;
        }
    }

    static class FXProviderBundle {
        final String module;
        final Path path;

        public FXProviderBundle(String module, Path path) {
            this.module = module;
            this.path = path;
        }

        public String toString() {
            return "FXProviderBundle [module=" + this.module + ", path=" + this.path + "]";
        }
    }

    static class SWTFXClassloader
    extends ClassLoader {
        private final ClassLoader lastResortLoader;
        private final ClassLoader primaryLoader;
        private Boolean checkFlag = null;

        public SWTFXClassloader(ClassLoader lastResortLoader, ClassLoader primaryLoader) {
            this.lastResortLoader = lastResortLoader;
            this.primaryLoader = primaryLoader;
            if (FXClassloaderConfigurator.DEBUG) {
                System.err.println("FXClassLoader.SWTFXClassloader#init - Primary Loader " + primaryLoader);
                System.err.println("FXClassLoader.SWTFXClassloader#init - Lastresort Loader " + lastResortLoader);
            }
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            if (name.startsWith("javafx.embed.swt")) {
                if (this.checkFlag == null) {
                    this.checkFlag = Boolean.TRUE;
                    if (FXClassLoader.isJDK8()) {
                        boolean supportsGtk3 = false;
                        String version = System.getProperty("java.version", "");
                        Matcher matcher = Pattern.compile(".+_(\\d+).*").matcher(version);
                        if (matcher.matches() && matcher.groupCount() > 0) {
                            boolean bl = supportsGtk3 = Integer.parseInt(matcher.group(1)) >= 202;
                        }
                        if (!supportsGtk3) {
                            Boolean isGTK3;
                            block28: {
                                isGTK3 = Boolean.FALSE;
                                try {
                                    String value;
                                    if (FXClassloaderConfigurator.DEBUG) {
                                        System.err.println("FXModuleClassloader#findLocalClass - Someone is trying to load FXCanvas. Need to check for GTK3");
                                    }
                                    if ("gtk".equals(value = (String)this.loadClass("org.eclipse.swt.SWT").getDeclaredMethod("getPlatform", new Class[0]).invoke(null, new Object[0]))) {
                                        if (FXClassloaderConfigurator.DEBUG) {
                                            System.err.println("FXModuleClassloader#findLocalClass - We are on GTK need to take a closer look");
                                        }
                                        try {
                                            isGTK3 = (Boolean)this.loadClass("org.eclipse.swt.internal.gtk.GTK").getDeclaredField("GTK3").get(null);
                                        }
                                        catch (Throwable t) {
                                            try {
                                                isGTK3 = (Boolean)this.loadClass("org.eclipse.swt.internal.gtk.OS").getDeclaredField("GTK3").get(null);
                                                break block28;
                                            }
                                            catch (Throwable e) {
                                                isGTK3 = Boolean.TRUE;
                                            }
                                        }
                                        break block28;
                                    }
                                    if (FXClassloaderConfigurator.DEBUG) {
                                        System.err.println("FXModuleClassloader#findLocalClass - OS is '" + value + "' no need to get upset all is fine");
                                    }
                                }
                                catch (Throwable e) {
                                    System.err.println("FXModuleClassloader#findLocalClass - Failed to check for Gtk3");
                                    e.printStackTrace();
                                }
                            }
                            if (isGTK3.booleanValue()) {
                                if (FXClassloaderConfigurator.DEBUG) {
                                    System.err.println("FXModuleClassloader#findLocalClass - We are on GTK3 - too bad need to disable JavaFX for now else we'll crash the JVM");
                                }
                                throw new ClassNotFoundException("SWT is running with GTK3 but JavaFX is linked against GTK2");
                            }
                        }
                    }
                    try {
                        this.loadClass("javafx.application.Platform").getDeclaredMethod("setImplicitExit", Boolean.TYPE).invoke(null, Boolean.FALSE);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                return super.findClass(name);
            }
            try {
                if (FXClassloaderConfigurator.DEBUG) {
                    System.err.println("FXClassLoader.SWTFXClassloader#findClass - Loading " + name + " with primary");
                }
                Class<?> loadClass = this.primaryLoader.loadClass(name);
                if (FXClassloaderConfigurator.DEBUG) {
                    System.err.println("FXClassLoader.SWTFXClassloader#findClass - Result " + name + " " + loadClass);
                }
                return loadClass;
            }
            catch (ClassNotFoundException c) {
                if (FXClassloaderConfigurator.DEBUG) {
                    System.err.println("FXClassLoader.SWTFXClassloader#findClass - ClassNotFoundException thrown");
                    System.err.println("FXClassLoader.SWTFXClassloader#findClass - Loading " + name + " with last resort");
                }
                try {
                    Class<?> loadClass = this.lastResortLoader.loadClass(name);
                    if (FXClassloaderConfigurator.DEBUG) {
                        System.err.println("FXClassLoader.SWTFXClassloader#findClass - Result " + name + " " + loadClass);
                    }
                    return loadClass;
                }
                catch (ClassNotFoundException tmp) {
                    if (FXClassloaderConfigurator.DEBUG) {
                        System.err.println("FXClassLoader.SWTFXClassloader#findClass - Even last resort was unable to load " + name);
                    }
                    throw c;
                }
            }
        }

        @Override
        protected URL findResource(String name) {
            URL url = this.primaryLoader.getResource(name);
            if (url == null) {
                url = this.lastResortLoader.getResource(name);
            }
            return url;
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            final Enumeration<URL> en1 = this.primaryLoader.getResources(name);
            final Enumeration<URL> en2 = this.lastResortLoader.getResources(name);
            return new Enumeration<URL>(){

                @Override
                public boolean hasMoreElements() {
                    if (en1.hasMoreElements()) {
                        return true;
                    }
                    return en2.hasMoreElements();
                }

                @Override
                public URL nextElement() {
                    if (!en1.hasMoreElements()) {
                        return (URL)en2.nextElement();
                    }
                    return (URL)en1.nextElement();
                }
            };
        }

        @Override
        public URL getResource(String name) {
            URL url = this.primaryLoader.getResource(name);
            if (url == null) {
                url = this.lastResortLoader.getResource(name);
            }
            return url;
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            InputStream in = this.primaryLoader.getResourceAsStream(name);
            if (in == null) {
                in = this.lastResortLoader.getResourceAsStream(name);
            }
            return in;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            final Enumeration<URL> en1 = this.primaryLoader.getResources(name);
            final Enumeration<URL> en2 = this.lastResortLoader.getResources(name);
            return new Enumeration<URL>(){

                @Override
                public boolean hasMoreElements() {
                    if (en1.hasMoreElements()) {
                        return true;
                    }
                    return en2.hasMoreElements();
                }

                @Override
                public URL nextElement() {
                    if (!en1.hasMoreElements()) {
                        return (URL)en2.nextElement();
                    }
                    return (URL)en1.nextElement();
                }
            };
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            try {
                return this.primaryLoader.loadClass(name);
            }
            catch (ClassNotFoundException c) {
                try {
                    return this.lastResortLoader.loadClass(name);
                }
                catch (ClassNotFoundException tmp) {
                    throw c;
                }
            }
        }
    }
}

