/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.data;

import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ElementHandler
extends DefaultHandler {
    protected final StringBuilder currentElementText;
    private ElementHandler currentHandler;
    private final String elementName;
    private final Map<String, ElementHandler> handlers;
    private final ElementHandler parent;

    public ElementHandler(ElementHandler parent, String elementName) {
        this.parent = parent;
        this.elementName = elementName;
        this.handlers = new HashMap<String, ElementHandler>();
        this.currentElementText = new StringBuilder();
    }

    public void addElementHandler(ElementHandler handler) {
        this.handlers.put(handler.getElementName(), handler);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentHandler != null) {
            this.currentHandler.characters(ch, start, length);
        } else {
            this.currentElementText.append(ch, start, length);
        }
    }

    protected void done(ElementHandler elementHandler) {
        this.currentHandler = null;
    }

    protected void end(String uri, String localName, String name) {
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.currentHandler != null) {
            this.currentHandler.endElement(uri, localName, name);
        } else if (this.elementName.equals(localName)) {
            this.end(uri, localName, name);
            if (this.parent != null) {
                this.parent.done(this);
            }
        }
    }

    protected void clearCurrentElementText() {
        this.currentElementText.setLength(0);
    }

    protected String getCurrentElementText() {
        return this.currentElementText.toString();
    }

    public String getElementName() {
        return this.elementName;
    }

    protected String getOptionalValue(Attributes attributes, String name) throws SAXException {
        String value = attributes.getValue(name);
        if (value == null) {
            return "";
        }
        return value;
    }

    public ElementHandler getParent() {
        return this.parent;
    }

    protected String getValue(Attributes attributes, String name) throws SAXException {
        String value = attributes.getValue(name);
        if (value == null) {
            throw new SAXException("Missing required attribute \"" + name + "\"");
        }
        return value;
    }

    public void removeElementHandler(ElementHandler handler) {
        this.handlers.remove(handler.getElementName());
    }

    protected void start(String uri, String localName, String name, Attributes attributes) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (this.currentHandler == null) {
            ElementHandler handler = this.handlers.get(name);
            if (handler != null) {
                this.currentHandler = handler;
                this.currentHandler.start(uri, localName, name, attributes);
            }
        } else {
            this.currentHandler.startElement(uri, localName, name, attributes);
        }
    }
}

