/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.view.ui.streams;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.terminal.connector.ISettingsStore;
import org.eclipse.terminal.connector.ITerminalConnector;
import org.eclipse.terminal.connector.InMemorySettingsStore;
import org.eclipse.terminal.connector.TerminalConnectorExtension;
import org.eclipse.terminal.view.core.ITerminalServiceOutputStreamMonitorListener;
import org.eclipse.terminal.view.ui.launcher.AbstractLauncherDelegate;
import org.eclipse.terminal.view.ui.launcher.IConfigurationPanel;
import org.eclipse.terminal.view.ui.launcher.IConfigurationPanelContainer;
import org.eclipse.terminal.view.ui.streams.StreamsSettings;

public class StreamsLauncherDelegate
extends AbstractLauncherDelegate {
    @Override
    public boolean needsUserConfiguration() {
        return false;
    }

    @Override
    public IConfigurationPanel getPanel(IConfigurationPanelContainer container) {
        return null;
    }

    @Override
    public CompletableFuture<?> execute(Map<String, Object> properties) {
        Assert.isNotNull(properties);
        try {
            return this.getTerminalService().openConsole(properties);
        }
        catch (RuntimeException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    @Override
    public ITerminalConnector createTerminalConnector(Map<String, Object> properties) throws CoreException {
        boolean bl;
        Assert.isNotNull(properties);
        String connectorId = (String)properties.get("tm.terminal.connector.id");
        if (connectorId == null) {
            connectorId = "org.eclipse.terminal.connector.streams.StreamsConnector";
        }
        OutputStream stdin = (OutputStream)properties.get("streams.stdin");
        InputStream stdout = (InputStream)properties.get("streams.stdout");
        InputStream stderr = (InputStream)properties.get("streams.stderr");
        Object value = properties.get("localEcho");
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            bl = b;
        } else {
            bl = false;
        }
        boolean localEcho = bl;
        String lineSeparator = (String)properties.get("lineSeparator");
        ITerminalServiceOutputStreamMonitorListener[] stdoutListeners = (ITerminalServiceOutputStreamMonitorListener[])properties.get("stdoutListeners");
        ITerminalServiceOutputStreamMonitorListener[] stderrListeners = (ITerminalServiceOutputStreamMonitorListener[])properties.get("stderrListeners");
        InMemorySettingsStore store = new InMemorySettingsStore();
        StreamsSettings streamsSettings = new StreamsSettings();
        streamsSettings.setStdinStream(stdin);
        streamsSettings.setStdoutStream(stdout);
        streamsSettings.setStderrStream(stderr);
        streamsSettings.setLocalEcho(localEcho);
        streamsSettings.setLineSeparator(lineSeparator);
        streamsSettings.setStdOutListeners(stdoutListeners);
        streamsSettings.setStdErrListeners(stderrListeners);
        streamsSettings.save((ISettingsStore)store);
        ITerminalConnector connector = TerminalConnectorExtension.makeTerminalConnector((String)connectorId);
        connector.setDefaultSettings();
        connector.load((ISettingsStore)store);
        return connector;
    }
}

