/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.preferences;

import java.util.List;
import org.eclipse.dltk.internal.ui.dialogs.StatusUtil;
import org.eclipse.dltk.ui.dialogs.StatusInfo;
import org.eclipse.dltk.ui.preferences.ControlBindingManager;
import org.eclipse.dltk.ui.preferences.IFieldValidator;
import org.eclipse.dltk.ui.preferences.IPreferenceConfigurationBlock;
import org.eclipse.dltk.ui.preferences.IPreferenceDelegate;
import org.eclipse.dltk.ui.preferences.ITextConverter;
import org.eclipse.dltk.ui.preferences.OverlayPreferenceStore;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public abstract class ImprovedAbstractConfigurationBlock
implements IPreferenceConfigurationBlock,
IPreferenceDelegate<String> {
    private PreferencePage page;
    private OverlayPreferenceStore store;
    private final ControlBindingManager<String> bindManager;

    public ImprovedAbstractConfigurationBlock(OverlayPreferenceStore store, PreferencePage page) {
        this.page = page;
        this.store = store;
        this.bindManager = new ControlBindingManager<String>(this, this.getStatusListener());
        this.addOverlayKeys();
    }

    @Override
    public void initialize() {
        this.initializeFields();
    }

    @Override
    public void performOk() {
    }

    @Override
    public void performDefaults() {
        this.initializeFields();
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean getBoolean(String key) {
        return this.store.getBoolean(key);
    }

    @Override
    public String getString(String key) {
        return this.store.getString(key);
    }

    @Override
    public void setBoolean(String key, boolean value) {
        this.store.setValue(key, value);
    }

    @Override
    public void setString(String key, String value) {
        this.store.setValue(key, value);
    }

    protected abstract List<OverlayPreferenceStore.OverlayKey> createOverlayKeys();

    protected void bindControl(Button button, String key, Object enable) {
        this.bindControl(button, key, enable, null);
    }

    protected void bindControl(Button button, String key, Object enable, Control[] dependencies) {
        this.bindManager.bindRadioControl(button, key, enable, dependencies);
    }

    protected void bindControl(Button button, String key, Control[] dependencies) {
        this.bindManager.bindControl(button, key, dependencies);
    }

    protected void bindControl(Button button, String key) {
        this.bindControl(button, key, null);
    }

    protected void bindControl(Text text, String key, IFieldValidator validator) {
        this.bindManager.bindControl(text, key, validator);
    }

    protected void bindControl(Text text, String key, IFieldValidator validator, ITextConverter transformer) {
        this.bindManager.bindControl(text, key, validator, transformer);
    }

    protected void bindControl(Text text, String key) {
        this.bindControl(text, key, null);
    }

    protected void bindControl(Text text, IFieldValidator validator) {
        this.bindManager.bindControl(text, null, validator);
    }

    protected void bindControl(Combo combo, String key) {
        this.bindManager.bindControl(combo, key);
    }

    protected void createDependency(Button master, Control[] slaves) {
        this.createDependency(master, slaves, null);
    }

    protected void createDependency(Button master, Control[] slaves, ControlBindingManager.DependencyMode mode) {
        this.bindManager.createDependency(master, slaves, mode);
    }

    protected void initializeFields() {
        this.bindManager.initialize();
    }

    protected IPreferenceStore getPreferenceStore() {
        return this.store;
    }

    protected PreferencePage getPreferencePage() {
        return this.page;
    }

    private IStatusChangeListener getStatusListener() {
        return status -> {
            if (status == null) {
                status = new StatusInfo();
            }
            this.page.setValid(status.getSeverity() != 4);
            StatusUtil.applyToStatusLine((DialogPage)this.page, status);
        };
    }

    private void addOverlayKeys() {
        List<OverlayPreferenceStore.OverlayKey> overlayKeys = this.createOverlayKeys();
        if (overlayKeys != null) {
            OverlayPreferenceStore.OverlayKey[] keys = overlayKeys.toArray(new OverlayPreferenceStore.OverlayKey[overlayKeys.size()]);
            this.store.addKeys(keys);
        }
    }
}

