/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.transport.httpclient;

import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.NTCredentials;
import org.apache.hc.client5.http.impl.auth.SystemDefaultCredentialsProvider;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.NTLMDomainUtil;

public class SystemCredentialsProvider
extends SystemDefaultCredentialsProvider {
    public Credentials getCredentials(AuthScope authscope, HttpContext context) {
        NTCredentials ntCredentials;
        Credentials credentials = super.getCredentials(authscope, context);
        if (credentials instanceof NTCredentials && ((ntCredentials = (NTCredentials)credentials).getDomain() == null || ntCredentials.getWorkstation() == null)) {
            String domain = ntCredentials.getDomain();
            String userName = ntCredentials.getUserName();
            String workstation = ntCredentials.getWorkstation();
            String strippedUserName = NTLMDomainUtil.getNTLMUserName(userName);
            if (!(domain != null && strippedUserName.equals(userName) || (domain = NTLMDomainUtil.getNTLMUserDomain(userName)) == null)) {
                userName = strippedUserName;
            }
            if (workstation == null) {
                workstation = NTLMDomainUtil.getNTLMWorkstation();
            }
            credentials = new NTCredentials(userName, ntCredentials.getPassword(), workstation, domain);
        }
        return credentials;
    }
}

