/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.internal.testing.Messages;
import org.eclipse.dltk.testing.DLTKTestingMessages;
import org.eclipse.dltk.ui.ModelElementLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class TestMethodSelectionDialog
extends ElementListSelectionDialog {
    private IModelElement fElement;

    public TestMethodSelectionDialog(Shell shell, IModelElement element) {
        super(shell, (ILabelProvider)new ModelElementLabelProvider(2050));
        this.fElement = element;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.dltk.testing.test_selection_context");
    }

    public int open() {
        Object[] elements;
        IType testType = null;
        if (testType == null) {
            return 1;
        }
        try {
            elements = this.searchTestMethods(this.fElement, testType);
        }
        catch (InterruptedException e) {
            return 1;
        }
        catch (InvocationTargetException e) {
            MessageDialog.openError((Shell)this.getParentShell(), (String)DLTKTestingMessages.TestMethodSelectionDialog_error_title, (String)e.getTargetException().getMessage());
            return 1;
        }
        if (elements.length == 0) {
            String msg = Messages.format(DLTKTestingMessages.TestMethodSelectionDialog_notfound_message, this.fElement.getElementName());
            MessageDialog.openInformation((Shell)this.getParentShell(), (String)DLTKTestingMessages.TestMethodSelectionDialog_no_tests_title, (String)msg);
            return 1;
        }
        this.setElements(elements);
        return super.open();
    }

    public Object[] searchTestMethods(final IModelElement element, final IType testType) throws InvocationTargetException, InterruptedException {
        final TestReferenceCollector[] col = new TestReferenceCollector[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException {
                try {
                    col[0] = TestMethodSelectionDialog.this.doSearchTestMethods(element, testType, pm);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
        return col[0].getResult();
    }

    private TestReferenceCollector doSearchTestMethods(IModelElement element, IType testType, IProgressMonitor pm) throws CoreException {
        int matchRule = 24;
        SearchPattern pattern = SearchPattern.createPattern((IModelElement)element, (int)1, (int)matchRule, (IDLTKLanguageToolkit)DLTKLanguageManager.getLanguageToolkit((IModelElement)testType));
        SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        IDLTKSearchScope scope = SearchEngine.createHierarchyScope((IType)testType);
        TestReferenceCollector requestor = new TestReferenceCollector();
        new SearchEngine().search(pattern, participants, scope, (SearchRequestor)requestor, pm);
        return requestor;
    }

    public static class TestReferenceCollector
    extends SearchRequestor {
        Set fResult = new HashSet(200);

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            IModelElement enclosingElement = (IModelElement)match.getElement();
            if (enclosingElement.getElementName().startsWith("test")) {
                this.fResult.add(enclosingElement);
            }
        }

        public Object[] getResult() {
            return this.fResult.toArray();
        }
    }
}

