import { Language } from '@vue/language-core';
import type * as ts from 'typescript';
export type RequestType = 'containsFile' | 'projectInfo' | 'collectExtractProps' | 'getImportPathForFile' | 'getPropertiesAtLocation' | 'getQuickInfoAtPosition' | 'subscribeComponentProps' | 'getComponentEvents' | 'getTemplateContextProps' | 'getElementAttrs';
export type NotificationType = 'componentNamesUpdated' | 'componentPropsUpdated';
export type RequestData = [
    seq: number,
    type: RequestType,
    fileName: string,
    ...args: any[]
];
export type ResponseData = [
    seq: number,
    data: any
];
export type NotificationData = [
    type: NotificationType,
    fileName: string,
    data: any
];
export interface ProjectInfo {
    name: string;
    kind: ts.server.ProjectKind;
    currentDirectory: string;
}
export declare function startNamedPipeServer(ts: typeof import('typescript'), info: ts.server.PluginCreateInfo, language: Language<string>, projectKind: ts.server.ProjectKind.Inferred | ts.server.ProjectKind.Configured): Promise<void>;
