/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.internal.util.emf.workbench.nls.EMFWorkbenchResourceHandler;
import org.eclipse.jem.util.UIContextDetermination;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.IEditModelHandler;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;
import org.eclipse.wst.common.componentcore.internal.BinaryComponentHelper;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.internal.operations.IOperationHandler;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModel;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelListener;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.IValidateEditContext;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class ArtifactEdit
implements IEditModelHandler,
IAdaptable {
    public static final Class ADAPTER_TYPE = ArtifactEdit.class;
    private final ArtifactEditModel artifactEditModel;
    private boolean isReadOnly;
    private boolean isArtifactEditModelSelfManaged;
    private boolean isBinary;
    private BinaryComponentHelper binaryComponentHelper;
    private final IProject project;
    private boolean validArtifactEdit = true;

    protected ArtifactEdit() {
        this.artifactEditModel = null;
        this.project = null;
    }

    public static ArtifactEdit getArtifactEditForRead(IVirtualComponent aModule) {
        if (aModule.isBinary()) {
            return new ArtifactEdit(aModule);
        }
        if (ArtifactEdit.isValidEditableModule(aModule)) {
            IProject project = aModule.getProject();
            ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature(project);
            return new ArtifactEdit(nature, aModule, true);
        }
        return null;
    }

    public static ArtifactEdit getArtifactEditForWrite(IVirtualComponent aModule) {
        if (!aModule.isBinary() && ArtifactEdit.isValidEditableModule(aModule)) {
            IProject project = aModule.getProject();
            ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature(project);
            return new ArtifactEdit(nature, aModule, false);
        }
        return null;
    }

    public static ArtifactEdit getArtifactEditForRead(IProject aProject) {
        ArtifactEdit artifactEdit = null;
        try {
            artifactEdit = new ArtifactEdit(aProject, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            artifactEdit = null;
        }
        return artifactEdit;
    }

    public static ArtifactEdit getArtifactEditForWrite(IProject aProject) {
        ArtifactEdit artifactEdit = null;
        try {
            artifactEdit = new ArtifactEdit(aProject, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            artifactEdit = null;
        }
        return artifactEdit;
    }

    public static boolean isValidEditableModule(IVirtualComponent aModule) {
        if (aModule == null) {
            return false;
        }
        if (ModuleURIUtil.fullyQualifyURI(aModule.getProject()) == null) {
            return false;
        }
        IProject project = aModule.getProject();
        return project != null && project.isAccessible();
    }

    public ArtifactEdit(ArtifactEditModel anArtifactEditModel) {
        this.artifactEditModel = anArtifactEditModel;
        this.isReadOnly = this.artifactEditModel.isReadOnly();
        this.isArtifactEditModelSelfManaged = false;
        this.project = anArtifactEditModel.getProject();
    }

    protected ArtifactEdit(IVirtualComponent aBinaryModule) {
        if (!aBinaryModule.isBinary()) {
            throw new RuntimeException("This constructor is only for binary components.");
        }
        this.binaryComponentHelper = this.initBinaryComponentHelper(aBinaryModule);
        this.artifactEditModel = null;
        this.isReadOnly = true;
        this.isBinary = true;
        this.isArtifactEditModelSelfManaged = true;
        this.project = null;
    }

    protected BinaryComponentHelper initBinaryComponentHelper(IVirtualComponent binaryModule) {
        return null;
    }

    protected ArtifactEdit(ModuleCoreNature aNature, IVirtualComponent aModule, boolean toAccessAsReadOnly) {
        this.isReadOnly = toAccessAsReadOnly;
        this.isArtifactEditModelSelfManaged = true;
        this.project = aNature.getProject();
        IProject aProject = aModule.getProject();
        URI componentURI = ModuleURIUtil.fullyQualifyURI(aProject);
        HashMap<String, Object> editModelParams = null;
        if (this.getContentTypeDescriber() != null) {
            editModelParams = new HashMap<String, Object>();
            editModelParams.put("ROOT_URI", this.getRootURI());
            editModelParams.put("ROOT_CONTENT_TYPE", this.getContentTypeDescriber());
        }
        this.artifactEditModel = toAccessAsReadOnly ? aNature.getArtifactEditModelForRead(componentURI, this, null, editModelParams) : aNature.getArtifactEditModelForWrite(componentURI, this, null, editModelParams);
    }

    public ArtifactEdit(IProject aProject, boolean toAccessAsReadOnly) throws IllegalArgumentException {
        this(aProject, toAccessAsReadOnly, false, null);
    }

    protected ArtifactEdit(IProject aProject, boolean toAccessAsReadOnly, boolean forCreate, String projectType) throws IllegalArgumentException {
        this(aProject, toAccessAsReadOnly, forCreate, projectType, null);
    }

    protected void verifyOperationSupported() {
        if (!this.validArtifactEdit) {
            throw new RuntimeException("Invalid Artifact Edit access (model version not supported)");
        }
    }

    public boolean isValid() {
        return this.validArtifactEdit;
    }

    protected void markInvalid() {
        Logger.global.log(Level.WARNING, "Invalid Artifact Edit access (model version not supported)");
        this.validArtifactEdit = false;
    }

    protected ArtifactEdit(IProject aProject, boolean toAccessAsReadOnly, boolean forCreate, String projectType, Map editModelParams) throws IllegalArgumentException {
        IVirtualComponent component;
        if (aProject == null || !aProject.isAccessible()) {
            throw new IllegalArgumentException("Invalid project: " + String.valueOf(aProject));
        }
        ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature(aProject);
        if (nature == null) {
            throw new IllegalArgumentException("Project does not have ModuleCoreNature: " + String.valueOf(aProject));
        }
        if (!this.validProjectVersion(aProject)) {
            this.markInvalid();
        }
        if ((component = ComponentCore.createComponent(aProject)) == null) {
            throw new IllegalArgumentException("Invalid component handle: " + String.valueOf(aProject));
        }
        if (!forCreate && !ArtifactEdit.isValidEditableModule(component)) {
            throw new IllegalArgumentException("Invalid component handle: " + String.valueOf(aProject));
        }
        this.project = aProject;
        URI componentURI = ModuleURIUtil.fullyQualifyURI(aProject);
        if (this.getContentTypeDescriber() != null) {
            if (editModelParams == null) {
                editModelParams = new HashMap<String, URI>();
            }
            editModelParams.put("ROOT_URI", this.getRootURI());
            editModelParams.put("ROOT_CONTENT_TYPE", (URI)this.getContentTypeDescriber());
        }
        this.artifactEditModel = toAccessAsReadOnly ? nature.getArtifactEditModelForRead(componentURI, this, projectType, editModelParams) : nature.getArtifactEditModelForWrite(componentURI, this, projectType, editModelParams);
        this.isReadOnly = toAccessAsReadOnly;
        this.isArtifactEditModelSelfManaged = true;
    }

    public boolean isProjectOfType(IProject project, String typeID) {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {
            return false;
        }
        if (facetedProject != null && ProjectFacetsManager.isProjectFacetDefined((String)typeID)) {
            IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)typeID);
            return projectFacet != null && facetedProject.hasProjectFacet(projectFacet);
        }
        return false;
    }

    protected String getContentTypeDescriber() {
        if (this.isProjectOfType(this.project, "jst.ejb")) {
            return "org.eclipse.jst.j2ee.ejbDD";
        }
        if (this.isProjectOfType(this.project, "jst.web")) {
            return "org.eclipse.jst.j2ee.webDD";
        }
        if (this.isProjectOfType(this.project, "jst.ear")) {
            return "org.eclipse.jst.j2ee.earDD";
        }
        if (this.isProjectOfType(this.project, "jst.appclient")) {
            return "org.eclipse.jst.j2ee.appclientDD";
        }
        return null;
    }

    protected URI getRootURI() {
        if (this.isProjectOfType(this.project, "jst.ejb")) {
            return URI.createURI((String)"META-INF/ejb-jar.xml");
        }
        if (this.isProjectOfType(this.project, "jst.web")) {
            return URI.createURI((String)"WEB-INF/web.xml");
        }
        if (this.isProjectOfType(this.project, "jst.ear")) {
            return URI.createURI((String)"META-INF/application.xml");
        }
        if (this.isProjectOfType(this.project, "jst.appclient")) {
            return URI.createURI((String)"META-INF/application-client.xml");
        }
        return null;
    }

    protected boolean validProjectVersion(IProject project2) {
        return true;
    }

    @Override
    public void save(IProgressMonitor aMonitor) {
        if (this.isReadOnly()) {
            this.throwAttemptedReadOnlyModification();
        } else if (this.validateEdit().isOK()) {
            this.artifactEditModel.save(aMonitor, this);
        }
    }

    @Override
    public void saveIfNecessary(IProgressMonitor aMonitor) {
        if (this.isReadOnly()) {
            this.throwAttemptedReadOnlyModification();
        } else if (this.artifactEditModel.isDirty() && this.validateEdit().isOK()) {
            this.artifactEditModel.saveIfNecessary(aMonitor, this);
        }
    }

    public IStatus validateEdit() {
        IValidateEditContext validator = (IValidateEditContext)UIContextDetermination.createInstance((String)"ValidateEditContext");
        return validator.validateState((EditModel)this.getArtifactEditModel());
    }

    public void saveIfNecessaryWithPrompt(IProgressMonitor monitor, IOperationHandler operationHandler, boolean wasDirty) {
        if (this.shouldSave(operationHandler, wasDirty)) {
            this.saveIfNecessary(monitor);
        } else {
            this.handleSaveIfNecessaryDidNotSave(monitor);
        }
    }

    private void handleSaveIfNecessaryDidNotSave(IProgressMonitor monitor) {
    }

    private boolean shouldSave(IOperationHandler operationHandler, boolean wasDirty) {
        return !wasDirty ? this.shouldSave() : this.shouldSave(operationHandler);
    }

    private boolean promptToSave(IOperationHandler operationHandler) {
        if (operationHandler == null) {
            return false;
        }
        return operationHandler.canContinue(EMFWorkbenchResourceHandler.getString((String)"The_following_resources_ne_UI_"), this.getArtifactEditModel().getResourceURIs(true));
    }

    private boolean shouldSave(IOperationHandler operationHandler) {
        return this.shouldSave() || this.promptToSave(operationHandler);
    }

    private boolean shouldSave() {
        return !this.isReadOnly() && this.isArtifactEditModelSelfManaged;
    }

    @Override
    public void dispose() {
        if (this.isBinary()) {
            this.binaryComponentHelper.dispose();
        } else if (this.isArtifactEditModelSelfManaged && this.artifactEditModel != null) {
            this.artifactEditModel.releaseAccess(this);
        }
    }

    public EObject getContentModelRoot() {
        if (this.isBinary()) {
            return this.binaryComponentHelper.getPrimaryRootObject();
        }
        if (this.artifactEditModel != null) {
            return this.artifactEditModel.getPrimaryRootObject();
        }
        return null;
    }

    public void addListener(EditModelListener listener) {
        if (!this.isBinary() && this.artifactEditModel != null && listener != null) {
            this.artifactEditModel.addListener(listener);
        }
    }

    public void removeListener(EditModelListener listener) {
        if (!this.isBinary() && this.artifactEditModel != null && !this.artifactEditModel.isDisposed()) {
            this.artifactEditModel.removeListener(listener);
        }
    }

    public boolean hasEditModel(EditModel editModel) {
        if (this.isBinary()) {
            return false;
        }
        return this.artifactEditModel == editModel;
    }

    public IProject getProject() {
        if (this.isBinary()) {
            return null;
        }
        return this.project;
    }

    public IVirtualComponent getComponent() {
        if (this.isBinary()) {
            return this.binaryComponentHelper.getComponent();
        }
        return this.getArtifactEditModel().getVirtualComponent();
    }

    protected ArtifactEditModel getArtifactEditModel() {
        if (this.isBinary()) {
            this.throwAttemptedBinaryEditModelAccess();
        }
        return this.artifactEditModel;
    }

    protected BinaryComponentHelper getBinaryComponentHelper() {
        return this.binaryComponentHelper;
    }

    public CommandStack getCommandStack() {
        if (this.isBinary()) {
            return new BasicCommandStack();
        }
        return this.artifactEditModel.getCommandStack();
    }

    public void deleteResource(Resource aResource) {
        if (this.isBinary()) {
            this.throwAttemptedBinaryEditModelAccess();
        }
        this.artifactEditModel.deleteResource(aResource);
    }

    public boolean isDirty() {
        if (this.isBinary()) {
            return false;
        }
        return this.artifactEditModel.isDirty();
    }

    private void throwAttemptedReadOnlyModification() {
        throw new IllegalStateException("Attempt to modify an ArtifactEdit instance facade that was loaded as read-only.");
    }

    protected void throwAttemptedBinaryEditModelAccess() {
        throw new IllegalStateException("Attempt to modify an ArtifactEdit instance facade that was loaded as binary.");
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean isBinary() {
        return this.isBinary;
    }

    public void forceLoadKnownResources() {
        if (!this.isBinary()) {
            List uris = this.getArtifactEditModel().getKnownResourceUris();
            URI uri = null;
            int i = 0;
            while (i < uris.size()) {
                uri = (URI)uris.get(i);
                this.getArtifactEditModel().getResource(uri);
                ++i;
            }
        }
    }

    public Resource getResource(URI aUri) {
        if (this.isBinary()) {
            return this.binaryComponentHelper.getResource(aUri);
        }
        return this.getArtifactEditModel().getResource(aUri);
    }

    public Object getAdapter(Class adapterType) {
        if (adapterType == ArtifactEditModel.class) {
            return this.getArtifactEditModel();
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public void commandStackChanged(EventObject event) {
        this.getArtifactEditModel().commandStackChanged(event);
    }
}

