/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.communication;

import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.debug.daemon.communication.ICommunicationDaemon;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugUtil;
import org.eclipse.php.internal.debug.core.daemon.AbstractDebuggerCommunicationDaemon;
import org.eclipse.php.internal.debug.core.debugger.DebuggerSettingsManager;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerSettings;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerSettingsListener;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.zend.communication.DebugConnection;

public class DebuggerCommunicationDaemon
implements ICommunicationDaemon {
    public static final String ZEND_DEBUGGER_ID = "org.eclipse.php.debug.core.zendDebugger";
    private List<AbstractDebuggerCommunicationDaemon> daemons = new ArrayList<AbstractDebuggerCommunicationDaemon>();
    private IEclipsePreferences.IPreferenceChangeListener defaultPortListener = null;
    private IDebuggerSettingsListener debuggerSettingsListener = null;
    private IEclipsePreferences.IPreferenceChangeListener sslChangeListener;
    private static boolean useSSL;

    public static AbstractDebuggerCommunicationDaemon createDaemon(int port) {
        return new CommunicationDaemon(port);
    }

    public synchronized boolean isUsingSSL() {
        return useSSL;
    }

    public synchronized void setUseSSL(boolean enable) {
        if (enable == this.isUsingSSL()) {
            return;
        }
        useSSL = enable;
        this.resetSocket();
    }

    public void init() {
        useSSL = InstanceScope.INSTANCE.getNode("org.eclipse.php.debug.core").getBoolean("zend_debug_use_ssl_encryption", false);
        this.registerListeners();
        this.reset();
    }

    public boolean isListening(int port) {
        for (ICommunicationDaemon iCommunicationDaemon : this.daemons) {
            if (!iCommunicationDaemon.isListening(port)) continue;
            return true;
        }
        return false;
    }

    public void startListen() {
        for (ICommunicationDaemon iCommunicationDaemon : this.daemons) {
            iCommunicationDaemon.startListen();
        }
    }

    public void stopListen() {
        this.unregisterListeners();
        for (ICommunicationDaemon iCommunicationDaemon : this.daemons) {
            iCommunicationDaemon.stopListen();
        }
    }

    public boolean resetSocket() {
        boolean allReset = true;
        for (ICommunicationDaemon iCommunicationDaemon : this.daemons) {
            if (iCommunicationDaemon.resetSocket()) continue;
            allReset = false;
        }
        return allReset;
    }

    public void handleMultipleBindingError() {
    }

    public boolean isEnabled() {
        return true;
    }

    public String getDebuggerID() {
        return ZEND_DEBUGGER_ID;
    }

    public boolean isDebuggerDaemon() {
        return true;
    }

    public boolean isInitialized() {
        for (ICommunicationDaemon iCommunicationDaemon : this.daemons) {
            if (iCommunicationDaemon.isInitialized()) continue;
            return false;
        }
        return true;
    }

    private void registerListeners() {
        if (this.defaultPortListener == null) {
            this.defaultPortListener = new DefaultPortListener();
            InstanceScope.INSTANCE.getNode("org.eclipse.php.debug.core").addPreferenceChangeListener(this.defaultPortListener);
        }
        if (this.debuggerSettingsListener == null) {
            this.debuggerSettingsListener = new DebuggerSettingsListener();
            DebuggerSettingsManager.INSTANCE.addSettingsListener(this.debuggerSettingsListener);
        }
        if (this.sslChangeListener == null) {
            this.sslChangeListener = new SSLChangeListener();
            InstanceScope.INSTANCE.getNode("org.eclipse.php.debug.core").addPreferenceChangeListener(this.sslChangeListener);
        }
    }

    private void unregisterListeners() {
        if (this.defaultPortListener != null) {
            InstanceScope.INSTANCE.getNode("org.eclipse.php.debug.core").removePreferenceChangeListener(this.defaultPortListener);
        }
        if (this.debuggerSettingsListener != null) {
            DebuggerSettingsManager.INSTANCE.removeSettingsListener(this.debuggerSettingsListener);
        }
        if (this.sslChangeListener != null) {
            InstanceScope.INSTANCE.getNode("org.eclipse.php.debug.core").removePreferenceChangeListener(this.sslChangeListener);
        }
    }

    private synchronized void reset() {
        Set<Integer> ports = PHPDebugUtil.getDebugPorts(this.getDebuggerID());
        ArrayList<AbstractDebuggerCommunicationDaemon> daemonsToRemove = new ArrayList<AbstractDebuggerCommunicationDaemon>();
        for (AbstractDebuggerCommunicationDaemon daemon : this.daemons) {
            boolean isRedundant = true;
            Iterator<Object> iterator = ports.iterator();
            while (iterator.hasNext()) {
                int port = iterator.next();
                if (daemon.getReceiverPort() != port) continue;
                isRedundant = false;
                break;
            }
            if (!isRedundant) continue;
            daemon.stopListen();
            daemonsToRemove.add(daemon);
        }
        this.daemons.removeAll(daemonsToRemove);
        Iterator<Object> iterator = ports.iterator();
        while (iterator.hasNext()) {
            int port = (Integer)iterator.next();
            boolean isRunning = false;
            for (AbstractDebuggerCommunicationDaemon daemon : this.daemons) {
                if (daemon.getReceiverPort() != port) continue;
                isRunning = true;
                break;
            }
            if (isRunning) continue;
            CommunicationDaemon newDaemon = new CommunicationDaemon(port);
            this.daemons.add(newDaemon);
        }
    }

    private static class CommunicationDaemon
    extends AbstractDebuggerCommunicationDaemon {
        private int port;

        public CommunicationDaemon(int port) {
            this.port = port;
            this.init();
        }

        @Override
        public int getReceiverPort() {
            return this.port;
        }

        @Override
        public String getDebuggerID() {
            return DebuggerCommunicationDaemon.ZEND_DEBUGGER_ID;
        }

        public boolean isDebuggerDaemon() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean resetSocket() {
            this.stopListen();
            int port = this.getReceiverPort();
            try {
                Object object = this.lock;
                synchronized (object) {
                    if (useSSL) {
                        SSLServerSocket sslServerSocket = (SSLServerSocket)SSLServerSocketFactory.getDefault().createServerSocket(port);
                        sslServerSocket.setEnabledCipherSuites(sslServerSocket.getSupportedCipherSuites());
                        this.serverSocket = sslServerSocket;
                    } else {
                        this.serverSocket = new ServerSocket(port);
                    }
                    this.startListen();
                    return true;
                }
            }
            catch (BindException exc) {
                this.handleMultipleBindingError();
                return false;
            }
            catch (IOException e) {
                Logger.logException(e);
            }
            return false;
        }

        @Override
        protected synchronized void startConnection(Socket socket) {
            new DebugConnection(socket);
        }
    }

    private class DebuggerSettingsListener
    implements IDebuggerSettingsListener {
        private DebuggerSettingsListener() {
        }

        @Override
        public void settingsAdded(IDebuggerSettings settings) {
            if (DebuggerCommunicationDaemon.this.getDebuggerID().equals(settings.getDebuggerId())) {
                DebuggerCommunicationDaemon.this.reset();
            }
        }

        @Override
        public void settingsRemoved(IDebuggerSettings settings) {
            if (DebuggerCommunicationDaemon.this.getDebuggerID().equals(settings.getDebuggerId())) {
                DebuggerCommunicationDaemon.this.reset();
            }
        }

        @Override
        public void settingsChanged(PropertyChangeEvent[] events) {
            PropertyChangeEvent[] propertyChangeEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyChangeEvent event = propertyChangeEventArray[n2];
                IDebuggerSettings settings = (IDebuggerSettings)event.getSource();
                if (DebuggerCommunicationDaemon.this.getDebuggerID().equals(settings.getDebuggerId()) && event.getProperty().equals("clientPort")) {
                    DebuggerCommunicationDaemon.this.reset();
                }
                ++n2;
            }
        }
    }

    private class DefaultPortListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private DefaultPortListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (event.getKey().equals(PHPDebugCorePreferenceNames.ZEND_DEBUG_PORT)) {
                DebuggerCommunicationDaemon.this.reset();
            }
        }
    }

    private class SSLChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private SSLChangeListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (event.getKey().equals("zend_debug_use_ssl_encryption")) {
                Object newValueObj = event.getNewValue();
                if (newValueObj != null) {
                    if (newValueObj instanceof String) {
                        DebuggerCommunicationDaemon.this.setUseSSL(Boolean.valueOf((String)newValueObj));
                    } else if (newValueObj instanceof Boolean) {
                        DebuggerCommunicationDaemon.this.setUseSSL((Boolean)newValueObj);
                    }
                }
                if (newValueObj == null) {
                    DebuggerCommunicationDaemon.this.setUseSSL(false);
                }
            }
        }
    }
}

