/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.eval;

import org.eclipse.debug.core.DebugException;
import org.eclipse.dltk.debug.core.eval.IScriptEvaluationResult;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.debug.core.model.IScriptValue;

public class FailedScriptEvaluationResult
implements IScriptEvaluationResult {
    private final IScriptThread thread;
    private final String snippet;
    private DebugException exception;
    private String[] messages;

    public FailedScriptEvaluationResult(IScriptThread thread, String snippet, DebugException exception) {
        this.thread = thread;
        this.snippet = snippet;
        this.exception = exception;
    }

    public FailedScriptEvaluationResult(IScriptThread thread, String snippet, String[] messages) {
        this.thread = thread;
        this.snippet = snippet;
        this.messages = messages;
    }

    public FailedScriptEvaluationResult(IScriptThread thread, String snippet, DebugException exception, String[] messages) {
        this.thread = thread;
        this.snippet = snippet;
        this.exception = exception;
        this.messages = messages;
    }

    @Override
    public boolean hasErrors() {
        return true;
    }

    @Override
    public String[] getErrorMessages() {
        if (this.messages != null) {
            return this.messages;
        }
        if (this.exception != null) {
            return new String[]{this.exception.getMessage()};
        }
        return new String[0];
    }

    @Override
    public DebugException getException() {
        return this.exception;
    }

    @Override
    public String getSnippet() {
        return this.snippet;
    }

    @Override
    public IScriptThread getThread() {
        return this.thread;
    }

    @Override
    public IScriptValue getValue() {
        return null;
    }
}

