/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.view.ui.tabs;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm.internal.terminal.control.ITerminalMouseListener2;
import org.eclipse.tm.internal.terminal.control.ITerminalViewControl;
import org.eclipse.tm.terminal.model.ITerminalTextDataReadOnly;
import org.eclipse.tm.terminal.view.ui.activator.UIPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.dialogs.OpenResourceDialog;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.osgi.framework.Bundle;

public class OpenFileMouseHandler
implements ITerminalMouseListener2 {
    private static final boolean DEBUG_HOVER = UIPlugin.isOptionEnabled("org.eclipse.tm.terminal.control/debug/log/hover");
    private static final List<String> NEEDED_BUNDLES = List.of("org.eclipse.core.resources", "org.eclipse.ui.ide", "org.eclipse.ui.editors", "org.eclipse.text");
    private final ITerminalViewControl terminal;
    private Pattern regex = Pattern.compile("(\\d*)(:(\\d*))?.*");
    private IWorkbenchPartSite site;
    private boolean neededBundlesAvailable;

    OpenFileMouseHandler(IWorkbenchPartSite site, ITerminalViewControl terminal) {
        this.site = site;
        this.terminal = terminal;
        this.neededBundlesAvailable = true;
        for (String bundleName : NEEDED_BUNDLES) {
            if (this.bundleAvailable(bundleName)) continue;
            this.neededBundlesAvailable = false;
            if (!DEBUG_HOVER) continue;
            System.out.format("hover: the %s bundle is not present, therefore full ctrl-click functionality is not available\n", bundleName);
        }
        if (this.neededBundlesAvailable && DEBUG_HOVER) {
            System.out.format("hover: the bundles needed for full ctrl-click functionality are available\n", new Object[0]);
        }
    }

    public void mouseUp(ITerminalTextDataReadOnly terminalText, int line, int column, int button, int stateMask) {
        block24: {
            if ((stateMask & SWT.MODIFIER_MASK) != SWT.MOD1) {
                return;
            }
            String textToOpen = this.terminal.getHoverSelection();
            String lineAndCol = null;
            if (textToOpen.length() > 0) {
                try {
                    IFile fileForLocation;
                    Optional workingDirectory;
                    int startOfRowCol;
                    if (textToOpen.startsWith("http://") || textToOpen.startsWith("https://")) {
                        try {
                            PlatformUI.getWorkbench().getBrowserSupport().createBrowser(null).openURL(new URL(textToOpen));
                            return;
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                    }
                    if (!this.neededBundlesAvailable) {
                        return;
                    }
                    if (textToOpen.startsWith("file://")) {
                        textToOpen = textToOpen.substring(7);
                    }
                    if ((startOfRowCol = textToOpen.indexOf(58)) == 1 && textToOpen.length() > 2) {
                        startOfRowCol = textToOpen.indexOf(58, startOfRowCol + 1);
                    }
                    if (startOfRowCol >= 0) {
                        lineAndCol = textToOpen.substring(startOfRowCol + 1);
                        textToOpen = textToOpen.substring(0, startOfRowCol);
                    }
                    Optional<Object> fullPath = Optional.empty();
                    if (!textToOpen.startsWith("/") && (workingDirectory = this.terminal.getTerminalConnector().getWorkingDirectory()).isPresent()) {
                        fullPath = Optional.of((String)workingDirectory.get() + "/" + textToOpen);
                    }
                    if ((fileForLocation = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fullPath.orElse(textToOpen)))) != null && fileForLocation.exists()) {
                        IEditorPart editor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)fileForLocation, (boolean)true);
                        this.goToLine(lineAndCol, editor);
                        return;
                    }
                    File file = new File(fullPath.orElse(textToOpen));
                    if (file.exists() && !file.isDirectory()) {
                        try {
                            IEditorPart editor = IDE.openEditor((IWorkbenchPage)this.site.getPage(), (URI)file.toURI(), (String)IDE.getEditorDescriptor((String)file.getName(), (boolean)true, (boolean)true).getId(), (boolean)true);
                            this.goToLine(lineAndCol, editor);
                            return;
                        }
                        catch (Exception editor) {
                            // empty catch block
                        }
                    }
                    Shell shell = this.site.getShell();
                    ResourcesPlugin.getPlugin();
                    OpenResourceDialog openResourceDialog = new OpenResourceDialog(shell, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
                    openResourceDialog.setInitialPattern(textToOpen);
                    if (openResourceDialog.open() != 0) {
                        return;
                    }
                    Object[] results = openResourceDialog.getResult();
                    ArrayList<IFile> files = new ArrayList<IFile>();
                    Object[] objectArray = results;
                    int n = results.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object result = objectArray[n2];
                        if (result instanceof IFile) {
                            files.add((IFile)result);
                        }
                        ++n2;
                    }
                    if (files.size() <= 0) break block24;
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window == null) {
                        throw new ExecutionException("no active workbench window");
                    }
                    IWorkbenchPage page = window.getActivePage();
                    if (page == null) {
                        throw new ExecutionException("no active workbench page");
                    }
                    try {
                        for (IFile iFile : files) {
                            IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IFile)iFile, (boolean)true);
                            this.goToLine(lineAndCol, editor);
                        }
                    }
                    catch (PartInitException e) {
                        throw new ExecutionException("error opening file in editor", (Throwable)e);
                    }
                }
                catch (IllegalArgumentException | NullPointerException | ExecutionException | PartInitException e) {
                    UIPlugin.log("Failed to activate OpenResourceDialog", e);
                }
            }
        }
    }

    private boolean bundleAvailable(String symbolicName) {
        Bundle bundle = Platform.getBundle((String)symbolicName);
        boolean available = bundle != null && bundle.getState() != 1 && bundle.getState() != 16;
        return available;
    }

    private void goToLine(String lineAndCol, IEditorPart editor) {
        ITextEditor textEditor = (ITextEditor)Adapters.adapt((Object)editor, ITextEditor.class);
        if (textEditor != null) {
            Optional<Integer> optionalOffset = this.getRegionFromLineAndCol(textEditor, lineAndCol);
            optionalOffset.ifPresent(offset -> textEditor.selectAndReveal(offset.intValue(), 0));
        }
    }

    private Optional<Integer> getRegionFromLineAndCol(ITextEditor editor, String lineAndCol) {
        int line;
        if (lineAndCol == null) {
            return Optional.empty();
        }
        Matcher matcher = this.regex.matcher(lineAndCol);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        String lineStr = matcher.group(1);
        String colStr = matcher.group(3);
        int col = 0;
        try {
            line = Integer.parseInt(lineStr);
        }
        catch (NumberFormatException e1) {
            return Optional.empty();
        }
        try {
            col = Integer.parseInt(colStr);
        }
        catch (NumberFormatException e1) {
            // empty catch block
        }
        IDocumentProvider provider = editor.getDocumentProvider();
        IEditorInput input = editor.getEditorInput();
        try {
            provider.connect((Object)input);
        }
        catch (CoreException e) {
            return null;
        }
        try {
            IDocument document = provider.getDocument((Object)input);
            if (document != null && line > 0) {
                int lineLength;
                int lineOffset = document.getLineOffset(--line);
                if (col > 0 && col < (lineLength = document.getLineLength(line))) {
                    lineOffset += col;
                }
                Optional<Integer> optional = Optional.of(lineOffset);
                return optional;
            }
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            provider.disconnect((Object)input);
        }
        return Optional.empty();
    }
}

