/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.strategies.SimpleProposal;
import org.eclipse.php.internal.core.codeassist.strategies.TypesStrategy;

public class PropertyTypeStrategy
extends TypesStrategy {
    private static final List<SimpleProposal> TYPES = new ArrayList<SimpleProposal>(Arrays.asList(SimpleProposal.BASIC_TYPES));

    public PropertyTypeStrategy(ICompletionContext context) {
        super(context);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        AbstractCompletionContext context = (AbstractCompletionContext)this.getContext();
        if (PHPVersion.PHP7_4.isGreaterThan(this.getCompanion().getPHPVersion())) {
            return;
        }
        String prefix = context.getPrefix();
        String suffix = "";
        ISourceRange replaceRange = this.getReplacementRange(context);
        PHPVersion phpVersion = this.getCompanion().getPHPVersion();
        for (SimpleProposal proposal : TYPES) {
            if (!proposal.isValidPrefix(prefix, phpVersion)) continue;
            reporter.reportKeyword(proposal.getProposal(), suffix, replaceRange);
        }
        super.apply(reporter);
    }

    @Override
    public String getSuffix(AbstractCompletionContext abstractContext) {
        return "";
    }

    @Override
    protected int getExtraInfo() {
        return 2;
    }
}

