/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.widgets.internal;

import org.eclipse.draw2d.AbstractLocator;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;

public class AligningBendpointLocator
extends AbstractLocator {
    public static final int MIDDLE = 0;
    public static final int ABOVE = 1;
    public static final int BELOW = 2;
    public static final int CENTER = 0;
    public static final int BEGINNING = 1;
    public static final int END = 2;
    public static final int CENTER_BEGINNING = 3;
    public static final int CENTER_END = 4;
    private int horizontal;
    private int vertical;
    private final Connection connection;

    public AligningBendpointLocator(Connection connection) {
        this(connection, 0, 0);
    }

    public AligningBendpointLocator(Connection connection, int horizontal, int vertical) {
        this.connection = connection;
        this.horizontal = horizontal;
        this.vertical = vertical;
    }

    protected Point getReferencePoint() {
        PointList points = this.getConnection().getPoints();
        Point p = points.getMidpoint().getCopy();
        PointList tempPoints = new PointList();
        switch (this.horizontal) {
            case 1: {
                p = points.getFirstPoint().getCopy();
                break;
            }
            case 2: {
                p = points.getLastPoint().getCopy();
                break;
            }
            case 3: {
                tempPoints.addPoint(points.getFirstPoint().getCopy());
                tempPoints.addPoint(points.getPoint(1).getCopy());
                p = tempPoints.getMidpoint().getCopy();
                break;
            }
            case 4: {
                tempPoints = new PointList();
                int s = points.size();
                tempPoints.addPoint(points.getLastPoint().getCopy());
                tempPoints.addPoint(points.getPoint(s - 2).getCopy());
                p = tempPoints.getMidpoint().getCopy();
            }
            default: {
                p = points.getMidpoint().getCopy();
            }
        }
        return p;
    }

    public void relocate(IFigure target) {
        Dimension prefSize = target.getPreferredSize();
        Point center = this.getReferencePoint();
        this.calculatePosition();
        target.setBounds(this.getNewBounds(prefSize, center));
    }

    private void calculatePosition() {
        PointList points = this.getConnection().getPoints();
        int position = 0;
        switch (this.horizontal) {
            case 1: {
                Point first = points.getFirstPoint();
                Point next = points.getPoint(1);
                if (first.x <= next.x) {
                    position |= 0x10;
                    break;
                }
                position |= 8;
                break;
            }
            case 2: {
                Point last = points.getLastPoint();
                int s = points.size();
                Point before = points.getPoint(s - 1);
                if (last.x <= before.x) {
                    position |= 0x10;
                    break;
                }
                position |= 8;
            }
        }
        if (position == 0) {
            position = 2;
        }
        switch (this.vertical) {
            case 1: {
                position |= 1;
                break;
            }
            case 2: {
                position |= 4;
                break;
            }
            case 0: {
                position |= 0x10;
            }
        }
        this.setRelativePosition(position);
    }

    public int getHorizontalAlignment() {
        return this.horizontal;
    }

    public void setHorizontalAlignment(int horizontal) {
        this.horizontal = horizontal;
    }

    public void setVerticalAlginment(int vertical) {
        this.vertical = vertical;
    }

    public int getVerticalAlignment() {
        return this.vertical;
    }

    public Connection getConnection() {
        return this.connection;
    }
}

