/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator;

import java.io.FileOutputStream;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.Messages;

public class BundleConverter {
    public static String convertProjectToBundle(String installLocation, IWorkspace workspace) throws Exception {
        IPath project = IPath.fromOSString((String)installLocation);
        if (!project.toFile().isDirectory()) {
            throw new Exception(Messages.BundleConverter_installLocationNotADirectory);
        }
        IPath metaDir = project.append("META-INF");
        if (!metaDir.toFile().isDirectory() && !metaDir.toFile().mkdir()) {
            throw new Exception(Messages.BundleConverter_couldNotCreateMetaInfDir);
        }
        IPath manifestPath = metaDir.append("MANIFEST.MF");
        if (manifestPath.toFile().isFile()) {
            throw new Exception(Messages.BundleConverter_projectIsAlreadyABundle);
        }
        Manifest manifest = new Manifest();
        IPath path = IPath.fromOSString((String)installLocation);
        String bundleId = path.lastSegment();
        String bundleName = path.lastSegment();
        manifest.getMainAttributes().putValue("Manifest-Version", "1.0");
        manifest.getMainAttributes().putValue("Bundle-SymbolicName", bundleId);
        manifest.getMainAttributes().putValue("Bundle-Name", bundleName);
        manifest.getMainAttributes().putValue("Bundle-Version", "0.0.1");
        manifest.write(new FileOutputStream(manifestPath.toFile()));
        IProject targetProject = workspace.getRoot().getProject(bundleId);
        targetProject.refreshLocal(2, null);
        return bundleId;
    }
}

