/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.clone;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.clone.GitCreateProjectViaWizardWizard;
import org.eclipse.egit.ui.internal.repository.RepositoriesViewContentProvider;
import org.eclipse.egit.ui.internal.repository.RepositoryTreeNodeLabelProvider;
import org.eclipse.egit.ui.internal.repository.tree.FolderNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.egit.ui.internal.repository.tree.WorkingDirNode;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class GitSelectWizardPage
extends WizardPage {
    public static final int EXISTING_PROJECTS_WIZARD = 0;
    public static final int NEW_WIZARD = 1;
    public static final int GENERAL_WIZARD = 2;
    private final String PREF_WIZ = this.getName() + "WizardSel";
    private Button importExisting;
    private Button newProjectWizard;
    private Button generalWizard;
    private TreeViewer tv;
    private final Repository initialRepository;
    private final String initialPath;
    private int wizardSelection = 0;

    public GitSelectWizardPage() {
        super(GitSelectWizardPage.class.getName());
        this.setTitle(UIText.GitImportWithDirectoriesPage_PageTitle);
        this.setMessage(UIText.GitImportWithDirectoriesPage_PageMessage);
        this.initialRepository = null;
        this.initialPath = null;
    }

    public GitSelectWizardPage(Repository repository, String path) {
        super(GitSelectWizardPage.class.getName());
        this.setTitle(UIText.GitImportWithDirectoriesPage_PageTitle);
        this.setMessage(UIText.GitImportWithDirectoriesPage_PageMessage);
        this.initialRepository = repository;
        this.initialPath = path;
    }

    public String getPath() {
        IStructuredSelection sel = (IStructuredSelection)this.tv.getSelection();
        RepositoryTreeNode node = (RepositoryTreeNode)sel.getFirstElement();
        if (node != null && node.getType() == RepositoryTreeNodeType.FOLDER) {
            return ((File)node.getObject()).getPath();
        }
        if (node != null && node.getType() == RepositoryTreeNodeType.WORKINGDIR) {
            return node.getRepository().getWorkTree().getPath();
        }
        return null;
    }

    public void setRepository(Repository repo) {
        ArrayList<WorkingDirNode> input = new ArrayList<WorkingDirNode>();
        if (repo != null) {
            input.add(new WorkingDirNode(null, repo));
        }
        this.tv.setInput(input);
        this.tv.expandToLevel(2);
        this.tv.setSelection((ISelection)new StructuredSelection(input.get(0)));
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0x400000);
        main.setLayout((Layout)new GridLayout(1, false));
        SelectionAdapter sl = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GitSelectWizardPage.this.tv.getTree().setEnabled(!GitSelectWizardPage.this.newProjectWizard.getSelection());
                GitSelectWizardPage.this.wizardSelection = GitSelectWizardPage.this.importExisting.getSelection() ? 0 : (GitSelectWizardPage.this.newProjectWizard.getSelection() ? 1 : (GitSelectWizardPage.this.generalWizard.getSelection() ? 2 : 0));
                GitSelectWizardPage.this.checkPage();
            }
        };
        Group wizardType = new Group(main, 16);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)wizardType);
        wizardType.setText(UIText.GitSelectWizardPage_ProjectCreationHeader);
        wizardType.setLayout((Layout)new GridLayout(1, false));
        this.importExisting = new Button((Composite)wizardType, 16);
        this.importExisting.setText(UIText.GitSelectWizardPage_ImportExistingButton);
        this.importExisting.addSelectionListener((SelectionListener)sl);
        this.decorateWithFilterCount(this.importExisting);
        this.newProjectWizard = new Button((Composite)wizardType, 16);
        this.newProjectWizard.setText(UIText.GitSelectWizardPage_UseNewProjectsWizardButton);
        this.newProjectWizard.addSelectionListener((SelectionListener)sl);
        this.generalWizard = new Button((Composite)wizardType, 16);
        this.generalWizard.setText(UIText.GitSelectWizardPage_ImportAsGeneralButton);
        this.generalWizard.addSelectionListener((SelectionListener)sl);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        try {
            this.wizardSelection = settings.getInt(this.PREF_WIZ);
        }
        catch (NumberFormatException e) {
            this.wizardSelection = 0;
        }
        switch (this.wizardSelection) {
            default: {
                this.importExisting.setSelection(true);
                break;
            }
            case 2: {
                this.generalWizard.setSelection(true);
                break;
            }
            case 1: {
                this.newProjectWizard.setSelection(true);
            }
        }
        this.tv = new TreeViewer(main, 2820);
        RepositoriesViewContentProvider cp = new RepositoriesViewContentProvider();
        this.tv.setContentProvider((IContentProvider)cp);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 200).applyTo((Control)this.tv.getTree());
        this.tv.setLabelProvider((IBaseLabelProvider)new RepositoryTreeNodeLabelProvider(true));
        this.tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GitSelectWizardPage.this.checkPage();
            }
        });
        if (this.initialRepository != null) {
            ArrayList<WorkingDirNode> input = new ArrayList<WorkingDirNode>();
            WorkingDirNode node = new WorkingDirNode(null, this.initialRepository);
            input.add(node);
            this.tv.setInput(input);
            this.tv.expandToLevel(2);
            if (this.initialPath == null) {
                this.tv.setSelection((ISelection)new StructuredSelection(input.get(0)));
            } else {
                RepositoryTreeNode parentNode = node;
                Path fullPath = new Path(this.initialPath);
                Path workdirPath = new Path(this.initialRepository.getWorkTree().getPath());
                if (workdirPath.isPrefixOf((IPath)fullPath)) {
                    IPath relPath = fullPath.removeFirstSegments(workdirPath.segmentCount());
                    String[] stringArray = relPath.segments();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String segment = stringArray[n2];
                        Object[] objectArray = cp.getChildren(parentNode);
                        int n3 = objectArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            FolderNode childFolder;
                            Object child = objectArray[n4];
                            if (child instanceof FolderNode && ((File)(childFolder = (FolderNode)child).getObject()).getName().equals(segment)) {
                                parentNode = childFolder;
                                break;
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    this.tv.setSelection((ISelection)new StructuredSelection((Object)parentNode));
                }
            }
        }
        this.tv.getTree().setEnabled(!this.newProjectWizard.getSelection());
        Dialog.applyDialogFont((Control)main);
        this.setControl((Control)main);
    }

    private void decorateWithFilterCount(Button button) {
        GitCreateProjectViaWizardWizard wizard;
        List<String> filter;
        if (this.getWizard() instanceof GitCreateProjectViaWizardWizard && (filter = (wizard = (GitCreateProjectViaWizardWizard)this.getWizard()).getFilter()).size() > 1) {
            String decoration = MessageFormat.format(UIText.GitSelectWizardPage_Selected, filter.size());
            button.setText(button.getText() + " " + decoration);
        }
    }

    public int getWizardSelection() {
        return this.wizardSelection;
    }

    protected void checkPage() {
        block5: {
            IStructuredSelection sel;
            block4: {
                IDialogSettings settings = Activator.getDefault().getDialogSettings();
                settings.put(this.PREF_WIZ, this.getWizardSelection());
                this.setErrorMessage(null);
                if (this.newProjectWizard.getSelection()) {
                    this.setPageComplete(true);
                    return;
                }
                sel = (IStructuredSelection)this.tv.getSelection();
                try {
                    if (!sel.isEmpty()) break block4;
                    this.setErrorMessage(UIText.GitImportWithDirectoriesPage_SelectFolderMessage);
                }
                catch (Throwable throwable) {
                    this.setPageComplete(this.getErrorMessage() == null);
                    throw throwable;
                }
                this.setPageComplete(this.getErrorMessage() == null);
                return;
            }
            RepositoryTreeNode node = (RepositoryTreeNode)sel.getFirstElement();
            if (node.getType() == RepositoryTreeNodeType.FOLDER || node.getType() == RepositoryTreeNodeType.WORKINGDIR) break block5;
            this.setErrorMessage(UIText.GitImportWithDirectoriesPage_SelectFolderMessage);
            this.setPageComplete(this.getErrorMessage() == null);
            return;
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }
}

