/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.BomHeader;

final class BomUtil {
    static final int POTENTIAL_BOM_SIZE = 4;

    private BomUtil() {
    }

    static Optional<BomHeader> detectCharset(byte[] buf) {
        int n = buf.length;
        if (n < 2) {
            return Optional.empty();
        }
        if (buf[0] == -17) {
            if (n > 2 && buf[1] == -69 && buf[2] == -65) {
                return Optional.of(BomHeader.UTF_8);
            }
        } else if (buf[0] == -2) {
            if (buf[1] == -1) {
                return Optional.of(BomHeader.UTF_16_BE);
            }
        } else if (buf[0] == -1) {
            if (buf[1] == -2) {
                if (n > 3 && buf[2] == 0 && buf[3] == 0) {
                    return Optional.of(BomHeader.UTF_32_LE);
                }
                return Optional.of(BomHeader.UTF_16_LE);
            }
        } else if (buf[0] == 0 && n > 3 && buf[1] == 0 && buf[2] == -2 && buf[3] == -1) {
            return Optional.of(BomHeader.UTF_32_BE);
        }
        return Optional.empty();
    }

    static Optional<BomHeader> detectCharset(Path file) throws IOException {
        try (InputStream in = Files.newInputStream(file, StandardOpenOption.READ);){
            Optional<BomHeader> optional = BomUtil.detectCharset(in.readNBytes(4));
            return optional;
        }
    }
}

