/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro;

import com.google.inject.Inject;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.xtend.core.macro.ConstantExpressionsInterpreter;
import org.eclipse.xtend.core.xtend.XtendAnnotationTarget;
import org.eclipse.xtend.core.xtend.XtendAnnotationType;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendEnum;
import org.eclipse.xtend.core.xtend.XtendEnumLiteral;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendInterface;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtend.lib.macro.Active;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmCustomAnnotationValue;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeAnnotationValue;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.linking.ILinkingService;
import org.eclipse.xtext.linking.lazy.LazyURIEncoder;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class XAnnotationExtensions {
    @Inject
    private LazyURIEncoder encoder;
    @Inject
    private ILinkingService linkingService;
    @Inject
    private ConstantExpressionsInterpreter constantExpressionsInterpreter;

    public XtendAnnotationTarget getAnnotatedTarget(XAnnotation annotation) {
        EObject _eContainer;
        XtendAnnotationTarget _switchResult = null;
        EObject container = _eContainer = annotation.eContainer();
        boolean _matched = false;
        if (container instanceof XtendAnnotationType) {
            _matched = true;
        }
        if (!_matched && container instanceof XtendClass) {
            _matched = true;
        }
        if (!_matched && container instanceof XtendInterface) {
            _matched = true;
        }
        if (!_matched && container instanceof XtendEnum) {
            _matched = true;
        }
        if (!_matched && container instanceof XtendField) {
            _matched = true;
        }
        if (!_matched && container instanceof XtendFunction) {
            _matched = true;
        }
        if (!_matched && container instanceof XtendConstructor) {
            _matched = true;
        }
        if (!_matched && container instanceof XtendEnumLiteral) {
            _matched = true;
        }
        if (!_matched && container instanceof XtendParameter) {
            _matched = true;
        }
        if (_matched) {
            _switchResult = (XtendAnnotationTarget)container;
        }
        if (!_matched && container instanceof XtendAnnotationTarget) {
            _matched = true;
            XtendAnnotationTarget _xblockexpression = null;
            EObject containerContainer = ((XtendAnnotationTarget)container).eContainer();
            XtendAnnotationTarget _xifexpression = null;
            _xifexpression = containerContainer instanceof XtendAnnotationTarget ? (XtendAnnotationTarget)containerContainer : (XtendAnnotationTarget)container;
            _switchResult = _xblockexpression = _xifexpression;
        }
        if (!_matched && container instanceof XAnnotation) {
            _matched = true;
            _switchResult = this.getAnnotatedTarget((XAnnotation)container);
        }
        if (!_matched) {
            _switchResult = null;
        }
        return _switchResult;
    }

    public boolean isProcessed(XAnnotation it) {
        boolean _eIsProxy;
        Object _eGet;
        Object proxy = _eGet = it.eGet((EStructuralFeature)XAnnotationsPackage.Literals.XANNOTATION__ANNOTATION_TYPE, false);
        boolean _matched = false;
        if (proxy instanceof EObject && (_eIsProxy = ((EObject)proxy).eIsProxy())) {
            _matched = true;
            URI uri = ((InternalEObject)proxy).eProxyURI();
            boolean _isCrossLinkFragment = this.encoder.isCrossLinkFragment(it.eResource(), uri.fragment());
            if (_isCrossLinkFragment) {
                EObject head;
                boolean _not;
                Triple triple = this.encoder.decode(it.eResource(), uri.fragment());
                List candidates = this.linkingService.getLinkedObjects((EObject)triple.getFirst(), (EReference)triple.getSecond(), (INode)triple.getThird());
                boolean _isEmpty = candidates.isEmpty();
                boolean bl = _not = !_isEmpty;
                if (_not && (head = (EObject)IterableExtensions.head((Iterable)candidates)) instanceof JvmAnnotationType) {
                    return this.isActiveAnnotation((JvmAnnotationType)head);
                }
            }
        }
        if (!_matched && proxy instanceof JvmAnnotationType) {
            _matched = true;
            return this.isActiveAnnotation((JvmAnnotationType)proxy);
        }
        return false;
    }

    public JvmType getProcessorType(JvmAnnotationType it) {
        Functions.Function1 _function = it_1 -> {
            JvmAnnotationType _annotation = it_1.getAnnotation();
            String _identifier = null;
            if (_annotation != null) {
                _identifier = _annotation.getIdentifier();
            }
            String _name = Active.class.getName();
            return Objects.equals(_identifier, _name);
        };
        JvmAnnotationReference activeAnnotation = (JvmAnnotationReference)IterableExtensions.findFirst((Iterable)it.getAnnotations(), (Functions.Function1)_function);
        Functions.Function1 _function_1 = it_1 -> it_1.getOperation() == null || Objects.equals(it_1.getOperation().getSimpleName(), "value");
        JvmAnnotationValue annoVal = (JvmAnnotationValue)IterableExtensions.findFirst((Iterable)activeAnnotation.getValues(), (Functions.Function1)_function_1);
        boolean _matched = false;
        if (annoVal instanceof JvmTypeAnnotationValue) {
            _matched = true;
            JvmTypeReference _head = (JvmTypeReference)IterableExtensions.head((Iterable)((JvmTypeAnnotationValue)annoVal).getValues());
            JvmType _type = null;
            if (_head != null) {
                _type = _head.getType();
            }
            return _type;
        }
        if (!_matched && annoVal instanceof JvmCustomAnnotationValue) {
            Object type;
            _matched = true;
            EObject _head = (EObject)IterableExtensions.head((Iterable)((JvmCustomAnnotationValue)annoVal).getValues());
            JvmOperation _operation = ((JvmCustomAnnotationValue)annoVal).getOperation();
            JvmTypeReference _returnType = null;
            if (_operation != null) {
                _returnType = _operation.getReturnType();
            }
            if ((type = this.constantExpressionsInterpreter.evaluate((XExpression)_head, _returnType)) instanceof JvmTypeReference) {
                return ((JvmTypeReference)type).getType();
            }
        }
        return null;
    }

    public JvmType getProcessorType(XAnnotation it) {
        return this.getProcessorType(this.tryFindAnnotationType(it));
    }

    public JvmAnnotationType tryFindAnnotationType(XAnnotation it) {
        boolean _eIsProxy;
        Object _eGet;
        Object proxy = _eGet = it.eGet((EStructuralFeature)XAnnotationsPackage.Literals.XANNOTATION__ANNOTATION_TYPE, false);
        boolean _matched = false;
        if (proxy instanceof EObject && (_eIsProxy = ((EObject)proxy).eIsProxy())) {
            _matched = true;
            URI uri = ((InternalEObject)proxy).eProxyURI();
            EObject _eObject = it.eResource().getResourceSet().getEObject(uri, true);
            return (JvmAnnotationType)_eObject;
        }
        if (!_matched && proxy instanceof JvmAnnotationType) {
            _matched = true;
            return (JvmAnnotationType)proxy;
        }
        return null;
    }

    protected boolean isActiveAnnotation(JvmAnnotationType annotationType) {
        EList _annotations = annotationType.getAnnotations();
        for (JvmAnnotationReference anno : _annotations) {
            String _name;
            String _identifier = anno.getAnnotation().getIdentifier();
            boolean _equals = Objects.equals(_identifier, _name = Active.class.getName());
            if (!_equals) continue;
            return true;
        }
        return false;
    }
}

