/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.console;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.console.ConsoleMessages;
import org.eclipse.jdt.internal.debug.ui.console.JavaStackTraceHyperlink;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.TextConsole;

public class JavaDebugStackTraceHyperlink
extends JavaStackTraceHyperlink {
    static final String LINE_PREFIX = "line: ";
    private static final Pattern LINE_PATTERN = Pattern.compile(".*(line: \\d+)");

    public JavaDebugStackTraceHyperlink(TextConsole console) {
        super(console);
    }

    @Override
    protected String getLinkText() throws CoreException {
        try {
            TextConsole console = this.getConsole();
            IDocument document = console.getDocument();
            IRegion region = console.getRegion((IHyperlink)this);
            int regionOffset = region.getOffset();
            int lineNumber = document.getLineOfOffset(regionOffset);
            IRegion lineInformation = document.getLineInformation(lineNumber);
            int lineOffset = lineInformation.getOffset();
            String line = document.get(lineOffset, lineInformation.getLength());
            line = line.trim();
            return line;
        }
        catch (BadLocationException e) {
            Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ConsoleMessages.JavaStackTraceHyperlink_Unable_to_retrieve_hyperlink_text__8, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    @Override
    protected int getLineNumber(String linkText) {
        LinkSubstring lineText = JavaDebugStackTraceHyperlink.extractLineText(linkText);
        if (lineText != null) {
            try {
                String lineNumberText = lineText.substring.substring(LINE_PREFIX.length());
                return Integer.parseInt(lineNumberText);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    @Override
    protected String getTypeName(String linkText) throws CoreException {
        LinkSubstring linkSubstring = JavaDebugStackTraceHyperlink.extractTypeName(linkText);
        if (linkSubstring != null) {
            return linkSubstring.substring;
        }
        Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ConsoleMessages.JavaStackTraceHyperlink_Unable_to_parse_type_name_from_hyperlink__5, null);
        throw new CoreException((IStatus)status);
    }

    public static LinkSubstring extractLineText(String linkText) {
        int groupCount;
        int groupIndex;
        LinkSubstring lineText = null;
        Matcher matcher = LINE_PATTERN.matcher(linkText);
        if (matcher.matches() && (groupIndex = 1) <= (groupCount = matcher.groupCount())) {
            String lineNumberText = matcher.group(groupIndex);
            int startIndex = matcher.start(groupIndex);
            lineText = new LinkSubstring(lineNumberText, startIndex);
        }
        return lineText;
    }

    public static LinkSubstring extractTypeName(String linkText) {
        int indexOfOpeningBracket;
        boolean hasLeadingSubtype = false;
        int startIndex = 0;
        int endIndex = indexOfOpeningBracket = linkText.indexOf(40);
        int indexOfSecondOpeningBracket = linkText.indexOf(40, endIndex + 1);
        int indexOfClosingBracket = linkText.indexOf(41, endIndex);
        if (indexOfSecondOpeningBracket != -1 && indexOfClosingBracket != -1 && indexOfClosingBracket < indexOfSecondOpeningBracket) {
            startIndex = endIndex + 1;
            endIndex = indexOfClosingBracket;
            hasLeadingSubtype = true;
        }
        if (endIndex >= 0) {
            int innerClassIndex;
            int indexOfTriangleBracket;
            int dotIndex;
            String substring = linkText.substring(startIndex, endIndex);
            if (!hasLeadingSubtype && (dotIndex = substring.lastIndexOf(46)) != -1) {
                endIndex = startIndex + dotIndex;
                substring = linkText.substring(startIndex, endIndex);
            }
            if ((indexOfTriangleBracket = substring.indexOf(60)) != -1) {
                endIndex = startIndex + indexOfTriangleBracket;
                substring = linkText.substring(startIndex, endIndex);
            }
            if ((innerClassIndex = substring.indexOf(36)) != -1) {
                endIndex = startIndex + innerClassIndex;
            }
        }
        String typeName = linkText.substring(startIndex, endIndex);
        return new LinkSubstring(typeName, startIndex);
    }

    static class LinkSubstring {
        final String substring;
        final int startIndex;

        private LinkSubstring(String substring, int startIndex) {
            this.substring = substring;
            this.startIndex = startIndex;
        }
    }
}

