/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum XSDDiagnosticSeverity implements Enumerator
{
    FATAL_LITERAL(0, "fatal", "fatal"),
    ERROR_LITERAL(1, "error", "error"),
    WARNING_LITERAL(2, "warning", "warning"),
    INFORMATION_LITERAL(3, "information", "information");

    public static final int FATAL = 0;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int INFORMATION = 3;
    private static final XSDDiagnosticSeverity[] VALUES_ARRAY;
    public static final List<XSDDiagnosticSeverity> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new XSDDiagnosticSeverity[]{FATAL_LITERAL, ERROR_LITERAL, WARNING_LITERAL, INFORMATION_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static XSDDiagnosticSeverity get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            XSDDiagnosticSeverity result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static XSDDiagnosticSeverity getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            XSDDiagnosticSeverity result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static XSDDiagnosticSeverity get(int value) {
        switch (value) {
            case 0: {
                return FATAL_LITERAL;
            }
            case 1: {
                return ERROR_LITERAL;
            }
            case 2: {
                return WARNING_LITERAL;
            }
            case 3: {
                return INFORMATION_LITERAL;
            }
        }
        return null;
    }

    private XSDDiagnosticSeverity(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

