/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICDescriptionDelta;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSettingsStorage;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.cdt.internal.core.settings.model.AbstractCProjectDescriptionStorage;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationSpecSettings;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescription;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.internal.core.settings.model.IInternalCCfgInfo;
import org.eclipse.cdt.internal.core.settings.model.SettingsContext;
import org.eclipse.cdt.internal.core.settings.model.SettingsModelMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class SetCProjectDescriptionOperation
extends CModelOperation {
    private final AbstractCProjectDescriptionStorage fPrjDescStorage;
    private final CProjectDescription fSetDescription;
    private final int fFlags;

    public SetCProjectDescriptionOperation(AbstractCProjectDescriptionStorage prjDescStorage, ICProject cProject, CProjectDescription description, int flags) {
        super(cProject);
        this.fPrjDescStorage = prjDescStorage;
        this.fFlags = flags;
        this.fSetDescription = description;
    }

    @Override
    protected void executeOperation() throws CModelException {
        ICElementDelta[] cElementDeltas;
        CProjectDescriptionManager mngr = CProjectDescriptionManager.getInstance();
        ICProject cProject = (ICProject)this.getElementToProcess();
        IProject project = cProject.getProject();
        ICProjectDescription fOldDescriptionCache = mngr.getProjectDescription(project, false);
        AbstractCProjectDescriptionStorage.fireAboutToApplyEvent(this.fSetDescription, fOldDescriptionCache);
        CProjectDescription fNewDescriptionCache = null;
        SettingsContext context = new SettingsContext(project);
        boolean needsSerialization = false;
        if (this.fSetDescription != null) {
            boolean creating;
            ICStorageElement newEl = null;
            ICSettingsStorage newStorage = null;
            try {
                ICStorageElement base = this.fSetDescription.getRootStorageElement();
                needsSerialization = this.fSetDescription.needsDescriptionPersistence();
                newEl = this.fPrjDescStorage.copyElement(base, false);
                newStorage = this.fPrjDescStorage.getStorageForElement(newEl);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
            boolean bl = creating = fOldDescriptionCache != null ? fOldDescriptionCache.isCdtProjectCreating() : true;
            if (creating) {
                creating = this.fSetDescription.isCdtProjectCreating();
            }
            if (!(this.fSetDescription.isValid() || mngr.isEmptyCreatingDescriptionAllowed() && creating)) {
                throw new CModelException(ExceptionFactory.createCoreException(SettingsModelMessages.getString("CProjectDescriptionManager.17") + project.getName()));
            }
            fNewDescriptionCache = new CProjectDescription(this.fSetDescription, true, newStorage, newEl, creating);
            boolean[] envStates = this.getEnvStates(fNewDescriptionCache);
            try {
                this.fPrjDescStorage.setThreadLocalProjectDesc(fNewDescriptionCache);
                fNewDescriptionCache.applyDatas(context);
            }
            finally {
                this.fPrjDescStorage.setThreadLocalProjectDesc(null);
                this.setEnvStates(fNewDescriptionCache, envStates);
            }
        }
        ICDescriptionDelta delta = mngr.createDelta(fNewDescriptionCache, fOldDescriptionCache);
        mngr.checkRemovedConfigurations(delta);
        ICElementDelta[] iCElementDeltaArray = cElementDeltas = mngr.generateCElementDeltas(cProject, delta);
        int n = cElementDeltas.length;
        int envStates = 0;
        while (envStates < n) {
            ICElementDelta d = iCElementDeltaArray[envStates];
            this.addDelta(d);
            ++envStates;
        }
        if (this.fSetDescription != null) {
            this.fSetDescription.switchToCachedAppliedData(fNewDescriptionCache);
        }
        try {
            IProjectDescription eDes = context.getEclipseProjectDescription();
            if (mngr.checkHandleActiveCfgChange(fNewDescriptionCache, fOldDescriptionCache, eDes, (IProgressMonitor)new NullProgressMonitor())) {
                context.setEclipseProjectDescription(eDes);
            }
        }
        catch (CoreException e2) {
            CCorePlugin.log(e2);
        }
        AbstractCProjectDescriptionStorage.fireDataAppliedEvent(fNewDescriptionCache, fOldDescriptionCache, this.fSetDescription, delta);
        cProject.close();
        if (fNewDescriptionCache != null) {
            fNewDescriptionCache.doneApplying();
        }
        this.fPrjDescStorage.setCurrentDescription(fNewDescriptionCache, true);
        CProjectDescriptionEvent event = AbstractCProjectDescriptionStorage.createAppliedEvent(fNewDescriptionCache, fOldDescriptionCache, this.fSetDescription, delta);
        mngr.notifyListeners(event);
        try {
            IWorkspaceRunnable toRun = null;
            if (fNewDescriptionCache != null && !CProjectDescriptionManager.checkFlags(this.fFlags, 2) && (needsSerialization || SetCProjectDescriptionOperation.isPersistentCoreSettingChanged(event)) && (toRun = this.fPrjDescStorage.createDesSerializationRunnable()) != null) {
                context.addWorkspaceRunnable(toRun);
            }
            if ((toRun = context.createOperationRunnable()) != null) {
                CProjectDescriptionManager.runWspModification((ICoreRunnable)toRun, this.getSchedulingRule(), (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
    }

    private static boolean isPersistentCoreSettingChanged(CProjectDescriptionEvent event) {
        ICDescriptionDelta delta = event.getProjectDelta();
        if (delta == null) {
            return false;
        }
        if (delta.getDeltaKind() != 3) {
            return true;
        }
        if (delta.getChildren().length != 0) {
            return true;
        }
        int flags = delta.getChangeFlags();
        return (flags & 0xFFDFFFFE) != 0;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    private boolean[] getEnvStates(CProjectDescription pd) {
        ICConfigurationDescription[] cfs = pd.getConfigurations();
        boolean[] result = new boolean[cfs.length];
        int i = 0;
        while (i < cfs.length) {
            if (cfs[i] instanceof IInternalCCfgInfo) {
                try {
                    CConfigurationSpecSettings ss = ((IInternalCCfgInfo)((Object)cfs[i])).getSpecSettings();
                    if (ss != null && ss.getEnvironment() != null) {
                        result[i] = ss.getEnvironment().isDirty();
                    }
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                }
            }
            ++i;
        }
        return result;
    }

    private void setEnvStates(CProjectDescription pd, boolean[] data) {
        ICConfigurationDescription[] cfs = pd.getConfigurations();
        if (cfs == null || data == null) {
            return;
        }
        int i = 0;
        while (i < cfs.length) {
            if (data.length <= i) {
                CCorePlugin.log("Error: setEnvStates: different number of configurations as there are envDatas...", new Exception());
                break;
            }
            if (data[i] && cfs[i] instanceof IInternalCCfgInfo) {
                try {
                    CConfigurationSpecSettings ss = ((IInternalCCfgInfo)((Object)cfs[i])).getSpecSettings();
                    if (ss != null && ss.getEnvironment() != null) {
                        ss.getEnvironment().setDirty(true);
                    }
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                }
            }
            ++i;
        }
    }
}

