/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure.constraints;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.HierarchyType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ITypeSet;

public abstract class SuperTypeSet
implements ITypeSet {
    private static final ITypeSet fgEmpty = new SuperTypeEmptySet();
    private static final ITypeSet fgUniverse = new SuperTypeUniverse();

    public static ITypeSet createTypeSet(TType type) {
        if (type == null) {
            return fgUniverse;
        }
        return new SuperTypeSingletonSet(type);
    }

    public static ITypeSet createTypeSet(TType subType, TType superType) {
        if (subType == null || superType == null) {
            return fgUniverse;
        }
        return new SuperTypeTuple(subType, superType);
    }

    public static ITypeSet getEmpty() {
        return fgEmpty;
    }

    public static ITypeSet getUniverse() {
        return fgUniverse;
    }

    private SuperTypeSet() {
    }

    private static class SuperTypeEmptySet
    extends SuperTypeSet {
        private SuperTypeEmptySet() {
        }

        @Override
        public final TType chooseSingleType() {
            return null;
        }

        @Override
        public final boolean isEmpty() {
            return true;
        }

        @Override
        public final ITypeSet restrictedTo(ITypeSet set) {
            return this;
        }

        @Override
        public final String toString() {
            return "EMPTY";
        }
    }

    private static class SuperTypeSingletonSet
    extends SuperTypeSet {
        private final TType fType;

        private SuperTypeSingletonSet(TType type) {
            this.fType = type;
        }

        @Override
        public final TType chooseSingleType() {
            return this.fType;
        }

        @Override
        public final boolean isEmpty() {
            return false;
        }

        @Override
        public final ITypeSet restrictedTo(ITypeSet set) {
            TType leftErasure = this.fType.getErasure();
            if (set instanceof SuperTypeUniverse) {
                return this;
            }
            if (set instanceof SuperTypeSingletonSet) {
                if (this == set) {
                    return this;
                }
                if (this.fType.isNullType()) {
                    return this;
                }
                SuperTypeSingletonSet singleton = (SuperTypeSingletonSet)set;
                TType rightErasure = singleton.fType.getErasure();
                if (leftErasure.isHierarchyType() && rightErasure.isHierarchyType() && (leftErasure.isGenericType() || rightErasure.isGenericType()) && (rightErasure.equals(leftErasure) || ((HierarchyType)leftErasure).isSubType((HierarchyType)rightErasure))) {
                    return this;
                }
                if (rightErasure.isJavaLangObject()) {
                    return this;
                }
                if (leftErasure.canAssignTo(rightErasure)) {
                    return this;
                }
                return SuperTypeSet.getEmpty();
            }
            if (set instanceof SuperTypeTuple) {
                if (this.fType.isNullType()) {
                    return this;
                }
                SuperTypeTuple tuple = (SuperTypeTuple)set;
                TType rightErasure = tuple.fSuperType.getErasure();
                if (leftErasure.isHierarchyType() && rightErasure.isHierarchyType() && (leftErasure.isGenericType() || rightErasure.isGenericType()) && (rightErasure.equals(leftErasure) || ((HierarchyType)leftErasure).isSubType((HierarchyType)rightErasure))) {
                    return this;
                }
                if (rightErasure.isJavaLangObject()) {
                    return this;
                }
                if (leftErasure.canAssignTo(rightErasure)) {
                    return this;
                }
                return SuperTypeSet.createTypeSet(tuple.fSubType);
            }
            if (set instanceof SuperTypeEmptySet) {
                return set;
            }
            Assert.isTrue((boolean)false);
            return null;
        }

        @Override
        public final String toString() {
            return this.fType.getPrettySignature();
        }
    }

    private static class SuperTypeTuple
    extends SuperTypeSet {
        private final TType fSubType;
        private final TType fSuperType;

        private SuperTypeTuple(TType subType, TType superType) {
            this.fSubType = subType;
            this.fSuperType = superType;
        }

        @Override
        public final TType chooseSingleType() {
            return this.fSuperType;
        }

        @Override
        public final boolean isEmpty() {
            return false;
        }

        @Override
        public final ITypeSet restrictedTo(ITypeSet set) {
            if (set instanceof SuperTypeUniverse) {
                return this;
            }
            if (set instanceof SuperTypeSingletonSet) {
                SuperTypeSingletonSet singleton = (SuperTypeSingletonSet)set;
                TType rightErasure = singleton.fType.getErasure();
                TType subErasure = this.fSubType.getErasure();
                TType superErasure = this.fSuperType.getErasure();
                if (subErasure.isHierarchyType() && superErasure.isHierarchyType() && rightErasure.isHierarchyType() && (subErasure.isGenericType() || superErasure.isGenericType() || rightErasure.isGenericType()) && (rightErasure.equals(subErasure) || ((HierarchyType)subErasure).isSubType((HierarchyType)rightErasure)) && (rightErasure.equals(superErasure) || ((HierarchyType)superErasure).isSubType((HierarchyType)rightErasure))) {
                    return this;
                }
                if (rightErasure.isJavaLangObject()) {
                    return this;
                }
                if (subErasure.canAssignTo(rightErasure) && superErasure.canAssignTo(rightErasure)) {
                    return this;
                }
                return SuperTypeSet.createTypeSet(this.fSubType);
            }
            if (set instanceof SuperTypeTuple) {
                return this;
            }
            if (set instanceof SuperTypeEmptySet) {
                return set;
            }
            Assert.isTrue((boolean)false);
            return null;
        }

        @Override
        public final String toString() {
            return "[" + this.fSubType.getPrettySignature() + ", " + this.fSuperType.getPrettySignature() + "]";
        }
    }

    private static class SuperTypeUniverse
    extends SuperTypeSet {
        private SuperTypeUniverse() {
        }

        @Override
        public final TType chooseSingleType() {
            return null;
        }

        @Override
        public final boolean isEmpty() {
            return false;
        }

        @Override
        public final ITypeSet restrictedTo(ITypeSet set) {
            return set;
        }

        @Override
        public final String toString() {
            return "UNIVERSE";
        }
    }
}

