/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.CMRelaxNGAttributeDeclarationCollector;
import com.thaiopensource.relaxng.pattern.CMRelaxNGDocument;
import com.thaiopensource.relaxng.pattern.CMRelaxNGElementDeclarationCollector;
import com.thaiopensource.relaxng.pattern.ElementPattern;
import com.thaiopensource.relaxng.pattern.MyRequiredElementsFunction;
import com.thaiopensource.relaxng.pattern.NameClass;
import com.thaiopensource.relaxng.pattern.PatternMatcher;
import com.thaiopensource.relaxng.pattern.PossibleRequiredElementsFunction;
import com.thaiopensource.relaxng.pattern.SchemaPatternBuilder;
import com.thaiopensource.relaxng.pattern.SimpleNameClass;
import com.thaiopensource.relaxng.pattern.ValidatorPatternBuilder;
import com.thaiopensource.relaxng.sax.Context;
import com.thaiopensource.xml.util.Name;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.contentmodel.model.CMAttributeDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.CMElementDeclaration;
import org.eclipse.lemminx.services.extensions.ISharedSettingsRequest;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CMRelaxNGElementDeclaration
implements CMElementDeclaration {
    private final CMRelaxNGDocument cmDocument;
    private final ElementPattern pattern;
    private Collection<CMElementDeclaration> elements;
    private Collection<CMAttributeDeclaration> attributes;
    private Set<String> requiredElementNames;
    private Set<String> possibleRequiredElementNames;
    private DOMElement domElement;

    CMRelaxNGElementDeclaration(CMRelaxNGDocument document, ElementPattern pattern) {
        this.cmDocument = document;
        this.pattern = pattern;
    }

    public ElementPattern getPattern() {
        return this.pattern;
    }

    @Override
    public String getLocalName() {
        return this.getJingName().getLocalName();
    }

    @Override
    public String getNamespace() {
        return this.getJingName().getNamespaceUri();
    }

    @Override
    public String getPrefix(String namespaceURI) {
        DOMElement element = this.getDOMElement();
        if (element != null) {
            return element.getPrefix(namespaceURI);
        }
        return null;
    }

    private Name getJingName() {
        NameClass nameClass = this.pattern.getNameClass();
        if (nameClass instanceof SimpleNameClass) {
            return ((SimpleNameClass)nameClass).getName();
        }
        return null;
    }

    public DOMElement getDOMElement() {
        if (this.domElement != null) {
            return this.domElement;
        }
        DOMNode node = this.cmDocument.findNodeAt(this.pattern.getLocator());
        if (node != null && node.isElement()) {
            this.domElement = (DOMElement)node;
        }
        return this.domElement;
    }

    @Override
    public Collection<CMAttributeDeclaration> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new CMRelaxNGAttributeDeclarationCollector(this, this.pattern.getContent()).getAttributes();
        }
        return this.attributes;
    }

    @Override
    public Collection<CMElementDeclaration> getElements() {
        if (this.elements == null) {
            this.elements = new CMRelaxNGElementDeclarationCollector(this.cmDocument, this.pattern.getContent()).getElements();
        }
        return this.elements;
    }

    @Override
    public Collection<CMElementDeclaration> getPossibleElements(DOMElement parentElement, int offset) {
        PatternMatcher matcher = new PatternMatcher(this.pattern, new ValidatorPatternBuilder(new SchemaPatternBuilder()));
        matcher.matchStartDocument();
        Context context = new Context();
        Name n = CMRelaxNGElementDeclaration.createName(parentElement);
        matcher.matchStartTagOpen(n, n.getLocalName(), context);
        if (parentElement.hasAttributes()) {
            List<DOMAttr> attributes = parentElement.getAttributeNodes();
            for (DOMAttr attr : attributes) {
                Name a = this.createName(attr);
                matcher.matchAttributeName(a, a.getLocalName(), context);
                matcher.matchAttributeValue(attr.getValue(), a, a.getLocalName(), context);
            }
        }
        matcher.matchStartTagClose(n, n.getLocalName(), context);
        List<Name> names = CMRelaxNGElementDeclaration.toNames(parentElement, offset);
        for (Name name : names) {
            matcher.matchStartTagOpen(name, name.getLocalName(), context);
            matcher.matchEndTag(name, name.getLocalName(), context);
        }
        com.thaiopensource.relaxng.match.NameClass nc = matcher.possibleStartTagNames();
        Set<Name> allowed = nc.getIncludedNames();
        ArrayList<CMElementDeclaration> possibleElements = new ArrayList<CMElementDeclaration>();
        for (Name name : allowed) {
            CMElementDeclaration possible = this.findCMElement(name.getLocalName(), name.getNamespaceUri());
            possibleElements.add(possible);
        }
        return possibleElements;
    }

    private static List<Name> toNames(DOMElement parentElement, int offset) {
        if (parentElement == null || !parentElement.hasChildNodes()) {
            return Collections.emptyList();
        }
        ArrayList<Name> qNames = new ArrayList<Name>();
        NodeList children = parentElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            DOMElement element = (DOMElement)child;
            if (element.getEnd() > offset) break;
            if (!element.isClosed()) continue;
            qNames.add(CMRelaxNGElementDeclaration.createName(element));
        }
        return qNames;
    }

    private static Name createName(Element tag) {
        String namespace = tag.getNamespaceURI();
        return new Name(namespace == null ? "" : namespace, tag.getLocalName());
    }

    private Name createName(DOMAttr attr) {
        return new Name("", attr.getLocalName());
    }

    @Override
    public CMElementDeclaration findCMElement(String tag, String namespace) {
        for (CMElementDeclaration cmElement : this.getElements()) {
            if (!cmElement.getLocalName().equals(tag)) continue;
            return cmElement;
        }
        return null;
    }

    @Override
    public CMAttributeDeclaration findCMAttribute(String attributeName, String namespace) {
        for (CMAttributeDeclaration cmAttribute : this.getAttributes()) {
            if (!cmAttribute.getLocalName().equals(attributeName)) continue;
            return cmAttribute;
        }
        return null;
    }

    @Override
    public String getDocumentation(ISharedSettingsRequest request) {
        return this.cmDocument.getDocumentation(this.pattern.getLocator());
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Collection<String> getEnumerationValues() {
        return Collections.emptyList();
    }

    @Override
    public String getTextDocumentation(String value, ISharedSettingsRequest request) {
        return null;
    }

    @Override
    public String getDocumentURI() {
        return this.pattern.getLocator().getSystemId();
    }

    @Override
    public boolean isStringType() {
        return false;
    }

    @Override
    public boolean isMixedContent() {
        return false;
    }

    @Override
    public boolean isOptional(String childElementName) {
        return !this.getRequiredElementNames().contains(childElementName);
    }

    @Override
    public boolean isNillable() {
        return false;
    }

    void addElement(CMRelaxNGElementDeclaration element) {
        if (this.elements == null) {
            this.elements = new ArrayList<CMElementDeclaration>();
        }
        this.elements.add(element);
    }

    public CMRelaxNGDocument getCMDocument() {
        return this.cmDocument;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("<element");
        result.append(" name=\"");
        result.append(this.getJingName().getLocalName());
        result.append("\"");
        result.append(" namespaceUri=\"");
        result.append(this.getJingName().getNamespaceUri());
        result.append("\"");
        result.append(" />");
        return result.toString();
    }

    public Set<CMElementDeclaration> getRequiredElements() {
        LinkedHashSet<CMElementDeclaration> requiredElements = new LinkedHashSet<CMElementDeclaration>();
        for (String elementName : this.getRequiredElementNames()) {
            requiredElements.add(this.findCMElement(elementName, null));
        }
        return requiredElements;
    }

    private Set<String> getRequiredElementNames() {
        if (this.requiredElementNames == null) {
            this.requiredElementNames = new LinkedHashSet<String>();
            MyRequiredElementsFunction elementsFunction = new MyRequiredElementsFunction(this.requiredElementNames);
            this.getPattern().getContent().apply(elementsFunction);
        }
        return this.requiredElementNames;
    }

    public Collection<CMElementDeclaration> getPossibleRequiredElements() {
        LinkedHashSet<CMElementDeclaration> possibelRequiredElements = new LinkedHashSet<CMElementDeclaration>();
        if (this.possibleRequiredElementNames == null) {
            this.possibleRequiredElementNames = new LinkedHashSet<String>();
            PossibleRequiredElementsFunction elementsFunction = new PossibleRequiredElementsFunction(this.possibleRequiredElementNames);
            this.getPattern().getContent().apply(elementsFunction);
        }
        for (String elementName : this.possibleRequiredElementNames) {
            possibelRequiredElements.add(this.findCMElement(elementName, null));
        }
        List<CMElementDeclaration> sortedElements = possibelRequiredElements.stream().collect(Collectors.toList());
        Collections.sort(sortedElements, (e1, e2) -> e1.getLocalName().compareTo(e2.getLocalName()));
        return sortedElements;
    }
}

