/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple;

import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.AbstractModel;
import org.eclipse.pde.internal.core.text.IDocumentRange;
import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSModel;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSObject;
import org.eclipse.pde.internal.ua.ui.PDEUserAssistanceUIPlugin;
import org.eclipse.pde.internal.ua.ui.PDEUserAssistanceUIPluginImages;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.SimpleCSBlock;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.SimpleMessages;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDEMasterDetailsBlock;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class SimpleCSDefinitionPage
extends PDEFormPage
implements IModelChangedListener {
    public static final String PAGE_ID = "simpleCSPage";
    private final SimpleCSBlock fBlock = new SimpleCSBlock(this);
    private boolean fStale;

    public SimpleCSDefinitionPage(FormEditor editor) {
        super(editor, PAGE_ID, SimpleMessages.SimpleCSDefinitionPage_title);
    }

    protected String getHelpResource() {
        return "org.eclipse.pde.doc.user.simple_cs_editor";
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        ISimpleCSModel model = (ISimpleCSModel)this.getModel();
        if (model == null || !model.isLoaded()) {
            Exception e = null;
            if (model instanceof AbstractModel) {
                e = ((AbstractModel)model).getException();
            }
            this.createFormErrorContent(managedForm, SimpleMessages.SimpleCSDefinitionPage_loadFailure, SimpleMessages.SimpleCSDefinitionPage_errorMessage, e);
            return;
        }
        super.createFormContent(managedForm);
        form.setImage(PDEUserAssistanceUIPlugin.getDefault().getLabelProvider().get(PDEUserAssistanceUIPluginImages.DESC_CHEATSHEET_OBJ));
        String title = PDETextHelper.translateReadText((String)model.getSimpleCS().getTitle());
        if (title.length() > 0) {
            form.setText(title);
        } else {
            form.setText(SimpleMessages.SimpleCSDefinitionPage_title);
        }
        this.fBlock.createContent(managedForm);
        this.fBlock.getMastersSection().fireSelection();
        model.addModelChangedListener((IModelChangedListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form.getBody(), "org.eclipse.pde.doc.user.simple_cs_editor");
    }

    public void dispose() {
        ISimpleCSModel simpleCSModel = (ISimpleCSModel)this.getModel();
        if (simpleCSModel != null) {
            simpleCSModel.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 3) {
            String changeProperty;
            Object[] objects = event.getChangedObjects();
            if (!(objects[0] instanceof ISimpleCSObject)) {
                return;
            }
            ISimpleCSObject object = (ISimpleCSObject)objects[0];
            if (object != null && object.getType() == 0 && (changeProperty = event.getChangedProperty()) != null && changeProperty.equals("title")) {
                this.getManagedForm().getForm().setText(PDETextHelper.translateReadText((String)((String)event.getNewValue())));
            }
        } else if (event.getChangeType() == 99) {
            this.fStale = true;
        }
        this.fBlock.modelChanged(event);
    }

    public ISelection getSelection() {
        return this.fBlock.getSelection();
    }

    public PDEMasterDetailsBlock getBlock() {
        return this.fBlock;
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (!active) {
            return;
        }
        IFormPage page = this.getPDEEditor().findPage("simplecs-context");
        if (!(page instanceof PDESourcePage)) {
            return;
        }
        PDESourcePage sourcePage = (PDESourcePage)page;
        ISourceViewer viewer = sourcePage.getViewer();
        if (viewer == null) {
            return;
        }
        StyledText text = viewer.getTextWidget();
        if (text == null) {
            return;
        }
        int offset = text.getCaretOffset();
        if (offset < 0) {
            return;
        }
        IDocumentRange range = sourcePage.getRangeElement(offset, true);
        if ((range = sourcePage.adaptRange(range)) == null) {
            return;
        }
        this.fBlock.getMastersSection().setFormInput(range);
        if (this.fStale) {
            ScrolledForm form = this.getManagedForm().getForm();
            ISimpleCSModel model = (ISimpleCSModel)this.getModel();
            String oldTitle = form.getText();
            String newTitle = model.getSimpleCS().getTitle();
            if (!newTitle.equals(oldTitle)) {
                form.setText(PDETextHelper.translateReadText((String)newTitle));
            }
        }
    }
}

