/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.net.Authenticator;
import java.net.ProxySelector;
import java.text.MessageFormat;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.EclipseAuthenticator;
import org.eclipse.egit.core.EclipseProxySelector;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.EGitSshdSessionFactory;
import org.eclipse.jgit.transport.HttpTransport;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.http.HttpConnectionFactory;
import org.eclipse.jgit.transport.http.JDKHttpConnectionFactory;
import org.eclipse.jgit.transport.http.apache.HttpClientConnectionFactory;
import org.eclipse.jgit.transport.sshd.SshdSessionFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component
public class TransportConfigurator {
    private IPreferencesService preferencesService;
    private IEclipsePreferences.IPreferenceChangeListener preferenceChangeListener;

    @Reference
    void setPreferencesService(IPreferencesService service) {
        this.preferencesService = service;
    }

    @Reference
    void setWorkspace(IWorkspace workspace) {
    }

    @Activate
    void start() {
        this.setupHttp();
        this.preferenceChangeListener = event -> {
            if ("core_http_client".equals(event.getKey())) {
                this.setupHttp();
            }
        };
        InstanceScope.INSTANCE.getNode("org.eclipse.egit.core").addPreferenceChangeListener(this.preferenceChangeListener);
        SshSessionFactory.setInstance((SshSessionFactory)new EGitSshdSessionFactory(Activator.getDefault()::getProxyService));
        ProxySelector.setDefault(new EclipseProxySelector(Activator.getDefault()::getProxyService));
        Authenticator.setDefault(new EclipseAuthenticator(Activator.getDefault()::getProxyService));
    }

    @Deactivate
    void shutDown() {
        InstanceScope.INSTANCE.getNode("org.eclipse.egit.core").removePreferenceChangeListener(this.preferenceChangeListener);
        SshSessionFactory current = SshSessionFactory.getInstance();
        if (current instanceof SshdSessionFactory) {
            ((SshdSessionFactory)current).close();
        }
    }

    private void setupHttp() {
        String httpClient = this.preferencesService.getString("org.eclipse.egit.core", "core_http_client", HttpClientType.JDK.toString(), null);
        if (HttpClientType.APACHE.name().equalsIgnoreCase(httpClient)) {
            HttpTransport.setConnectionFactory((HttpConnectionFactory)new HttpClientConnectionFactory());
        } else {
            if (!HttpClientType.JDK.name().equalsIgnoreCase(httpClient)) {
                Activator.logWarning(MessageFormat.format(CoreText.Activator_HttpClientUnknown, httpClient), null);
            }
            HttpTransport.setConnectionFactory((HttpConnectionFactory)new JDKHttpConnectionFactory());
        }
    }

    private static enum HttpClientType {
        JDK,
        APACHE;

    }
}

