/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.internal.markers;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.m2e.editor.internal.Messages;
import org.eclipse.m2e.editor.internal.markers.AbstractPomProblemResolution;
import org.eclipse.m2e.editor.internal.markers.MavenMarkerResolutionGenerator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.w3c.dom.Element;

public class SchemaCompletionResolution
extends AbstractPomProblemResolution {
    public static final String XSI_VALUE = " xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\"";

    public SchemaCompletionResolution(IMarker marker) {
        super(marker);
    }

    @Override
    protected boolean canFix(String editorHint) {
        return MavenMarkerResolutionGenerator.isMissingSchema(editorHint);
    }

    public String getLabel() {
        return Messages.PomQuickAssistProcessor_name;
    }

    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD");
    }

    public String getDescription() {
        return "<html>...<br>&lt;project <b> xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\"</b>&gt;<br>...</html>";
    }

    @Override
    protected void processFix(IStructuredDocument doc, Element root, List<IMarker> markers) {
        for (IMarker marker : markers) {
            if (!"project".equals(root.getNodeName()) || !(root instanceof IndexedRegion)) continue;
            IndexedRegion off = (IndexedRegion)root;
            int offset = off.getStartOffset() + "project".length() + 1;
            if (offset <= 0) {
                return;
            }
            InsertEdit edit = new InsertEdit(offset, XSI_VALUE);
            try {
                edit.apply((IDocument)doc);
                marker.delete();
            }
            catch (Exception e) {
                this.LOG.error("Unable to insert schema info", (Throwable)e);
            }
        }
    }
}

