/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.lemminx.commons.SnippetsBuilder;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.contentmodel.model.CMAttributeDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.CMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.CMElementDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.services.extensions.ISharedSettingsRequest;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.utils.MarkupContentFactory;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lemminx.utils.XMLBuilder;
import org.eclipse.lsp4j.MarkupContent;

public class XMLGenerator {
    private final SharedSettings sharedSettings;
    private final String whitespacesIndent;
    private final String lineDelimiter;
    private final boolean canSupportSnippets;
    private final boolean autoCloseTags;
    private int maxLevel;
    private final DOMNode node;

    public XMLGenerator(SharedSettings sharedSettings, String whitespacesIndent, String lineDelimiter, boolean canSupportSnippets, int maxLevel) {
        this(sharedSettings, true, whitespacesIndent, lineDelimiter, canSupportSnippets, maxLevel, null);
    }

    public XMLGenerator(SharedSettings sharedSettings, boolean autoCloseTags, String whitespacesIndent, String lineDelimiter, boolean canSupportSnippets, int maxLevel, DOMNode node) {
        this.sharedSettings = sharedSettings;
        this.autoCloseTags = autoCloseTags;
        this.whitespacesIndent = whitespacesIndent;
        this.lineDelimiter = lineDelimiter;
        this.canSupportSnippets = canSupportSnippets;
        this.maxLevel = maxLevel;
        this.node = node;
    }

    public String generateMissingElements(ContentModelManager contentModelManager, DOMElement element, boolean generateOnlyRequired) {
        StringBuilder generatedXml = new StringBuilder();
        for (CMDocument cmDocument : contentModelManager.findCMDocument(element)) {
            CMElementDeclaration matchesCMElement = cmDocument.findCMElement(element);
            if (matchesCMElement == null) continue;
            generatedXml.append(this.generate(matchesCMElement, null, true, true, 0, generateOnlyRequired));
        }
        return generatedXml.toString();
    }

    public String getLineDelimiter() {
        return this.lineDelimiter;
    }

    public String getWhitespacesIndent() {
        return this.whitespacesIndent;
    }

    public String generate(CMElementDeclaration elementDeclaration, String prefix, boolean generateEndTag) {
        return this.generate(elementDeclaration, prefix, generateEndTag, false, 0, false);
    }

    public String generate(CMElementDeclaration elementDeclaration, String prefix, boolean generateEndTag, boolean generateOnlyChildren, int level, boolean generateOnlyRequired) {
        XMLBuilder xml = new XMLBuilder(this.sharedSettings, this.whitespacesIndent, this.lineDelimiter);
        this.generate(elementDeclaration, prefix, generateEndTag, generateOnlyChildren, level, 0, xml, new HashMap<CMElementDeclaration, List<CMElementDeclaration>>(), generateOnlyRequired);
        if (this.canSupportSnippets) {
            xml.addContent(SnippetsBuilder.tabstops(0));
        }
        if (!generateOnlyChildren && level > 0) {
            xml.linefeed();
            xml.indent(level - 1);
        }
        return xml.toString();
    }

    private int generate(CMElementDeclaration elementDeclaration, String prefix, boolean generateEndTag, boolean generateOnlyChildren, int level, int snippetIndex, XMLBuilder xml, HashMap<CMElementDeclaration, List<CMElementDeclaration>> generatedElements, boolean generateOnlyRequired) {
        boolean autoCloseTags;
        Collection<CMElementDeclaration> children;
        Collection<CMElementDeclaration> collection = children = generateOnlyRequired ? elementDeclaration.getRequiredElements() : elementDeclaration.getElements();
        if (generateOnlyChildren) {
            for (CMElementDeclaration child : children) {
                List<Object> parents = generatedElements.get(child) == null ? new ArrayList() : generatedElements.get(child);
                parents.add(elementDeclaration);
                generatedElements.put(child, parents);
                snippetIndex = this.generate(child, prefix, true, false, level + 1, snippetIndex, xml, generatedElements, generateOnlyRequired);
            }
            xml.linefeed();
            xml.indent(level);
            return snippetIndex;
        }
        if (this.isAlreadyGenerated(elementDeclaration, children, generatedElements)) {
            return snippetIndex;
        }
        boolean bl = autoCloseTags = this.autoCloseTags && generateEndTag;
        if (level > 0) {
            xml.linefeed();
            xml.indent(level);
        }
        xml.startElement(prefix, elementDeclaration.getLocalName(), false);
        Collection<CMAttributeDeclaration> attributes = elementDeclaration.getAttributes();
        snippetIndex = this.generate(attributes, level, snippetIndex, xml, elementDeclaration.getLocalName());
        if (children.size() > 0) {
            xml.closeStartElement();
            if (level < this.maxLevel) {
                for (CMElementDeclaration child : children) {
                    ++level;
                    List<Object> parents = generatedElements.get(child) == null ? new ArrayList() : generatedElements.get(child);
                    parents.add(elementDeclaration);
                    generatedElements.put(child, parents);
                    snippetIndex = this.generate(child, prefix, true, false, level, snippetIndex, xml, generatedElements, generateOnlyRequired);
                    --level;
                }
                xml.linefeed();
                xml.indent(level);
            } else if (generateEndTag && this.canSupportSnippets) {
                xml.addContent(SnippetsBuilder.tabstops(++snippetIndex));
            }
            if (generateEndTag) {
                xml.endElement(prefix, elementDeclaration.getLocalName());
            }
        } else if (elementDeclaration.isEmpty() && autoCloseTags) {
            xml.selfCloseElement();
        } else {
            xml.closeStartElement();
            Collection<String> values = elementDeclaration.getEnumerationValues();
            if (!values.isEmpty()) {
                if (this.canSupportSnippets) {
                    xml.addContent(SnippetsBuilder.choice(++snippetIndex, values));
                } else {
                    xml.addContent(values.iterator().next());
                }
            }
            if (this.canSupportSnippets) {
                xml.addContent(SnippetsBuilder.tabstops(++snippetIndex));
            }
            if (generateEndTag) {
                xml.endElement(prefix, elementDeclaration.getLocalName());
            }
        }
        return snippetIndex;
    }

    public String generate(Collection<CMAttributeDeclaration> attributes, String tagName) {
        XMLBuilder xml = new XMLBuilder(this.sharedSettings, this.whitespacesIndent, this.lineDelimiter);
        this.generate(attributes, 0, 0, xml, tagName);
        return xml.toString();
    }

    private int generate(Collection<CMAttributeDeclaration> attributes, int level, int snippetIndex, XMLBuilder xml, String tagName) {
        HashMap<String, String> prefixes = null;
        ArrayList<CMAttributeDeclaration> requiredAttributes = new ArrayList<CMAttributeDeclaration>();
        boolean generateXmlnsAttr = false;
        for (CMAttributeDeclaration att : attributes) {
            String prefix;
            if (!att.isRequired()) continue;
            requiredAttributes.add(att);
            String namespace = att.getNamespace();
            if (StringUtils.isEmpty(namespace)) continue;
            String string = prefix = prefixes != null ? (String)prefixes.get(namespace) : null;
            if (prefix == null && (prefix = this.findPrefixFromDOMNode(namespace)) == null && (prefix = att.getOwnerElementDeclaration().getPrefix(namespace)) != null && !"xml".equals(prefix)) {
                xml.addAttribute("xmlns:" + prefix, namespace, level, true);
                generateXmlnsAttr = true;
            }
            if (prefix == null) continue;
            if (prefixes == null) {
                prefixes = new HashMap<String, String>();
            }
            prefixes.put(namespace, prefix);
        }
        int attributesSize = requiredAttributes.size();
        for (CMAttributeDeclaration attributeDeclaration : requiredAttributes) {
            if (this.canSupportSnippets) {
                ++snippetIndex;
            }
            String defaultValue = attributeDeclaration.getDefaultValue();
            Collection<String> enumerationValues = attributeDeclaration.getEnumerationValues();
            String value = XMLGenerator.generateAttributeValue(defaultValue, enumerationValues, this.canSupportSnippets, snippetIndex, false, this.sharedSettings);
            String attrName = attributeDeclaration.getName(prefixes);
            if (attributesSize != 1 || generateXmlnsAttr) {
                xml.addAttribute(attrName, value, level, true);
                continue;
            }
            xml.addSingleAttribute(attrName, value, true);
        }
        return snippetIndex;
    }

    private boolean isAlreadyGenerated(CMElementDeclaration elementDeclaration, Collection<CMElementDeclaration> children, HashMap<CMElementDeclaration, List<CMElementDeclaration>> generatedElements) {
        for (CMElementDeclaration child : children) {
            if (generatedElements.get(child) == null || !generatedElements.get(child).contains(elementDeclaration)) continue;
            return true;
        }
        return false;
    }

    private String findPrefixFromDOMNode(String namespace) {
        if (this.node == null) {
            return null;
        }
        DOMElement element = null;
        if (this.node.isAttribute()) {
            element = ((DOMAttr)this.node).getOwnerElement();
        } else if (this.node.isElement()) {
            element = (DOMElement)this.node;
        } else if (this.node.isText()) {
            element = this.node.getParentElement();
        }
        if (element != null) {
            return element.getPrefix(namespace);
        }
        return null;
    }

    public static String generateAttributeValue(String defaultValue, Collection<String> enumerationValues, boolean canSupportSnippets, int snippetIndex, boolean withQuote, SharedSettings sharedSettings) {
        StringBuilder value = new StringBuilder();
        String quotation = sharedSettings.getPreferences().getQuotationAsString();
        if (withQuote) {
            value.append("=").append(quotation);
        }
        if (!canSupportSnippets) {
            if (defaultValue != null) {
                value.append(defaultValue);
            }
        } else if (enumerationValues != null && !enumerationValues.isEmpty()) {
            SnippetsBuilder.choice(snippetIndex, enumerationValues, value);
        } else if (defaultValue != null) {
            SnippetsBuilder.placeholders(snippetIndex, defaultValue, value);
        } else {
            SnippetsBuilder.tabstops(snippetIndex, value);
        }
        if (withQuote) {
            value.append(quotation);
            if (canSupportSnippets) {
                SnippetsBuilder.tabstops(0, value);
            }
        }
        return value.toString();
    }

    public static String generateDocumentation(String documentation, String schemaURI, boolean html) {
        if (StringUtils.isBlank(documentation)) {
            return null;
        }
        StringBuilder doc = new StringBuilder(documentation);
        if (schemaURI != null) {
            doc.append(System.lineSeparator());
            doc.append(System.lineSeparator());
            if (html) {
                doc.append("<p>");
            }
            doc.append("Source: ");
            if (html) {
                doc.append("<a href=\"");
                doc.append(schemaURI);
                doc.append("\">");
            }
            doc.append(XMLGenerator.getFileName(schemaURI));
            if (html) {
                doc.append("</a>");
                doc.append("</p>");
            }
        }
        return doc.toString();
    }

    private static String getFileName(String schemaURI) {
        int index = schemaURI.lastIndexOf(47);
        if (index == -1) {
            index = schemaURI.lastIndexOf(92);
        }
        if (index == -1) {
            return schemaURI;
        }
        return schemaURI.substring(index + 1, schemaURI.length());
    }

    public static MarkupContent createMarkupContent(CMElementDeclaration cmElement, ISharedSettingsRequest support) {
        String documentation = XMLGenerator.generateDocumentation(cmElement.getDocumentation(support), cmElement.getDocumentURI(), support.canSupportMarkupKind("markdown"));
        if (documentation != null) {
            return MarkupContentFactory.createMarkupContent(documentation, "markdown", support);
        }
        return null;
    }

    public static MarkupContent createMarkupContent(CMAttributeDeclaration cmAttribute, CMElementDeclaration ownerElement, ISharedSettingsRequest request) {
        String documentation = XMLGenerator.generateDocumentation(cmAttribute.getAttributeNameDocumentation(request), ownerElement.getDocumentURI(), request.canSupportMarkupKind("markdown"));
        if (documentation != null) {
            return MarkupContentFactory.createMarkupContent(documentation, "markdown", request);
        }
        return null;
    }

    public static MarkupContent createMarkupContent(CMAttributeDeclaration cmAttribute, String attributeValue, CMElementDeclaration ownerElement, ISharedSettingsRequest support) {
        String documentation = XMLGenerator.generateDocumentation(cmAttribute.getAttributeValueDocumentation(attributeValue, support), ownerElement.getDocumentURI(), support.canSupportMarkupKind("markdown"));
        if (documentation != null) {
            return MarkupContentFactory.createMarkupContent(documentation, "markdown", support);
        }
        return null;
    }

    public static MarkupContent createMarkupContent(CMElementDeclaration cmElement, String textContent, ISharedSettingsRequest support) {
        String documentation = XMLGenerator.generateDocumentation(cmElement.getTextDocumentation(textContent, support), cmElement.getDocumentURI(), support.canSupportMarkupKind("markdown"));
        if (documentation != null) {
            return MarkupContentFactory.createMarkupContent(documentation, "markdown", support);
        }
        return null;
    }
}

