/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.search.LocatorResponse;
import org.eclipse.jdt.internal.core.search.matching.DOMPatternLocator;
import org.eclipse.jdt.internal.core.search.matching.DOMTypeDeclarationLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.NodeSetWrapper;
import org.eclipse.jdt.internal.core.search.matching.SuperTypeReferenceLocator;

public class DOMSuperTypeReferenceLocator
extends DOMPatternLocator {
    private SuperTypeReferenceLocator locator;

    public DOMSuperTypeReferenceLocator(SuperTypeReferenceLocator locator) {
        super((SearchPattern)locator.pattern);
        this.locator = locator;
    }

    @Override
    public LocatorResponse match(LambdaExpression node, NodeSetWrapper nodeSet, MatchLocator locator) {
        if (this.locator.pattern.superRefKind != 1) {
            return this.toResponse(0);
        }
        nodeSet.setMustResolve(true);
        int level = nodeSet.addMatch((ASTNode)node, 2);
        return this.toResponse(level, true);
    }

    @Override
    public LocatorResponse match(Type node, NodeSetWrapper nodeSet, MatchLocator locator) {
        AbstractTypeDeclaration decl;
        ClassInstanceCreation newInst;
        ASTNode aSTNode;
        if (!Set.of(TypeDeclaration.SUPERCLASS_TYPE_PROPERTY, TypeDeclaration.SUPER_INTERFACE_TYPES_PROPERTY, ClassInstanceCreation.TYPE_PROPERTY).contains(node.getLocationInParent())) {
            return this.toResponse(0);
        }
        if (node.getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY && (aSTNode = node.getParent()) instanceof ClassInstanceCreation && (newInst = (ClassInstanceCreation)aSTNode).getAnonymousClassDeclaration() == null) {
            return this.toResponse(0);
        }
        aSTNode = node.getParent();
        if (aSTNode instanceof AbstractTypeDeclaration && !DOMTypeDeclarationLocator.matchSearchForTypeSuffix(decl = (AbstractTypeDeclaration)aSTNode, this.locator.pattern.typeSuffix)) {
            return this.toResponse(0);
        }
        if (this.locator.pattern.superSimpleName == null) {
            int level = nodeSet.addMatch((ASTNode)node, this.locator.pattern.mustResolve ? 2 : 3);
            return this.toResponse(level, true);
        }
        char[] typeRefSimpleName = null;
        if (node instanceof SimpleType) {
            SimpleName name;
            SimpleType simple = (SimpleType)node;
            Name name2 = simple.getName();
            if (name2 instanceof SimpleName) {
                name = (SimpleName)name2;
                typeRefSimpleName = name.getIdentifier().toCharArray();
            }
            if ((name2 = simple.getName()) instanceof QualifiedName) {
                name = (QualifiedName)name2;
                typeRefSimpleName = name.getName().getIdentifier().toCharArray();
            }
        } else if (node instanceof QualifiedType) {
            QualifiedType qualified = (QualifiedType)node;
            typeRefSimpleName = qualified.getName().getIdentifier().toCharArray();
        }
        if (this.locator.matchesName(this.locator.pattern.superSimpleName, typeRefSimpleName)) {
            int level = nodeSet.addMatch((ASTNode)node, this.locator.pattern.mustResolve ? 2 : 3);
            return this.toResponse(level, true);
        }
        return this.toResponse(0);
    }

    @Override
    public LocatorResponse resolveLevel(ASTNode node, IBinding binding, MatchLocator locator) {
        if (binding == null) {
            return this.toResponse(1);
        }
        if (node instanceof LambdaExpression && binding instanceof IMethodBinding) {
            IMethodBinding method = (IMethodBinding)binding;
            binding = method.getDeclaringClass();
        }
        if (!(binding instanceof ITypeBinding)) {
            return this.toResponse(0);
        }
        ITypeBinding type = (ITypeBinding)binding;
        int level = 0;
        if ((this.locator.pattern.superRefKind != 1 || node.getLocationInParent() == TypeDeclaration.SUPER_INTERFACE_TYPES_PROPERTY) && (level = this.resolveLevelForType(this.locator.pattern.superSimpleName, this.locator.pattern.superQualification, type)) > 0) {
            return this.toResponse(level);
        }
        if ((this.locator.pattern.superRefKind != 2 || node.getLocationInParent() == TypeDeclaration.SUPERCLASS_TYPE_PROPERTY) && (level = this.resolveLevelForType(this.locator.pattern.superSimpleName, this.locator.pattern.superQualification, type)) == 3) {
            return this.toResponse(3);
        }
        return this.toResponse(binding.isRecovered() ? 2 : level);
    }
}

