/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.gradle.model.impl;

import com.microsoft.java.bs.gradle.model.Artifact;
import com.microsoft.java.bs.gradle.model.GradleModuleDependency;
import com.microsoft.java.bs.gradle.model.impl.DefaultArtifact;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class DefaultGradleModuleDependency
implements GradleModuleDependency {
    private static final long serialVersionUID = 1L;
    private String group;
    private String module;
    private String version;
    private List<Artifact> artifacts;

    public DefaultGradleModuleDependency(String group, String module, String version, List<Artifact> artifacts) {
        this.group = group;
        this.module = module;
        this.version = version;
        this.artifacts = artifacts;
    }

    public DefaultGradleModuleDependency(GradleModuleDependency moduleDependency) {
        this.group = moduleDependency.getGroup();
        this.module = moduleDependency.getModule();
        this.version = moduleDependency.getVersion();
        this.artifacts = moduleDependency.getArtifacts().stream().map(DefaultArtifact::new).collect(Collectors.toList());
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    @Override
    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public List<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(List<Artifact> artifacts) {
        this.artifacts = artifacts;
    }

    public int hashCode() {
        return Objects.hash(this.group, this.module, this.version, this.artifacts);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultGradleModuleDependency other = (DefaultGradleModuleDependency)obj;
        return Objects.equals(this.group, other.group) && Objects.equals(this.module, other.module) && Objects.equals(this.version, other.version) && Objects.equals(this.artifacts, other.artifacts);
    }
}

