/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.runsonscopereduction;

import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Editor;
import org.eclipse.titanium.refactoring.Utils;
import org.eclipse.titanium.refactoring.runsonscopereduction.RunsOnScopeReductionRefactoring;
import org.eclipse.titanium.refactoring.runsonscopereduction.RunsOnScopeReductionWizard;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class RunsOnScopeReductionFromBrowser
extends AbstractHandler
implements IObjectActionDelegate {
    private ISelection selection;

    public void run(IAction action) {
        this.performRunsOnScopeReduction();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        this.performRunsOnScopeReduction();
        return null;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    private void performRunsOnScopeReduction() {
        TTCN3Editor targetEditor = Utils.getActiveEditor();
        if (!(this.selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structSelection = (IStructuredSelection)this.selection;
        Set<IProject> projsToUpdate = Utils.findAllProjectsInSelection(structSelection);
        Utils.updateASTBeforeRefactoring(projsToUpdate, "RunsOnScopeReduction");
        Activator.getDefault().pauseHandlingResourceChanges();
        RunsOnScopeReductionRefactoring refactoring = new RunsOnScopeReductionRefactoring(structSelection);
        RunsOnScopeReductionWizard wiz = new RunsOnScopeReductionWizard(refactoring);
        RefactoringWizardOpenOperation operation = new RefactoringWizardOpenOperation((RefactoringWizard)wiz);
        try {
            operation.run(targetEditor == null ? null : targetEditor.getEditorSite().getShell(), "");
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            ErrorReporter.logError((String)"RunsOnScopeReductionFromBrowser: Error while performing refactoring change! ");
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        Activator.getDefault().resumeHandlingResourceChanges();
        Utils.updateASTAfterRefactoring(wiz, refactoring.getAffectedObjects(), refactoring.getName());
    }
}

