/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.types;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.SyntacticErrorStorage;
import org.eclipse.titan.designer.AST.ASN1.Block;
import org.eclipse.titan.designer.AST.ASN1.IASN1Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISetTypeMessages;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.attributes.JsonAST;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.NamedTemplate;
import org.eclipse.titan.designer.AST.TTCN3.templates.Named_Template_List;
import org.eclipse.titan.designer.AST.TTCN3.templates.OmitValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.Template_List;
import org.eclipse.titan.designer.AST.TTCN3.types.Array_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.RecordSetCodeGenerator;
import org.eclipse.titan.designer.AST.TTCN3.types.SetOf_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.NamedValue;
import org.eclipse.titan.designer.AST.TTCN3.values.Omit_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SequenceOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Set_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ParserMarkerSupport;
import org.eclipse.titan.designer.parsers.asn1parser.Asn1Parser;
import org.eclipse.titan.designer.parsers.asn1parser.BlockLevelTokenStreamTracker;

public final class ASN1_Set_Type
extends ASN1_Set_Seq_Choice_BaseType
implements ISetTypeMessages {
    private CompilationTimeStamp trCompsofTimestamp;
    private static boolean defaultAsOptional = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.defaultAsOptional", false, null);
    private static String strictConstantCheckingSeverity;

    public ASN1_Set_Type(Block aBlock) {
        this.mBlock = aBlock;
    }

    @Override
    public IASN1Type newInstance() {
        return new ASN1_Set_Type(this.mBlock);
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_ASN1_SET;
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        return IType.Type_type.TYPE_TTCN3_SET;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (null != this.components) {
            this.components.setMyScope(scope);
        }
    }

    @Override
    public int getNofComponents() {
        if (null == this.components) {
            this.parseBlockSet();
        }
        return this.components.getNofComps();
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp) || this == temp) {
            return true;
        }
        if (info == null || noStructuredTypeCompatibility) {
            return this == temp;
        }
        switch (temp.getTypetype()) {
            case TYPE_ASN1_SET: {
                ASN1_Set_Type tempType = (ASN1_Set_Type)temp;
                if (this == tempType) {
                    return true;
                }
                if (this.getNofComponents() != tempType.getNofComponents()) {
                    info.setErrorStr("The number of fields in set/SET types must be the same");
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                int size = this.getNofComponents();
                for (int i = 0; i < size; ++i) {
                    CompField cf = this.getComponentByIndex(i);
                    CompField tempTypeCompField = tempType.getComponentByIndex(i);
                    IType compFieldType = cf.getType().getTypeRefdLast(timestamp);
                    IType tempTypeCompFieldType = tempTypeCompField.getType().getTypeRefdLast(timestamp);
                    if (cf.isOptional() != tempTypeCompField.isOptional()) {
                        String compFieldName = cf.getIdentifier().getDisplayName();
                        String tempTypeCompFieldName = tempTypeCompField.getIdentifier().getDisplayName();
                        info.appendOp1Ref("." + compFieldName);
                        info.appendOp2Ref("." + tempTypeCompFieldName);
                        info.setOp1Type(compFieldType);
                        info.setOp2Type(tempTypeCompFieldType);
                        info.setErrorStr("The optionality of fields in set/SET types must be the same");
                        return false;
                    }
                    lChain.markState();
                    rChain.markState();
                    lChain.add(compFieldType);
                    rChain.add(tempTypeCompFieldType);
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(compFieldType, tempTypeCompFieldType, false);
                    if (!(compFieldType.equals(tempTypeCompFieldType) || lChain.hasRecursion() && rChain.hasRecursion() || compFieldType.isCompatible(timestamp, tempTypeCompFieldType, infoTemp, lChain, rChain))) {
                        String compFieldName = cf.getIdentifier().getDisplayName();
                        String tempTypeCompFieldName = tempTypeCompField.getIdentifier().getDisplayName();
                        info.appendOp1Ref("." + compFieldName + infoTemp.getOp1RefStr());
                        info.appendOp2Ref("." + tempTypeCompFieldName + infoTemp.getOp2RefStr());
                        info.setOp1Type(infoTemp.getOp1Type());
                        info.setOp2Type(infoTemp.getOp2Type());
                        info.setErrorStr(infoTemp.getErrorStr());
                        lChain.previousState();
                        rChain.previousState();
                        return false;
                    }
                    lChain.previousState();
                    rChain.previousState();
                }
                info.setNeedsConversion(true);
                return true;
            }
            case TYPE_TTCN3_SET: {
                TTCN3_Set_Type tempType = (TTCN3_Set_Type)temp;
                if (this.getNofComponents() != tempType.getNofComponents()) {
                    info.setErrorStr("The number of fields in set/SET types must be the same");
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                int size = this.getNofComponents();
                for (int i = 0; i < size; ++i) {
                    CompField compField = this.getComponentByIndex(i);
                    CompField tempTypeCompField = tempType.getComponentByIndex(i);
                    IType compFieldType = compField.getType().getTypeRefdLast(timestamp);
                    IType tempTypeCompFieldType = tempTypeCompField.getType().getTypeRefdLast(timestamp);
                    if (compField.isOptional() != tempTypeCompField.isOptional()) {
                        String compFieldName = compField.getIdentifier().getDisplayName();
                        String tempTypeCompFieldName = tempTypeCompField.getIdentifier().getDisplayName();
                        info.appendOp1Ref("." + compFieldName);
                        info.appendOp2Ref("." + tempTypeCompFieldName);
                        info.setOp1Type(compFieldType);
                        info.setOp2Type(tempTypeCompFieldType);
                        info.setErrorStr("The optionality of fields in set/SET types must be the same");
                        return false;
                    }
                    lChain.markState();
                    rChain.markState();
                    lChain.add(compFieldType);
                    rChain.add(tempTypeCompFieldType);
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(compFieldType, tempTypeCompFieldType, false);
                    if (!(compFieldType.equals(tempTypeCompFieldType) || lChain.hasRecursion() && rChain.hasRecursion() || compFieldType.isCompatible(timestamp, tempTypeCompFieldType, infoTemp, lChain, rChain))) {
                        String compFieldName = compField.getIdentifier().getDisplayName();
                        String tempTypeCompFieldName = tempTypeCompField.getIdentifier().getDisplayName();
                        info.appendOp1Ref("." + compFieldName + infoTemp.getOp1RefStr());
                        info.appendOp2Ref("." + tempTypeCompFieldName + infoTemp.getOp2RefStr());
                        info.setOp1Type(infoTemp.getOp1Type());
                        info.setOp2Type(infoTemp.getOp2Type());
                        info.setErrorStr(infoTemp.getErrorStr());
                        lChain.previousState();
                        rChain.previousState();
                        return false;
                    }
                    lChain.previousState();
                    rChain.previousState();
                }
                info.setNeedsConversion(true);
                return true;
            }
            case TYPE_SET_OF: {
                SetOf_Type tempType = (SetOf_Type)temp;
                if (!tempType.isSubtypeCompatible(timestamp, this)) {
                    info.setErrorStr("Incompatible set of/SET OF subtypes");
                    return false;
                }
                int nofComps = this.getNofComponents();
                if (nofComps == 0) {
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                for (int i = 0; i < nofComps; ++i) {
                    CompField compField = this.getComponentByIndex(i);
                    IType compFieldType = compField.getType().getTypeRefdLast(timestamp);
                    IType temporalTypeOfType = tempType.getOfType().getTypeRefdLast(timestamp);
                    lChain.markState();
                    rChain.markState();
                    lChain.add(compFieldType);
                    rChain.add(temporalTypeOfType);
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(compFieldType, temporalTypeOfType, false);
                    if (!(compFieldType.equals(temporalTypeOfType) || lChain.hasRecursion() && rChain.hasRecursion() || compFieldType.isCompatible(timestamp, temporalTypeOfType, infoTemp, lChain, rChain))) {
                        info.appendOp1Ref("." + compField.getIdentifier().getDisplayName() + infoTemp.getOp1RefStr());
                        if (infoTemp.getOp2RefStr().length() > 0) {
                            info.appendOp2Ref("[]");
                        }
                        info.appendOp2Ref(infoTemp.getOp2RefStr());
                        info.setOp1Type(infoTemp.getOp1Type());
                        info.setOp2Type(infoTemp.getOp2Type());
                        info.setErrorStr(infoTemp.getErrorStr());
                        lChain.previousState();
                        rChain.previousState();
                        return false;
                    }
                    lChain.previousState();
                    rChain.previousState();
                }
                info.setNeedsConversion(true);
                return true;
            }
            case TYPE_ASN1_CHOICE: 
            case TYPE_TTCN3_CHOICE: 
            case TYPE_ANYTYPE: {
                info.setErrorStr("union/CHOICE/anytype types are compatible only with other union/CHOICE/anytype types");
                return false;
            }
            case TYPE_ASN1_SEQUENCE: 
            case TYPE_TTCN3_SEQUENCE: 
            case TYPE_SEQUENCE_OF: 
            case TYPE_ARRAY: {
                info.setErrorStr("set/SET and set of/SET OF types are compatible only with other set/SET and set of/SET OF types");
                return false;
            }
        }
        return false;
    }

    @Override
    public String getOutlineIcon() {
        return "set.gif";
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("set");
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (this.components == null) {
            return;
        }
        if (referenceChain.add(this)) {
            for (int i = 0; i < this.components.getNofComps(); ++i) {
                CompField field = this.components.getCompByIndex(i);
                Type t = field.getType();
                if (field.isOptional() || t == null) continue;
                referenceChain.markState();
                t.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        Module module;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (this.components != null && this.myScope != null && (module = this.myScope.getModuleScope()) != null && module.getSkippedFromSemanticChecking()) {
            this.lastTimeChecked = timestamp;
            return;
        }
        this.isErroneous = false;
        if (this.components == null) {
            this.parseBlockSet();
        }
        if (this.isErroneous || this.components == null) {
            return;
        }
        this.trCompsof(timestamp, null);
        this.components.check(timestamp);
        if (this.constraints != null) {
            this.constraints.check(timestamp);
        }
        if (this.myScope != null) {
            this.checkEncode(timestamp);
            this.checkVariants(timestamp);
        }
    }

    @Override
    public boolean checkThisValue(CompilationTimeStamp timestamp, IValue value, Assignment lhs, IType.ValueCheckingOptions valueCheckingOptions) {
        if (this.getIsErroneous(timestamp)) {
            return false;
        }
        boolean selfReference = super.checkThisValue(timestamp, value, lhs, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (last == null || last.getIsErroneous(timestamp)) {
            return selfReference;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return selfReference;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return selfReference;
            }
        }
        switch (last.getValuetype()) {
            case SEQUENCE_VALUE: {
                last = last.setValuetype(timestamp, IValue.Value_type.SET_VALUE);
                if (last.isAsn()) {
                    selfReference = this.checkThisValueSet_A(timestamp, (Set_Value)last, lhs, valueCheckingOptions.expected_value, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                    break;
                }
                selfReference = this.checkThisValueSet_T(timestamp, (Set_Value)last, lhs, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                break;
            }
            case SEQUENCEOF_VALUE: {
                if (((SequenceOf_Value)last).isIndexed()) {
                    value.getLocation().reportSemanticError(MessageFormat.format("Indexed assignment notation cannot be used for SET type `{0}''", this.getFullName()));
                    value.setIsErroneous(true);
                    break;
                }
                SequenceOf_Value temporalValue = (SequenceOf_Value)last;
                if (temporalValue.getNofComponents() == 0) {
                    if (this.getNofComponents() == 0) {
                        last = last.setValuetype(timestamp, IValue.Value_type.SET_VALUE);
                        break;
                    }
                    value.getLocation().reportSemanticError(MessageFormat.format("A non-empty value was expected for type `{0}''", this.getFullName()));
                    value.setIsErroneous(true);
                    break;
                }
                value.getLocation().reportSemanticError(MessageFormat.format(last.isAsn() ? "Value list notation cannot be used for SET type `{0}''" : "Value list notation cannot be used for set type `{0}''", this.getFullName()));
                value.setIsErroneous(true);
                break;
            }
            case SET_VALUE: {
                if (last.isAsn()) {
                    selfReference = this.checkThisValueSet_A(timestamp, (Set_Value)last, lhs, valueCheckingOptions.expected_value, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                    break;
                }
                selfReference = this.checkThisValueSet_T(timestamp, (Set_Value)last, lhs, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                break;
            }
            case UNDEFINED_BLOCK: {
                last = last.setValuetype(timestamp, IValue.Value_type.SET_VALUE);
                selfReference = this.checkThisValueSet_A(timestamp, (Set_Value)last, lhs, valueCheckingOptions.expected_value, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                break;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                break;
            }
            default: {
                value.getLocation().reportSemanticError(MessageFormat.format(last.isAsn() ? "SET value was expected for type `{0}''" : "set value was expected for type `{0}''", this.getFullName()));
                value.setIsErroneous(true);
            }
        }
        value.setLastTimeChecked(timestamp);
        return selfReference;
    }

    private boolean checkThisValueSet_T(CompilationTimeStamp timestamp, Set_Value value, Assignment lhs, Expected_Value_type expectedValue, boolean incompleteAllowed, boolean implicitOmit, boolean strElem) {
        boolean selfReference = false;
        HashMap<String, NamedValue> componentMap = new HashMap<String, NamedValue>();
        value.removeGeneratedValues();
        int nofValueComponents = value.getNofComponents();
        for (int i = 0; i < nofValueComponents; ++i) {
            NamedValue namedValue = value.getSequenceValueByIndex(i);
            Identifier valueId = namedValue.getName();
            if (!this.hasComponentWithName(valueId)) {
                namedValue.getLocation().reportSemanticError(MessageFormat.format("Reference to a non-existent field `{0}'' in set value for type `{1}''", namedValue.getName().getDisplayName(), this.getTypename()));
                continue;
            }
            if (componentMap.containsKey(valueId.getName())) {
                namedValue.getLocation().reportSemanticError(MessageFormat.format("Duplicated set field `{0}''", valueId.getDisplayName()));
                ((NamedValue)componentMap.get(valueId.getName())).getLocation().reportSingularSemanticError(MessageFormat.format("Field `{0}'' is already given here", valueId.getDisplayName()));
            } else {
                componentMap.put(valueId.getName(), namedValue);
            }
            CompField componentField = this.getComponentByName(valueId);
            Type type = componentField.getType();
            IValue componentValue = namedValue.getValue();
            if (componentValue == null) continue;
            componentValue.setMyGovernor(type);
            IValue temporalValue = type.checkThisValueRef(timestamp, componentValue);
            boolean isOptional = componentField.isOptional();
            if (!isOptional && componentField.hasDefault() && defaultAsOptional) {
                isOptional = true;
            }
            selfReference |= type.checkThisValue(timestamp, temporalValue, lhs, new IType.ValueCheckingOptions(expectedValue, incompleteAllowed, isOptional, true, implicitOmit, strElem));
        }
        if (!incompleteAllowed || implicitOmit || !"ignore".equals(strictConstantCheckingSeverity)) {
            int nofTypeComponents = this.getNofComponents();
            for (int i = 0; i < nofTypeComponents; ++i) {
                CompField field = this.getComponentByIndex(i);
                Identifier id = field.getIdentifier();
                if (componentMap.containsKey(id.getName())) continue;
                if (field.isOptional() && implicitOmit) {
                    value.addNamedValue(new NamedValue(new Identifier(Identifier.Identifier_type.ID_ASN, id.getDisplayName()), new Omit_Value(), false));
                    continue;
                }
                value.getLocation().reportConfigurableSemanticProblem(strictConstantCheckingSeverity, MessageFormat.format("Field `{0}'' is missing from set value", id.getDisplayName()));
            }
        }
        value.setLastTimeChecked(timestamp);
        return selfReference;
    }

    private boolean checkThisValueSet_A(CompilationTimeStamp timestamp, Set_Value value, Assignment lhs, Expected_Value_type expectedValue, boolean implicitOmit, boolean strElem) {
        boolean selfReference = false;
        HashMap<String, NamedValue> componentMap = new HashMap<String, NamedValue>();
        value.removeGeneratedValues();
        int nofValueComponents = value.getNofComponents();
        for (int i = 0; i < nofValueComponents; ++i) {
            NamedValue namedValue = value.getSequenceValueByIndex(i);
            Identifier valueId = namedValue.getName();
            if (!this.hasComponentWithName(valueId)) {
                namedValue.getLocation().reportSemanticError(MessageFormat.format("Reference to a non-existent component `{0}'' of SET type `{1}''", namedValue.getName().getDisplayName(), this.getTypename()));
                continue;
            }
            if (componentMap.containsKey(valueId.getName())) {
                namedValue.getLocation().reportSemanticError(MessageFormat.format("Duplicated SET component `{0}''", valueId.getDisplayName()));
                ((NamedValue)componentMap.get(valueId.getName())).getLocation().reportSingularSemanticError(MessageFormat.format("Component `{0}'' is already given here", valueId.getDisplayName()));
            } else {
                componentMap.put(valueId.getName(), namedValue);
            }
            CompField componentField = this.getComponentByName(valueId);
            Type type = componentField.getType();
            IValue componentValue = namedValue.getValue();
            if (componentValue == null) continue;
            componentValue.setMyGovernor(type);
            IValue temporalValue = type.checkThisValueRef(timestamp, componentValue);
            selfReference |= type.checkThisValue(timestamp, temporalValue, lhs, new IType.ValueCheckingOptions(expectedValue, false, false, true, implicitOmit, strElem));
        }
        int nofTypeComponents = this.getNofComponents();
        for (int i = 0; i < nofTypeComponents; ++i) {
            CompField field = this.getComponentByIndex(i);
            Identifier id = field.getIdentifier();
            if (componentMap.containsKey(id.getName())) continue;
            if (field.isOptional() && implicitOmit) {
                value.addNamedValue(new NamedValue(new Identifier(Identifier.Identifier_type.ID_ASN, id.getDisplayName()), new Omit_Value(), false));
                continue;
            }
            if (field.isOptional() || field.hasDefault()) continue;
            value.getLocation().reportSemanticError(MessageFormat.format("Mandatory component `{0}'' is missing from SET value", id.getDisplayName()));
        }
        value.setLastTimeChecked(timestamp);
        return selfReference;
    }

    @Override
    public boolean checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit, Assignment lhs) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        boolean selfReference = false;
        switch (template.getTemplatetype()) {
            case TEMPLATE_LIST: {
                if (((Template_List)template).getNofTemplates() > 0) {
                    template.getLocation().reportSemanticError(MessageFormat.format("Value list notation is not allowed for set type `{0}''", this.getFullName()));
                    break;
                }
                if (this.getNofComponents() > 0) {
                    template.getLocation().reportSemanticError(MessageFormat.format("A non-empty set template was expected for type `{0}''", this.getFullName()));
                    break;
                }
                ITTCN3Template transformed = template.setTemplatetype(timestamp, ITTCN3Template.Template_type.NAMED_TEMPLATE_LIST);
                selfReference = this.checkThisNamedTemplateList(timestamp, (Named_Template_List)transformed, isModified, implicitOmit, lhs);
                break;
            }
            case NAMED_TEMPLATE_LIST: {
                selfReference = this.checkThisNamedTemplateList(timestamp, (Named_Template_List)template, isModified, implicitOmit, lhs);
                break;
            }
            default: {
                template.getLocation().reportSemanticError(MessageFormat.format("{0} cannot be used for set type `{1}''", template.getTemplateTypeName(), this.getTypename()));
            }
        }
        if (template.getLengthRestriction() != null) {
            template.getLocation().reportSemanticError("Length restriction is not allowed for set type `{0}''");
        }
        return selfReference;
    }

    private boolean checkThisNamedTemplateList(CompilationTimeStamp timestamp, Named_Template_List templateList, boolean isModified, boolean implicitOmit, Assignment lhs) {
        int i;
        templateList.removeGeneratedValues();
        boolean selfReference = false;
        HashMap<String, NamedTemplate> componentMap = new HashMap<String, NamedTemplate>();
        int nofTypeComponents = this.getNofComponents();
        int nofTemplateComponents = templateList.getNofTemplates();
        for (i = 0; i < nofTemplateComponents; ++i) {
            NamedTemplate namedTemplate = templateList.getTemplateByIndex(i);
            Identifier identifier = namedTemplate.getName();
            String templateName = identifier.getName();
            if (this.hasComponentWithName(identifier)) {
                if (componentMap.containsKey(templateName)) {
                    namedTemplate.getLocation().reportSemanticError(MessageFormat.format("Duplicate field `{0}'' in template", identifier.getDisplayName()));
                    ((NamedTemplate)componentMap.get(templateName)).getLocation().reportSemanticError(MessageFormat.format("Field `{0}'' is already given here", identifier.getDisplayName()));
                } else {
                    componentMap.put(templateName, namedTemplate);
                }
                CompField componentField = this.getComponentByName(identifier);
                Type type = componentField.getType();
                if (type == null || type.getIsErroneous(timestamp)) continue;
                ITTCN3Template componentTemplate = namedTemplate.getTemplate();
                componentTemplate.setMyGovernor(type);
                componentTemplate = type.checkThisTemplateRef(timestamp, componentTemplate);
                boolean isOptional = componentField.isOptional();
                if (!isOptional && componentField.hasDefault() && defaultAsOptional) {
                    isOptional = true;
                }
                selfReference |= componentTemplate.checkThisTemplateGeneric(timestamp, type, isModified, isOptional, isOptional, true, implicitOmit, lhs);
                continue;
            }
            namedTemplate.getLocation().reportSemanticError(MessageFormat.format("Reference to non-existing field `{0}'' in set template for type `{1}''", identifier.getDisplayName(), this.getTypename()));
        }
        if (!isModified || implicitOmit || !"ignore".equals(strictConstantCheckingSeverity)) {
            for (i = 0; i < nofTypeComponents; ++i) {
                Identifier identifier = this.getComponentIdentifierByIndex(i);
                if (componentMap.containsKey(identifier.getName())) continue;
                if (this.getComponentByIndex(i).isOptional() && implicitOmit) {
                    templateList.addNamedValue(new NamedTemplate(new Identifier(Identifier.Identifier_type.ID_ASN, identifier.getDisplayName()), new OmitValue_Template(), false));
                    continue;
                }
                if (isModified && "ignore".equals(strictConstantCheckingSeverity)) continue;
                templateList.getLocation().reportConfigurableSemanticProblem(strictConstantCheckingSeverity, MessageFormat.format("Field `{0}'' is missing from template for set type `{1}''", identifier.getDisplayName(), this.getTypename()));
            }
        }
        return selfReference;
    }

    private void parseBlockSet() {
        if (null == this.mBlock) {
            return;
        }
        Asn1Parser parser = BlockLevelTokenStreamTracker.getASN1ParserForBlock(this.mBlock);
        if (null == parser) {
            return;
        }
        this.components = parser.pr_special_ComponentTypeLists().list;
        List<SyntacticErrorStorage> errors = parser.getErrorStorage();
        if (null != errors && !errors.isEmpty()) {
            this.isErroneous = true;
            this.components = null;
            for (int i = 0; i < errors.size(); ++i) {
                ParserMarkerSupport.createOnTheFlyMixedMarker((IFile)this.mBlock.getLocation().getFile(), errors.get(i), 2);
            }
        }
        if (this.components == null) {
            this.isErroneous = true;
            return;
        }
        this.components.setFullNameParent(this);
        this.components.setMyScope(this.getMyScope());
        this.components.setMyType(this);
    }

    public void trCompsof(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (this.trCompsofTimestamp != null && !this.trCompsofTimestamp.isLess(timestamp)) {
            return;
        }
        if (referenceChain != null) {
            this.components.trCompsof(timestamp, referenceChain, false);
        } else {
            ReferenceChain temporalReferenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            this.components.trCompsof(timestamp, temporalReferenceChain, false);
            temporalReferenceChain.release();
        }
        this.trCompsofTimestamp = timestamp;
        this.components.trCompsof(timestamp, null, true);
    }

    @Override
    public void checkCodingAttributes(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        this.checkJson(timestamp);
        if (refChain.contains(this)) {
            return;
        }
        refChain.add(this);
        refChain.markState();
        for (int i = 0; i < this.getNofComponents(); ++i) {
            CompField cf = this.getComponentByIndex(i);
            cf.getType().checkCodingAttributes(timestamp, refChain);
        }
        refChain.previousState();
    }

    @Override
    public void forceJson(CompilationTimeStamp timestamp) {
        if (this.jsonAttribute == null) {
            this.jsonAttribute = new JsonAST();
        }
    }

    @Override
    public void checkJson(CompilationTimeStamp timestamp) {
        if (this.jsonAttribute == null && !this.hasEncodeAttribute("JSON")) {
            return;
        }
        for (int i = 0; i < this.getNofComponents(); ++i) {
            Type fieldType = this.getComponentByIndex(i).getType();
            fieldType.forceJson(timestamp);
        }
        if (this.jsonAttribute == null) {
            return;
        }
        if (this.jsonAttribute.omit_as_null && !this.isOptionalField()) {
            this.getLocation().reportSemanticError("Invalid attribute, 'omit as null' requires optional field of a record or set.");
        }
        if (this.jsonAttribute.as_value) {
            this.getLocation().reportSemanticError("Invalid attribute, 'as value' is only allowed for unions, the anytype, or records or sets with one field");
        }
        if (this.jsonAttribute.alias != null) {
            IType parent = this.getParentType();
            if (parent == null) {
                this.getLocation().reportSemanticError("Invalid attribute, 'name as ...' requires field of a record, set or union.");
            } else {
                switch (parent.getTypetype()) {
                    case TYPE_TTCN3_SET: 
                    case TYPE_TTCN3_CHOICE: 
                    case TYPE_ANYTYPE: 
                    case TYPE_TTCN3_SEQUENCE: {
                        break;
                    }
                    default: {
                        this.getLocation().reportSemanticError("Invalid attribute, 'name as ...' requires field of a record, set or union.");
                    }
                }
            }
            if (parent != null && parent.getJsonAttribute() != null && parent.getJsonAttribute().as_value) {
                switch (parent.getTypetype()) {
                    case TYPE_TTCN3_CHOICE: 
                    case TYPE_ANYTYPE: {
                        this.getLocation().reportSemanticWarning(MessageFormat.format("Attribute 'name as ...' will be ignored, because parent {0} is encoded without field names.", parent.getTypename()));
                        break;
                    }
                    case TYPE_TTCN3_SET: 
                    case TYPE_TTCN3_SEQUENCE: {
                        if (((TTCN3_Set_Seq_Choice_BaseType)parent).getNofComponents() != 1) break;
                        this.getLocation().reportSemanticWarning(MessageFormat.format("Attribute 'name as ...' will be ignored, because parent {0} is encoded without field names.", parent.getTypename()));
                        break;
                    }
                }
            }
        }
        if (this.jsonAttribute.parsed_default_value != null) {
            this.checkJsonDefault(timestamp);
        }
        if (this.jsonAttribute.metainfo_unbound && (this.getParentType() == null || this.getParentType().getTypetype() != IType.Type_type.TYPE_TTCN3_SEQUENCE && this.getParentType().getTypetype() != IType.Type_type.TYPE_TTCN3_SET)) {
            this.getLocation().reportSemanticError("Invalid attribute 'metainfo for unbound', requires record, set, record of, set of, array or field of a record or set");
        }
        if (this.jsonAttribute.as_number) {
            this.getLocation().reportSemanticError("Invalid attribute, 'as number' is only allowed for enumerated types");
        }
        if (this.jsonAttribute.as_map) {
            this.getLocation().reportSemanticError("Invalid attribute, 'as map' requires record of or set of");
        }
        if (this.jsonAttribute.enum_texts.size() > 0) {
            this.getLocation().reportSemanticError("Invalid attribute, 'text ... as ...' requires an enumerated type");
        }
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return null;
            }
            case fieldSubReference: {
                Identifier id = subreference.getId();
                CompField compField = this.components.getCompByName(id);
                if (compField == null) {
                    subreference.getLocation().reportSemanticError(MessageFormat.format("Reference to a non-existent field `{0}'' in type `{1}''", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                    return null;
                }
                if (interruptIfOptional && compField.isOptional()) {
                    return null;
                }
                Expected_Value_type internalExpectation = expectedIndex == Expected_Value_type.EXPECTED_TEMPLATE ? Expected_Value_type.EXPECTED_DYNAMIC_VALUE : expectedIndex;
                return compField.getType().getFieldType(timestamp, reference, actualSubReference + 1, internalExpectation, refChain, interruptIfOptional);
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public boolean getSubrefsAsArray(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, List<Integer> subrefsArray, List<IType> typeArray) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return true;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return false;
            }
            case fieldSubReference: {
                Identifier id = subreference.getId();
                CompField compField = this.components.getCompByName(id);
                if (compField == null) {
                    subreference.getLocation().reportSemanticError(MessageFormat.format("Reference to a non-existent field `{0}'' in type `{1}''", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                    return false;
                }
                Type fieldType = compField.getType();
                if (fieldType == null) {
                    return false;
                }
                int fieldIndex = this.components.indexOf(compField);
                subrefsArray.add(fieldIndex);
                typeArray.add(this);
                return fieldType.getSubrefsAsArray(timestamp, reference, actualSubReference + 1, subrefsArray, typeArray);
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return false;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return false;
    }

    @Override
    public String getGenNameValue(JavaGenData aData, StringBuilder source) {
        return this.getGenNameOwn(aData);
    }

    @Override
    public String getGenNameTemplate(JavaGenData aData, StringBuilder source) {
        return this.getGenNameOwn(aData).concat("_template");
    }

    @Override
    public String getGenNameTypeDescriptor(JavaGenData aData, StringBuilder source) {
        String baseName = this.getGenNameTypeName(aData, source);
        return baseName + "." + this.getGenNameOwn();
    }

    @Override
    public boolean generatesOwnClass(JavaGenData aData, StringBuilder source) {
        return true;
    }

    @Override
    public String getGenNameJsonDescriptor(JavaGenData aData, StringBuilder source) {
        return this.getGenNameOwn(aData) + "." + this.getGenNameOwn() + "_json_";
    }

    @Override
    public String getGenNameBerDescriptor(JavaGenData aData, StringBuilder source) {
        return "SET_ber_";
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        CompField compField;
        int i;
        if (this.lastTimeGenerated != null && !this.lastTimeGenerated.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeGenerated = aData.getBuildTimstamp();
        String className = this.getGenNameOwn();
        String classReadableName = this.getFullName();
        StringBuilder localTypeDescriptor = new StringBuilder();
        HashMap<String, String> attributeRegistry = new HashMap<String, String>();
        this.generateCodeTypedescriptor(aData, source, localTypeDescriptor, attributeRegistry);
        this.generateCodeDefaultCoding(aData, source, localTypeDescriptor);
        StringBuilder localCodingHandler = new StringBuilder();
        this.generateCodeForCodingHandlers(aData, source, localCodingHandler);
        ArrayList<RecordSetCodeGenerator.FieldInfo> namesList = new ArrayList<RecordSetCodeGenerator.FieldInfo>();
        boolean hasOptional = false;
        for (i = 0; i < this.components.getNofComps(); ++i) {
            boolean ofType;
            compField = this.components.getCompByIndex(i);
            Type cfType = compField.getType();
            IType lastType = cfType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
            switch (lastType.getTypetype()) {
                case TYPE_SET_OF: 
                case TYPE_SEQUENCE_OF: {
                    ofType = true;
                    break;
                }
                default: {
                    ofType = false;
                }
            }
            switch (cfType.getTypetype()) {
                case TYPE_ASN1_SET: 
                case TYPE_SET_OF: 
                case TYPE_ASN1_CHOICE: 
                case TYPE_ASN1_SEQUENCE: 
                case TYPE_SEQUENCE_OF: 
                case TYPE_ASN1_ENUMERATED: {
                    if (cfType.generatesOwnClass(aData, source)) break;
                    cfType.generateCodeTypedescriptor(aData, source, localTypeDescriptor, attributeRegistry);
                    cfType.generateCodeDefaultCoding(aData, source, localTypeDescriptor);
                    cfType.generateCodeForCodingHandlers(aData, source, localCodingHandler);
                    break;
                }
                default: {
                    cfType.generateCodeTypedescriptor(aData, source, localTypeDescriptor, attributeRegistry);
                    cfType.generateCodeDefaultCoding(aData, source, localTypeDescriptor);
                    cfType.generateCodeForCodingHandlers(aData, source, localCodingHandler);
                }
            }
            JsonAST jsonAttribute = cfType.getJsonAttribute();
            RecordSetCodeGenerator.FieldInfo fi = new RecordSetCodeGenerator.FieldInfo(cfType.getGenNameValue(aData, source), cfType.getGenNameTemplate(aData, source), compField.getIdentifier().getName(), compField.getIdentifier().getDisplayName(), compField.isOptional(), ofType, compField.getType().getClass().getSimpleName(), cfType.getGenNameTypeDescriptor(aData, source), jsonAttribute != null ? jsonAttribute.metainfo_unbound : false, jsonAttribute != null ? jsonAttribute.parsed_default_value : null, null, jsonAttribute != null ? jsonAttribute.alias : null, jsonAttribute != null ? jsonAttribute.omit_as_null : false);
            hasOptional |= compField.isOptional();
            namesList.add(fi);
        }
        for (i = 0; i < this.components.getNofComps(); ++i) {
            compField = this.components.getCompByIndex(i);
            StringBuilder tempSource = aData.getCodeForType(compField.getType().getGenNameOwn());
            compField.getType().generateCode(aData, tempSource);
            if (!compField.hasDefault()) continue;
            Value defaultValue = compField.getDefault();
            StringBuilder defaultValueSource = new StringBuilder();
            Type type = compField.getType();
            String typeGeneratedName = type.getGenNameValue(aData, defaultValueSource);
            if (type.getTypetype().equals((Object)IType.Type_type.TYPE_ARRAY)) {
                Array_Type arrayType = (Array_Type)type;
                StringBuilder temp_sb = aData.getCodeForType(arrayType.getGenNameOwn());
                arrayType.generateCodeValue(aData, temp_sb);
            }
            defaultValueSource.append(MessageFormat.format("\tpublic static final {0} {1} = new {0}();\n", typeGeneratedName, defaultValue.get_lhs_name()));
            defaultValue.generateCodeInit(aData, aData.getPreInit(), defaultValue.getGenNameOwn());
            aData.addGlobalVariable(typeGeneratedName, defaultValueSource.toString());
        }
        boolean hasRaw = this.getGenerateCoderFunctions(IType.MessageEncoding_type.RAW);
        boolean hasJson = this.getGenerateCoderFunctions(IType.MessageEncoding_type.JSON);
        boolean jsonAsValue = this.jsonAttribute != null ? this.jsonAttribute.as_value : false;
        boolean jsonAsMapPossible = this.jsonAttribute != null ? this.jsonAttribute.as_map : false;
        RecordSetCodeGenerator.generateValueClass(aData, source, className, classReadableName, namesList, hasOptional, true, hasRaw, null, hasJson, jsonAsValue, jsonAsMapPossible, localTypeDescriptor, localCodingHandler);
        RecordSetCodeGenerator.generateTemplateClass(aData, source, className, classReadableName, namesList, hasOptional, true);
    }

    @Override
    public boolean isPresentAnyvalueEmbeddedField(ExpressionStruct expression, List<ISubReference> subreferences, int beginIndex) {
        if (subreferences == null || this.getIsErroneous(CompilationTimeStamp.getBaseTimestamp())) {
            return true;
        }
        if (beginIndex >= subreferences.size()) {
            return true;
        }
        ISubReference subReference = subreferences.get(beginIndex);
        if (!(subReference instanceof FieldSubReference)) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous type reference `" + this.getFullName() + "''"));
            expression.expression.append("FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n");
            return true;
        }
        Identifier fieldId = ((FieldSubReference)subReference).getId();
        CompField compField = this.getComponentByName(fieldId);
        if (compField.isOptional()) {
            return false;
        }
        return compField.getType().isPresentAnyvalueEmbeddedField(expression, subreferences, beginIndex + 1);
    }

    @Override
    public String generateConversion(JavaGenData aData, IType fromType, String fromName, boolean forValue, ExpressionStruct expression) {
        IType refdType = fromType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        if (refdType == null || this == refdType) {
            return fromName;
        }
        switch (refdType.getTypetype()) {
            case TYPE_TTCN3_SET: {
                TTCN3_Set_Seq_Choice_BaseType realFromType = (TTCN3_Set_Seq_Choice_BaseType)refdType;
                return this.generateConversionTTCNSetSeqToASNSetSeq(aData, realFromType, fromName, forValue, expression);
            }
            case TYPE_ASN1_SET: {
                ASN1_Set_Seq_Choice_BaseType realFromType = (ASN1_Set_Seq_Choice_BaseType)refdType;
                return this.generateConversionASNSetSeqToASNSetSeq(aData, realFromType, fromName, forValue, expression);
            }
        }
        expression.expression.append(MessageFormat.format("//FIXME conversion from {0} to {1} is not needed or nor supported yet\n", fromType.getTypename(), this.getTypename()));
        return fromName;
    }

    static {
        Activator activator = Activator.getDefault();
        if (activator != null) {
            activator.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    String property = event.getProperty();
                    if ("org.eclipse.titan.designer.defaultAsOptional".equals(property)) {
                        defaultAsOptional = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.defaultAsOptional", false, null);
                    }
                }
            });
        }
        strictConstantCheckingSeverity = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportStrictConstants", "warning", null);
        activator = Activator.getDefault();
        if (activator != null) {
            activator.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    String property = event.getProperty();
                    if ("org.eclipse.titan.designer.reportStrictConstants".equals(property)) {
                        strictConstantCheckingSeverity = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportStrictConstants", "warning", null);
                    }
                }
            });
        }
    }
}

